/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.advancement;

import com.google.gson.JsonObject;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_195;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class PullCartCriterion<T extends AbstractDrawnEntity>
extends class_4558<TriggerInstance> {
    private final String cartName;

    public PullCartCriterion(String cartName) {
        this.cartName = cartName;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject jsonObject, class_5258 contextAwarePredicate, class_5257 deserializationContext) {
        float minDist = jsonObject.getAsJsonPrimitive("distance").getAsFloat();
        int minPassengerCount = jsonObject.getAsJsonPrimitive("passengers").getAsInt();
        return new TriggerInstance(minDist, minPassengerCount, contextAwarePredicate);
    }

    public TriggerInstance create(float minDist, int minPassengerCount) {
        return new TriggerInstance(minDist, minPassengerCount, class_5258.field_24388);
    }

    public void trigger(class_3222 serverPlayer, AbstractDrawnEntity entity, float dist) {
        super.method_22510(serverPlayer, t -> t.matches(entity, dist));
    }

    @NotNull
    public class_2960 method_794() {
        return new class_2960("niftycarts", "pull_cart_" + this.cartName);
    }

    public final class TriggerInstance
    extends class_195 {
        private final float minDistance;
        private final int minPassengerCount;

        public TriggerInstance(float minDistance, int minPassengerCount, class_5258 contextAwarePredicate) {
            super(PullCartCriterion.this.method_794(), contextAwarePredicate);
            this.minDistance = minDistance;
            this.minPassengerCount = minPassengerCount;
        }

        public boolean matches(AbstractDrawnEntity entity, float distance) {
            return distance >= this.minDistance && entity.method_5685().size() >= this.minPassengerCount;
        }

        @NotNull
        public JsonObject method_807(class_5267 serializationContext) {
            JsonObject jsonObject = super.method_807(serializationContext);
            jsonObject.addProperty("distance", (Number)Float.valueOf(this.minDistance));
            jsonObject.addProperty("passengers", (Number)this.minPassengerCount);
            return jsonObject;
        }
    }
}

