/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts;

import com.google.common.collect.ImmutableMap;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.NiftyCartsWoodType;
import net.jmb19905.niftycarts.advancement.CartAddBannerCriterion;
import net.jmb19905.niftycarts.advancement.PlaceCartItemCriterion;
import net.jmb19905.niftycarts.advancement.PullCartCriterion;
import net.jmb19905.niftycarts.advancement.PullFilledCartCriterion;
import net.jmb19905.niftycarts.advancement.ReaperHarvestCriterion;
import net.jmb19905.niftycarts.advancement.SeedDrillPlaceCriterion;
import net.jmb19905.niftycarts.advancement.SteerCartCriterion;
import net.jmb19905.niftycarts.advancement.UsePlowCriterion;
import net.jmb19905.niftycarts.container.PlowMenu;
import net.jmb19905.niftycarts.container.SeedDrillMenu;
import net.jmb19905.niftycarts.entity.AnimalCartEntity;
import net.jmb19905.niftycarts.entity.HandCartEntity;
import net.jmb19905.niftycarts.entity.PlowEntity;
import net.jmb19905.niftycarts.entity.PostilionEntity;
import net.jmb19905.niftycarts.entity.ReaperCartEntity;
import net.jmb19905.niftycarts.entity.SeedDrillEntity;
import net.jmb19905.niftycarts.entity.SupplyCartEntity;
import net.jmb19905.niftycarts.entity.WagonEntity;
import net.jmb19905.niftycarts.entity.ai.goal.AvoidCartGoal;
import net.jmb19905.niftycarts.entity.ai.goal.PullCartGoal;
import net.jmb19905.niftycarts.entity.ai.goal.RideCartGoal;
import net.jmb19905.niftycarts.item.CartItem;
import net.jmb19905.niftycarts.network.serverbound.ActionKeyMessage;
import net.jmb19905.niftycarts.network.serverbound.OpenSupplyCartMessage;
import net.jmb19905.niftycarts.network.serverbound.RequestCartUpdate;
import net.jmb19905.niftycarts.network.serverbound.ToggleSlowMessage;
import net.jmb19905.niftycarts.util.GoalAdder;
import net.jmb19905.niftycarts.util.NiftyWorld;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class NiftyCarts
implements ModInitializer {
    public static final String MOD_ID = "niftycarts";
    public static final class_1792 WHEEL = new class_1792((class_1792.class_1793)new FabricItemSettings());
    private static final BiFunction<NiftyCartsWoodType, String, CartItem> CART_ITEM_SUPPLIER = (woodType, type) -> new CartItem((NiftyCartsWoodType)((Object)woodType), (String)type, (class_1792.class_1793)new FabricItemSettings().maxCount(1));
    public static final Map<NiftyCartsWoodType, CartItem> SUPPLY_CART = new HashMap<NiftyCartsWoodType, CartItem>();
    public static final Map<NiftyCartsWoodType, CartItem> HAND_CART = new HashMap<NiftyCartsWoodType, CartItem>();
    public static final Map<NiftyCartsWoodType, CartItem> PLOW = new HashMap<NiftyCartsWoodType, CartItem>();
    public static final Map<NiftyCartsWoodType, CartItem> SEED_DRILL = new HashMap<NiftyCartsWoodType, CartItem>();
    public static final Map<NiftyCartsWoodType, CartItem> REAPER = new HashMap<NiftyCartsWoodType, CartItem>();
    public static final Map<NiftyCartsWoodType, CartItem> ANIMAL_CART = new HashMap<NiftyCartsWoodType, CartItem>();
    public static final Map<NiftyCartsWoodType, CartItem> WAGON = new HashMap<NiftyCartsWoodType, CartItem>();
    public static MinecraftServer server;
    public static final class_2960 ATTACH_SOUND_ID;
    public static final class_2960 DETACH_SOUND_ID;
    public static final class_2960 PLACE_SOUND_ID;
    public static final class_3414 ATTACH_SOUND;
    public static final class_3414 DETACH_SOUND;
    public static final class_3414 PLACE_SOUND;
    public static final class_1299<SupplyCartEntity> SUPPLY_CART_ENTITY;
    public static final class_1299<HandCartEntity> HAND_CART_ENTITY;
    public static final class_1299<AnimalCartEntity> ANIMAL_CART_ENTITY;
    public static final class_1299<PlowEntity> PLOW_ENTITY;
    public static final class_1299<SeedDrillEntity> SEED_DRILL_ENTITY;
    public static final class_1299<ReaperCartEntity> REAPER_ENTITY;
    public static final class_1299<WagonEntity> WAGON_ENTITY;
    public static final class_1299<PostilionEntity> POSTILION_ENTITY;
    public static final class_2960 ACTION_KEY_MESSAGE_ID;
    public static final class_2960 TOGGLE_SLOW_MESSAGE_ID;
    public static final class_2960 UPDATE_DRAWN_MESSAGE_ID;
    public static final class_2960 REQUEST_CART_UPDATE_MESSAGE_ID;
    public static final class_2960 OPEN_SUPPLY_MESSAGE_ID;
    public static final GoalAdder<class_1308> MOB_GOAL_ADDER;
    public static final GoalAdder<class_1314> PATHFINDER_GOAL_ADDER;
    public static final class_3917<PlowMenu> PLOW_MENU_TYPE;
    public static final class_3917<SeedDrillMenu> SEED_DRILL_MENU_TYPE;
    public static final class_3917<class_1707> CHEST_9x4_MENU_TYPE;
    public static final class_3917<class_1707> CHEST_9x8_MENU_TYPE;
    public static final class_3917<class_1707> CHEST_9x12_MENU_TYPE;
    public static final Map<class_1299<?>, class_2960> CART_PULL_CM;
    public static final class_2960 RIDE_CART_CM;
    public static final class_2960 STEER_ANIMAL_CART_CM;
    public static final class_2960 STEER_REAPER_CM;
    public static final class_6862<class_2248> PLOW_BREAKABLE_HOE;
    public static final class_6862<class_2248> PLOW_BREAKABLE_SHOVEL;
    public static final class_6862<class_2248> PLOW_BREAKABLE_AXE;
    public static final class_6862<class_2248> REAPER_HARVESTABLE;
    public static final class_6862<class_1792> SEED_DRILL_PLANTABLE;
    public static final SeedDrillPlaceCriterion SEED_DRILL_PLACE_CRITERION;
    public static final PlaceCartItemCriterion PLACE_CART_CRITERION;
    public static final UsePlowCriterion USE_PLOW_CRITERION;
    public static final CartAddBannerCriterion CART_ADD_BANNER_CRITERION;
    public static final ReaperHarvestCriterion REAPER_HARVEST_CRITERION;
    public static final PullCartCriterion<HandCartEntity> PULL_HAND_CART_CRITERION;
    public static final PullCartCriterion<WagonEntity> PULL_WAGON_CRITERION;
    public static final SteerCartCriterion STEER_ANIMAL_CART_CRITERION;
    public static final PullFilledCartCriterion PULL_FILLED_CART_CRITERION;

    private static void registerStat(class_2960 id, class_3446 formatter) {
        class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)id, (Object)id);
        class_3468.field_15419.method_14955((Object)id, formatter);
    }

    public void onInitialize() {
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.COMMON, (IConfigSpec)NiftyCartsConfig.spec());
        for (class_2960 stat : CART_PULL_CM.values()) {
            NiftyCarts.registerStat(stat, class_3446.field_16977);
        }
        NiftyCarts.registerStat(RIDE_CART_CM, class_3446.field_16977);
        NiftyCarts.registerStat(STEER_ANIMAL_CART_CM, class_3446.field_16977);
        NiftyCarts.registerStat(STEER_REAPER_CM, class_3446.field_16977);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "wheel"), (Object)WHEEL);
        for (NiftyCartsWoodType woodType : NiftyCartsWoodType.values()) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_supply_cart"), (Object)((Object)SUPPLY_CART.get((Object)woodType)));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_hand_cart"), (Object)((Object)HAND_CART.get((Object)woodType)));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_plow"), (Object)((Object)PLOW.get((Object)woodType)));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_seed_drill"), (Object)((Object)SEED_DRILL.get((Object)woodType)));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_reaper"), (Object)((Object)REAPER.get((Object)woodType)));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_animal_cart"), (Object)((Object)ANIMAL_CART.get((Object)woodType)));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, woodType.getId() + "_wagon"), (Object)((Object)WAGON.get((Object)woodType)));
        }
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(MOD_ID, "plow"), PLOW_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(MOD_ID, "seed_drill"), SEED_DRILL_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(MOD_ID, "chest_four_rows"), CHEST_9x4_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(MOD_ID, "chest_eight_rows"), CHEST_9x8_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(MOD_ID, "chest_quad"), CHEST_9x12_MENU_TYPE);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(content -> content.method_45421((class_1935)WHEEL));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> {
            for (NiftyCartsWoodType woodType : NiftyCartsWoodType.values()) {
                content.method_45421((class_1935)SUPPLY_CART.get((Object)woodType));
                content.method_45421((class_1935)HAND_CART.get((Object)woodType));
                content.method_45421((class_1935)PLOW.get((Object)woodType));
                content.method_45421((class_1935)SEED_DRILL.get((Object)woodType));
                content.method_45421((class_1935)REAPER.get((Object)woodType));
                content.method_45421((class_1935)ANIMAL_CART.get((Object)woodType));
                content.method_45421((class_1935)WAGON.get((Object)woodType));
            }
        });
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ATTACH_SOUND_ID, (Object)ATTACH_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)DETACH_SOUND_ID, (Object)DETACH_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)PLACE_SOUND_ID, (Object)PLACE_SOUND);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ACTION_KEY_MESSAGE_ID, (server, player, handler, buf, responseSender) -> ActionKeyMessage.handle(null, player));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TOGGLE_SLOW_MESSAGE_ID, (server, player, handler, buf, responseSender) -> ToggleSlowMessage.handle((class_1657)player));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OPEN_SUPPLY_MESSAGE_ID, (server, player, handler, buf, responseSender) -> OpenSupplyCartMessage.handle((class_1657)player));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_CART_UPDATE_MESSAGE_ID, (server, player, handler, buf, responseSender) -> {
            RequestCartUpdate msg = new RequestCartUpdate();
            msg.decode(buf);
            RequestCartUpdate.handle(msg, player);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            server = s;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            server = null;
        });
        ServerTickEvents.END_SERVER_TICK.register(e -> {
            for (class_5321 levelKey : e.method_29435()) {
                NiftyWorld.getServer(server, (class_5321<class_1937>)levelKey).tick();
            }
        });
        UseEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> {
            class_1309 rider = entity.method_5642();
            if (rider instanceof PostilionEntity) {
                rider.method_5848();
            }
            return class_1269.field_5811;
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            MOB_GOAL_ADDER.onEntityJoinWorld(entity);
            PATHFINDER_GOAL_ADDER.onEntityJoinWorld(entity);
        });
        FabricDefaultAttributeRegistry.register(POSTILION_ENTITY, (class_5132.class_5133)class_1309.method_26827());
    }

    static {
        for (NiftyCartsWoodType woodType2 : NiftyCartsWoodType.values()) {
            SUPPLY_CART.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "supply_cart"));
            HAND_CART.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "hand_cart"));
            PLOW.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "plow"));
            SEED_DRILL.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "seed_drill"));
            REAPER.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "reaper"));
            ANIMAL_CART.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "animal_cart"));
            WAGON.put(woodType2, CART_ITEM_SUPPLIER.apply(woodType2, "wagon"));
        }
        server = null;
        ATTACH_SOUND_ID = new class_2960(MOD_ID, "entity.cart.attach");
        DETACH_SOUND_ID = new class_2960(MOD_ID, "entity.cart.detach");
        PLACE_SOUND_ID = new class_2960(MOD_ID, "entity.cart.place");
        ATTACH_SOUND = class_3414.method_47908((class_2960)ATTACH_SOUND_ID);
        DETACH_SOUND = class_3414.method_47908((class_2960)DETACH_SOUND_ID);
        PLACE_SOUND = class_3414.method_47908((class_2960)PLACE_SOUND_ID);
        SUPPLY_CART_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "supply_cart"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, SupplyCartEntity::new).dimensions(class_4048.method_18385((float)1.5f, (float)1.4f)).build());
        HAND_CART_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "hand_cart"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, HandCartEntity::new).dimensions(class_4048.method_18385((float)1.3f, (float)1.1f)).build());
        ANIMAL_CART_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "animal_cart"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, AnimalCartEntity::new).dimensions(class_4048.method_18385((float)1.3f, (float)1.4f)).build());
        PLOW_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "plow"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, PlowEntity::new).dimensions(class_4048.method_18385((float)1.3f, (float)1.4f)).build());
        SEED_DRILL_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "seed_drill"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, SeedDrillEntity::new).dimensions(class_4048.method_18385((float)1.3f, (float)1.4f)).build());
        REAPER_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "reaper"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, ReaperCartEntity::new).dimensions(class_4048.method_18385((float)1.3f, (float)1.4f)).build());
        WAGON_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "wagon"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, WagonEntity::new).dimensions(class_4048.method_18385((float)2.5f, (float)3.0f)).build());
        POSTILION_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, "postilion"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, PostilionEntity::new).dimensions(class_4048.method_18385((float)0.25f, (float)0.25f)).disableSummon().disableSaving().build());
        ACTION_KEY_MESSAGE_ID = new class_2960(MOD_ID, "action_key");
        TOGGLE_SLOW_MESSAGE_ID = new class_2960(MOD_ID, "toggle_slow");
        UPDATE_DRAWN_MESSAGE_ID = new class_2960(MOD_ID, "update_drawn");
        REQUEST_CART_UPDATE_MESSAGE_ID = new class_2960(MOD_ID, "request_cart_update");
        OPEN_SUPPLY_MESSAGE_ID = new class_2960(MOD_ID, "open_supply");
        MOB_GOAL_ADDER = GoalAdder.mobGoal(class_1308.class).add(1, PullCartGoal::new).add(1, RideCartGoal::new).build();
        PATHFINDER_GOAL_ADDER = GoalAdder.mobGoal(class_1314.class).add(3, mob -> new AvoidCartGoal<SupplyCartEntity>((class_1314)mob, SupplyCartEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal<PlowEntity>((class_1314)mob, PlowEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal<SeedDrillEntity>((class_1314)mob, SeedDrillEntity.class, 2.0f, 0.5)).add(3, mob -> new AvoidCartGoal<ReaperCartEntity>((class_1314)mob, ReaperCartEntity.class, 2.0f, 0.5)).build();
        PLOW_MENU_TYPE = new class_3917(PlowMenu::new, class_7701.field_40183);
        SEED_DRILL_MENU_TYPE = new class_3917(SeedDrillMenu::new, class_7701.field_40183);
        CHEST_9x4_MENU_TYPE = new class_3917((i, inv) -> new class_1707(CHEST_9x4_MENU_TYPE, i, inv, (class_1263)new class_1277(36), 4), class_7701.field_40183);
        CHEST_9x8_MENU_TYPE = new class_3917((i, inv) -> new class_1707(CHEST_9x8_MENU_TYPE, i, inv, (class_1263)new class_1277(72), 8), class_7701.field_40183);
        CHEST_9x12_MENU_TYPE = new class_3917((i, inv) -> new class_1707(CHEST_9x12_MENU_TYPE, i, inv, (class_1263)new class_1277(108), 12), class_7701.field_40183);
        CART_PULL_CM = ImmutableMap.of(SUPPLY_CART_ENTITY, (Object)new class_2960(MOD_ID, "supply_cart_pull_cm"), HAND_CART_ENTITY, (Object)new class_2960(MOD_ID, "hand_cart_pull_cm"), ANIMAL_CART_ENTITY, (Object)new class_2960(MOD_ID, "animal_cart_pull_cm"), PLOW_ENTITY, (Object)new class_2960(MOD_ID, "plow_pull_cm"), REAPER_ENTITY, (Object)new class_2960(MOD_ID, "reaper_pull_cm"), SEED_DRILL_ENTITY, (Object)new class_2960(MOD_ID, "seed_drill_pull_cm"), WAGON_ENTITY, (Object)new class_2960(MOD_ID, "wagon_pull_cm"));
        RIDE_CART_CM = new class_2960(MOD_ID, "ride_cart_cm");
        STEER_ANIMAL_CART_CM = new class_2960(MOD_ID, "steer_animal_cart_cm");
        STEER_REAPER_CM = new class_2960(MOD_ID, "steer_reaper_cm");
        PLOW_BREAKABLE_HOE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "plow_breakable/hoe"));
        PLOW_BREAKABLE_SHOVEL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "plow_breakable/shovel"));
        PLOW_BREAKABLE_AXE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "plow_breakable/axe"));
        REAPER_HARVESTABLE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "reaper_harvestable"));
        SEED_DRILL_PLANTABLE = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(MOD_ID, "seed_drill_plantable"));
        SEED_DRILL_PLACE_CRITERION = (SeedDrillPlaceCriterion)class_174.method_767((class_179)new SeedDrillPlaceCriterion());
        PLACE_CART_CRITERION = (PlaceCartItemCriterion)class_174.method_767((class_179)new PlaceCartItemCriterion());
        USE_PLOW_CRITERION = (UsePlowCriterion)class_174.method_767((class_179)new UsePlowCriterion());
        CART_ADD_BANNER_CRITERION = (CartAddBannerCriterion)class_174.method_767((class_179)new CartAddBannerCriterion());
        REAPER_HARVEST_CRITERION = (ReaperHarvestCriterion)class_174.method_767((class_179)new ReaperHarvestCriterion());
        PULL_HAND_CART_CRITERION = (PullCartCriterion)class_174.method_767(new PullCartCriterion("hand_cart"));
        PULL_WAGON_CRITERION = (PullCartCriterion)class_174.method_767(new PullCartCriterion("supply_cart"));
        STEER_ANIMAL_CART_CRITERION = (SteerCartCriterion)class_174.method_767((class_179)new SteerCartCriterion());
        PULL_FILLED_CART_CRITERION = (PullFilledCartCriterion)class_174.method_767((class_179)new PullFilledCartCriterion());
    }
}

