/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.io.serialization;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.util.LinkedHashMap;
import java.util.Objects;
import xaero.pac.common.misc.ConfigUtil;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;

public class PlayerConfigSerializer {
    private TomlParser parser = new TomlParser();
    private TomlWriter writer = new TomlWriter();

    public String serialize(PlayerConfig<?> config) {
        return this.writer.writeToString((UnmodifiableConfig)config.getStorage());
    }

    public void deserializeInto(PlayerConfig<?> config, String serializedData) {
        CommentedConfig parsedData = CommentedConfig.of(LinkedHashMap::new, (ConfigFormat)TomlFormat.instance());
        this.parser.parse(serializedData, (Config)parsedData, ParsingMode.ADD);
        if (!(config instanceof PlayerSubConfig)) {
            config.getManager().getPlayerConfigSpec().correct(parsedData);
        }
        Object loadedConfig = config.getPlayerId() != null && !Objects.equals(config.getPlayerId(), PlayerConfig.SERVER_CLAIM_UUID) && !Objects.equals(config.getPlayerId(), PlayerConfig.EXPIRED_CLAIM_UUID) ? ConfigUtil.deepCopy((UnmodifiableConfig)parsedData, LinkedHashMap::new) : parsedData;
        config.setStorage((Config)loadedConfig);
        config.getManager().getAllOptionsStream().forEach(arg_0 -> PlayerConfigSerializer.lambda$deserializeInto$0((Config)loadedConfig, config, arg_0));
    }

    private static /* synthetic */ void lambda$deserializeInto$0(Config loadedConfig, PlayerConfig config, IPlayerConfigOptionSpecAPI o) {
        Object rawOptionValue = loadedConfig.get(o.getPath());
        if (rawOptionValue != null && rawOptionValue.getClass() != o.getType()) {
            Object defaultRawValue = config.getDefaultRawValue(o);
            if (defaultRawValue == null) {
                loadedConfig.remove(o.getPath());
            } else {
                loadedConfig.set(o.getPath(), defaultRawValue);
            }
        }
    }
}

