/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import de.cristelknight.doapi.DoApi;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_583;
import org.jetbrains.annotations.Nullable;

public class CustomArmorSet<T extends class_1309> {
    private final Set<class_1792> armor;
    private class_2960 texture;
    private class_583<T> outerModel;
    private class_583<T> innerModel;
    private class_583<T> hatModel;

    public CustomArmorSet(class_1792 ... armor) {
        this.armor = Set.of(armor);
    }

    public CustomArmorSet<T> setTexture(class_2960 texture) {
        String path = texture.method_12832();
        this.texture = !path.contains("/") || !path.contains(".") ? new class_2960(texture.method_12836(), "textures/models/armor/" + path + ".png") : texture;
        return this;
    }

    public CustomArmorSet<T> setOuterModel(class_583<T> model) {
        this.outerModel = model;
        return this;
    }

    public CustomArmorSet<T> setInnerModel(class_583<T> model) {
        this.innerModel = model;
        return this;
    }

    public CustomArmorSet<T> setHatModel(class_583<T> model) {
        this.hatModel = model;
        return this;
    }

    public Set<class_1792> getArmor() {
        return this.armor;
    }

    public class_2960 getTexture(String string) {
        String path;
        int dotIndex;
        if (string != null && (dotIndex = (path = this.texture.toString()).lastIndexOf(46)) != -1) {
            String basePath = path.substring(0, dotIndex);
            String extension = path.substring(dotIndex);
            String newPath = basePath + "_" + string + extension;
            return new class_2960(newPath);
        }
        return this.texture;
    }

    @Nullable
    public class_583<T> getModel(class_1304 slot) {
        if (slot == class_1304.field_6169) {
            if (this.hatModel == null) {
                DoApi.LOGGER.warn("Add a hat model to the armor set: " + this.texture.toString());
            }
            return this.hatModel;
        }
        if (this.usesInnerModel(slot)) {
            if (this.innerModel == null) {
                DoApi.LOGGER.warn("Add a inner model to the armor set: " + this.texture.toString());
            }
            return this.innerModel;
        }
        if (this.outerModel == null) {
            DoApi.LOGGER.warn("Add a outer model to the armor set: " + this.texture.toString());
        }
        return this.outerModel;
    }

    private boolean usesInnerModel(class_1304 equipmentSlot) {
        return equipmentSlot == class_1304.field_6172;
    }
}

