/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.packets;

import com.b1n_ry.yigd.client.gui.GraveOverviewGui;
import com.b1n_ry.yigd.client.gui.GraveSelectionGui;
import com.b1n_ry.yigd.client.gui.PlayerSelectionGui;
import com.b1n_ry.yigd.client.gui.screens.GraveOverviewScreen;
import com.b1n_ry.yigd.client.gui.screens.GraveSelectionScreen;
import com.b1n_ry.yigd.client.gui.screens.PlayerSelectionScreen;
import com.b1n_ry.yigd.client.render.GraveBlockEntityRenderer;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.packets.LightGraveData;
import com.b1n_ry.yigd.packets.LightPlayerData;
import com.b1n_ry.yigd.packets.PacketIdentifiers;
import com.mojang.authlib.GameProfile;
import io.github.cottonmc.cotton.gui.GuiDescription;
import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ClientPacketHandler {
    public static void registerReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_OVERVIEW_S2C, (client, handler, buf, responseSender) -> {
            class_2487 componentNbt = buf.method_10798();
            if (componentNbt == null) {
                return;
            }
            boolean canRestore = buf.readBoolean();
            boolean canRob = buf.readBoolean();
            boolean canDelete = buf.readBoolean();
            boolean canUnlock = buf.readBoolean();
            boolean obtainableKeys = buf.readBoolean();
            boolean obtainableCompass = buf.readBoolean();
            GraveComponent component = GraveComponent.fromNbt(componentNbt, null);
            client.execute(() -> client.method_1507((class_437)new GraveOverviewScreen((GuiDescription)new GraveOverviewGui(component, client.field_1755, canRestore, canRob, canDelete, canUnlock, obtainableKeys, obtainableCompass))));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.GRAVE_SELECTION_S2C, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            ArrayList<LightGraveData> data = new ArrayList<LightGraveData>();
            for (int i = 0; i < size; ++i) {
                class_2487 nbtData = buf.method_10798();
                if (nbtData == null) continue;
                data.add(LightGraveData.fromNbt(nbtData));
            }
            GameProfile profile = buf.method_43623();
            client.execute(() -> client.method_1507((class_437)new GraveSelectionScreen((GuiDescription)new GraveSelectionGui(data, profile, client.field_1755))));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.PLAYER_SELECTION_S2C, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            ArrayList<LightPlayerData> data = new ArrayList<LightPlayerData>();
            for (int i = 0; i < size; ++i) {
                class_2487 nbtData = buf.method_10798();
                if (nbtData == null) continue;
                data.add(LightPlayerData.fromNbt(nbtData));
            }
            client.execute(() -> client.method_1507((class_437)new PlayerSelectionScreen((GuiDescription)new PlayerSelectionGui(data, client.field_1755))));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CONFIG_SYNC_S2C, (client, handler, buf, responseBuilder) -> {
            boolean breakableGraves = buf.readBoolean();
            boolean glowingGraves = buf.readBoolean();
            int glowingMaxDistance = buf.readInt();
            double deathSightRange = buf.readDouble();
            YigdConfig.getConfig().graveConfig.retrieveMethods.onBreak = breakableGraves;
            GraveBlockEntityRenderer.syncedGlowing = glowingGraves;
            GraveBlockEntityRenderer.syncedGlowingMaxDistance = glowingMaxDistance;
            GraveBlockEntityRenderer.syncedDeathSightDistance = deathSightRange;
        });
    }

    public static void sendRestoreGraveRequestPacket(UUID graveId, boolean itemsInGrave, boolean itemsDeleted, boolean itemsKept, boolean itemsDropped) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        buf.writeBoolean(itemsInGrave);
        buf.writeBoolean(itemsDeleted);
        buf.writeBoolean(itemsKept);
        buf.writeBoolean(itemsDropped);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_RESTORE_C2S, (class_2540)buf);
    }

    public static void sendRobGraveRequestPacket(UUID graveId, boolean itemsInGrave, boolean itemsDeleted, boolean itemsKept, boolean itemsDropped) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        buf.writeBoolean(itemsInGrave);
        buf.writeBoolean(itemsDeleted);
        buf.writeBoolean(itemsKept);
        buf.writeBoolean(itemsDropped);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_ROBBING_C2S, (class_2540)buf);
    }

    public static void sendDeleteGraveRequestPacket(UUID graveId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_DELETE_C2S, (class_2540)buf);
    }

    public static void sendGraveLockRequestPacket(UUID graveId, boolean locked) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        buf.writeBoolean(locked);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_LOCKING_C2S, (class_2540)buf);
    }

    public static void sendObtainKeysRequestPacket(UUID graveId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_OBTAIN_KEYS_C2S, (class_2540)buf);
    }

    public static void sendObtainCompassRequestPacket(UUID graveId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_OBTAIN_COMPASS_C2S, (class_2540)buf);
    }

    public static void sendGraveOverviewRequest(UUID graveId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(graveId);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_OVERVIEW_REQUEST_C2S, (class_2540)buf);
    }

    public static void sendGraveSelectionRequest(GameProfile profile) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_43616(profile);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.GRAVE_SELECT_REQUEST_C2S, (class_2540)buf);
    }

    public static void sendConfigUpdate(YigdConfig config) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10817((Enum)config.graveConfig.claimPriority);
        buf.method_10817((Enum)config.graveConfig.graveRobbing.robPriority);
        ClientPlayNetworking.send((class_2960)PacketIdentifiers.CONFIG_UPDATE_C2S, (class_2540)buf);
    }
}

