/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.events;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.config.ExtraFeaturesConfig;
import com.b1n_ry.yigd.config.GraveConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.ListMode;
import com.b1n_ry.yigd.events.AllowBlockUnderGraveGenerationEvent;
import com.b1n_ry.yigd.events.AllowGraveGenerationEvent;
import com.b1n_ry.yigd.events.DropItemEvent;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.events.GraveClaimEvent;
import com.b1n_ry.yigd.events.GraveGenerationEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.YigdTags;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1291;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class YigdServerEventHandler {
    public static void registerEventCallbacks() {
        YigdServerEventHandler.registerPermissionEvents();
        DropRuleEvent.EVENT.register((item, slot, context, modify) -> {
            class_2487 nbt;
            YigdConfig config = YigdConfig.getConfig();
            class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(new class_2960("amethyst_imbuement", "soulbinding"));
            if (config.inventoryConfig.soulboundSlots.contains(slot)) {
                return DropRule.KEEP;
            }
            if (config.inventoryConfig.vanishingSlots.contains(slot)) {
                return DropRule.DESTROY;
            }
            if (config.inventoryConfig.dropOnGroundSlots.contains(slot)) {
                return DropRule.DROP;
            }
            if (item.method_31573(YigdTags.NATURAL_SOULBOUND)) {
                return DropRule.KEEP;
            }
            if (item.method_31573(YigdTags.NATURAL_VANISHING)) {
                return DropRule.DESTROY;
            }
            if (item.method_31573(YigdTags.GRAVE_INCOMPATIBLE)) {
                return DropRule.DROP;
            }
            if (statusEffect != null && context != null && context.player().method_6088().containsKey(statusEffect)) {
                return DropRule.KEEP;
            }
            if (!item.method_7960() && item.method_7985() && (nbt = item.method_7969()) != null && nbt.method_10545("Botania_keepIvy") && nbt.method_10577("Botania_keepIvy")) {
                if (modify) {
                    item.method_7983("Botania_keepIvy");
                }
                return DropRule.KEEP;
            }
            DropRule dropRule = context != null ? GraveOverrideAreas.INSTANCE.getDropRuleFromArea(class_2338.method_49638((class_2374)context.deathPos()), context.world()) : GraveOverrideAreas.INSTANCE.defaultDropRule;
            class_2499 enchantmentsNbt = item.method_7921();
            HashSet<class_2487> removeEnchantment = new HashSet<class_2487>();
            for (class_2520 enchantmentElement : enchantmentsNbt) {
                if (!(enchantmentElement instanceof class_2487)) continue;
                class_2487 enchantNbt = (class_2487)enchantmentElement;
                String id = enchantNbt.method_10558("id");
                if (config.inventoryConfig.vanishingEnchantments.contains(id)) {
                    return DropRule.DESTROY;
                }
                if (!config.inventoryConfig.soulboundEnchantments.contains(id)) continue;
                int level = enchantNbt.method_10550("lvl");
                if (config.inventoryConfig.loseSoulboundLevelOnDeath && modify) {
                    if (level == 1) {
                        removeEnchantment.add(enchantNbt);
                    } else {
                        enchantNbt.method_10569("lvl", level - 1);
                    }
                }
                dropRule = DropRule.KEEP;
                break;
            }
            enchantmentsNbt.removeAll(removeEnchantment);
            return dropRule;
        });
        GraveClaimEvent.EVENT.register((player, world, pos, grave, tool) -> {
            if (player.method_29504()) {
                return false;
            }
            YigdConfig config = YigdConfig.getConfig();
            if (config.extraFeatures.graveCompass.consumeOnUse || config.extraFeatures.graveCompass.pointToClosest != ExtraFeaturesConfig.GraveCompassConfig.CompassGraveTarget.DISABLED) {
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 stack = inventory.method_5438(i);
                    if (!stack.method_31574(class_1802.field_8251)) continue;
                    if (config.extraFeatures.graveCompass.consumeOnUse) {
                        UUID graveId;
                        class_2487 stackNbt = stack.method_7969();
                        if (!stack.method_31574(class_1802.field_8251) || stackNbt == null || !stackNbt.method_10545("linked_grave") || !(graveId = stackNbt.method_25926("linked_grave")).equals(grave.getGraveId())) continue;
                        stack.method_7939(0);
                        break;
                    }
                    GraveCompassHelper.updateClosestNbt((class_5321<class_1937>)world.method_27983(), player.method_24515(), player.method_5667(), stack);
                }
            }
            if (config.extraFeatures.graveKeys.enabled) {
                if (tool.method_31574((class_1792)Yigd.GRAVE_KEY_ITEM)) {
                    class_2487 nbt = tool.method_7948();
                    class_2487 userNbt = nbt.method_10562("user");
                    class_2520 uuidNbt = nbt.method_10580("grave");
                    ExtraFeaturesConfig.GraveKeyConfig.KeyTargeting targeting = config.extraFeatures.graveKeys.targeting;
                    switch (targeting) {
                        case ANY_GRAVE: {
                            tool.method_7934(1);
                            return true;
                        }
                        case PLAYER_GRAVE: {
                            if (!Objects.equals(class_2512.method_10683((class_2487)userNbt), grave.getOwner())) break;
                            tool.method_7934(1);
                            return true;
                        }
                        case SPECIFIC_GRAVE: {
                            if (uuidNbt == null || !Objects.equals(class_2512.method_25930((class_2520)uuidNbt), grave.getGraveId())) break;
                            tool.method_7934(1);
                            return true;
                        }
                    }
                }
                if (config.extraFeatures.graveKeys.required) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_key"), true);
                    return false;
                }
            }
            if (config.graveConfig.requireShovelToLoot && !tool.method_31573(class_3489.field_42615)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.no_shovel"), true);
                return false;
            }
            if (player.method_5667().equals(grave.getOwner().getId())) {
                return true;
            }
            if (!grave.isLocked()) {
                return true;
            }
            GraveConfig.GraveRobbing robConfig = config.graveConfig.graveRobbing;
            if (!robConfig.enabled) {
                return false;
            }
            if (robConfig.killerSkipWaitTime && player.method_5667().equals(grave.getKillerId())) {
                return true;
            }
            int tps = 20;
            if (!grave.hasExistedTicks(robConfig.timeUnit.toSeconds(robConfig.afterTime) * 20L)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.rob.too_early", (Object[])new Object[]{grave.getTimeUntilRobbable()}), true);
                return false;
            }
            return true;
        });
        AllowGraveGenerationEvent.EVENT.register((context, grave) -> {
            GraveConfig graveConfig = YigdConfig.getConfig().graveConfig;
            if (!graveConfig.enabled) {
                return false;
            }
            if (DeathInfoManager.INSTANCE.getGraveListMode() == ListMode.WHITELIST && !DeathInfoManager.INSTANCE.isInList(context.player().method_7334()) || DeathInfoManager.INSTANCE.getGraveListMode() == ListMode.BLACKLIST && DeathInfoManager.INSTANCE.isInList(context.player().method_7334())) {
                Yigd.LOGGER.info("{} found on whitelist/blacklist, disallowing grave generation", (Object)context.player().method_7334().getName());
                return false;
            }
            if (!graveConfig.generateEmptyGraves && grave.isGraveEmpty()) {
                return false;
            }
            if (graveConfig.dimensionBlacklist.contains(grave.getWorldRegistryKey().method_29177().toString())) {
                return false;
            }
            if (!graveConfig.generateGraveInVoid && grave.getPos().method_10264() < context.world().method_31607()) {
                return false;
            }
            if (graveConfig.requireItem) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(graveConfig.requiredItem));
                if (!grave.getInventoryComponent().removeItem(stack -> stack.method_31574(item), graveConfig.requiredItemCount)) {
                    return false;
                }
            }
            return !graveConfig.ignoredDeathTypes.contains(context.deathSource().method_5525());
        });
        AllowBlockUnderGraveGenerationEvent.EVENT.register((grave, currentUnder) -> YigdConfig.getConfig().graveConfig.blockUnderGrave.enabled && currentUnder.method_26164(YigdTags.REPLACE_SOFT_WHITELIST));
        GraveGenerationEvent.EVENT.register((world, pos, nthTry) -> {
            if (world.method_31606(pos) || !world.method_8621().method_11952(pos)) {
                return false;
            }
            class_2680 state = world.method_8320(pos);
            GraveConfig config = YigdConfig.getConfig().graveConfig;
            if (world.method_8321(pos) != null) {
                return false;
            }
            switch (nthTry) {
                case 0: {
                    if (!config.useSoftBlockWhitelist) {
                        return false;
                    }
                    if (state.method_26164(YigdTags.REPLACE_SOFT_WHITELIST)) break;
                    return false;
                }
                case 1: {
                    if (!config.useStrictBlockBlacklist) {
                        return false;
                    }
                    if (!state.method_26164(YigdTags.KEEP_STRICT_BLACKLIST)) break;
                    return false;
                }
            }
            return true;
        });
        DropItemEvent.EVENT.register((stack, x, y, z, world) -> !stack.method_7960());
    }

    private static void registerPermissionEvents() {
        PermissionCheckEvent.EVENT.register((source, permission) -> {
            if (permission.equals("yigd.command.locking") && !YigdConfig.getConfig().graveConfig.unlockable) {
                return TriState.FALSE;
            }
            return TriState.DEFAULT;
        });
    }
}

