/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.data;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class TranslatableDeathMessage {
    private final String damageTypeId;
    private final String killedDisplayName;
    @Nullable
    private final String sourceDisplayName;
    @Nullable
    private final String attackerDisplayName;
    @Nullable
    private String itemDisplayName;
    @Nullable
    private final String primeAdversaryDisplayName;

    public TranslatableDeathMessage(class_1282 deathSource, class_1309 killed) {
        class_1309 livingAttacker;
        class_1799 killingWeapon;
        this.damageTypeId = deathSource.method_5525();
        this.killedDisplayName = killed.method_5476().getString();
        class_1297 source = deathSource.method_5526();
        class_1297 attacker = deathSource.method_5529();
        this.sourceDisplayName = source != null ? source.method_5476().getString() : null;
        this.attackerDisplayName = attacker != null ? attacker.method_5476().getString() : null;
        this.itemDisplayName = null;
        if (attacker instanceof class_1309 && !(killingWeapon = (livingAttacker = (class_1309)attacker).method_6047()).method_7960() && killingWeapon.method_7938()) {
            this.itemDisplayName = livingAttacker.method_6047().method_7954().getString();
        }
        this.primeAdversaryDisplayName = killed.method_6124() != null ? killed.method_6124().method_5476().getString() : null;
    }

    public TranslatableDeathMessage(String damageTypeId, String killedDisplayName, @Nullable String sourceDisplayName, @Nullable String attackerDisplayName, @Nullable String itemDisplayName, @Nullable String primeAdversaryDisplayName) {
        this.damageTypeId = damageTypeId;
        this.killedDisplayName = killedDisplayName;
        this.sourceDisplayName = sourceDisplayName;
        this.attackerDisplayName = attackerDisplayName;
        this.itemDisplayName = itemDisplayName;
        this.primeAdversaryDisplayName = primeAdversaryDisplayName;
    }

    public class_5250 getDeathMessage() {
        String string = "death.attack." + this.damageTypeId;
        if (this.attackerDisplayName != null || this.sourceDisplayName != null) {
            String killedBy;
            String string2 = killedBy = this.attackerDisplayName == null ? this.sourceDisplayName : this.attackerDisplayName;
            if (this.itemDisplayName != null) {
                return class_2561.method_43469((String)(string + ".item"), (Object[])new Object[]{this.killedDisplayName, killedBy, this.itemDisplayName});
            }
            return class_2561.method_43469((String)string, (Object[])new Object[]{this.killedDisplayName, killedBy});
        }
        if (this.primeAdversaryDisplayName != null) {
            return class_2561.method_43469((String)(string + ".player"), (Object[])new Object[]{this.killedDisplayName, this.primeAdversaryDisplayName});
        }
        return class_2561.method_43469((String)string, (Object[])new Object[]{this.killedDisplayName});
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("damageTypeId", this.damageTypeId);
        nbt.method_10582("killedDisplayName", this.killedDisplayName);
        if (this.sourceDisplayName != null) {
            nbt.method_10582("sourceDisplayName", this.sourceDisplayName);
        }
        if (this.attackerDisplayName != null) {
            nbt.method_10582("attackerDisplayName", this.attackerDisplayName);
        }
        if (this.itemDisplayName != null) {
            nbt.method_10582("itemDisplayName", this.itemDisplayName);
        }
        if (this.primeAdversaryDisplayName != null) {
            nbt.method_10582("primeAdversaryDisplayName", this.primeAdversaryDisplayName);
        }
        return nbt;
    }

    public static TranslatableDeathMessage fromNbt(class_2487 nbt) {
        String damageTypeId = nbt.method_10558("damageTypeId");
        String killedDisplayName = nbt.method_10558("killedDisplayName");
        String sourceDisplayName = nbt.method_10545("sourceDisplayName") ? nbt.method_10558("sourceDisplayName") : null;
        String attackerDisplayName = nbt.method_10545("attackerDisplayName") ? nbt.method_10558("attackerDisplayName") : null;
        String itemDisplayName = nbt.method_10545("itemDisplayName") ? nbt.method_10558("itemDisplayName") : null;
        String primeAdversaryDisplayName = nbt.method_10545("primeAdversaryDisplayName") ? nbt.method_10558("primeAdversaryDisplayName") : null;
        return new TranslatableDeathMessage(damageTypeId, killedDisplayName, sourceDisplayName, attackerDisplayName, itemDisplayName, primeAdversaryDisplayName);
    }
}

