/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.data;

import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.ExtraFeaturesConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.ListMode;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DeathInfoManager
extends class_18 {
    public static DeathInfoManager INSTANCE = new DeathInfoManager();
    private final Map<GameProfile, RespawnComponent> respawnEffects = new HashMap<GameProfile, RespawnComponent>();
    private final Map<GameProfile, List<GraveComponent>> graveBackups = new HashMap<GameProfile, List<GraveComponent>>();
    private final Map<UUID, GraveComponent> graveMap = new HashMap<UUID, GraveComponent>();
    private ListMode graveListMode = ListMode.BLACKLIST;
    private final Set<GameProfile> affectedPlayers = new HashSet<GameProfile>();

    public void clear() {
        this.respawnEffects.clear();
        this.graveBackups.clear();
        this.graveMap.clear();
        this.affectedPlayers.clear();
    }

    public Set<GameProfile> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public class_1269 delete(UUID graveId) {
        GraveComponent component = this.graveMap.get(graveId);
        if (component == null) {
            return class_1269.field_5814;
        }
        GameProfile profile = component.getOwner();
        this.graveMap.remove(graveId);
        if (!this.graveBackups.containsKey(profile)) {
            return class_1269.field_5811;
        }
        this.graveBackups.get(profile).remove(component);
        if (component.getStatus() != GraveStatus.UNCLAIMED) {
            return class_1269.field_5812;
        }
        return component.removeGraveBlock() ? class_1269.field_5812 : class_1269.field_5811;
    }

    public void addRespawnComponent(GameProfile profile, RespawnComponent component) {
        if (!this.respawnEffects.containsKey(profile)) {
            this.respawnEffects.put(profile, component);
        }
    }

    public Optional<RespawnComponent> getRespawnComponent(GameProfile profile) {
        return Optional.ofNullable(this.respawnEffects.get(profile));
    }

    public Map<GameProfile, List<GraveComponent>> getPlayerGraves() {
        return this.graveBackups;
    }

    public void removeRespawnComponent(GameProfile profile) {
        this.respawnEffects.remove(profile);
    }

    public void addBackup(GameProfile profile, GraveComponent component) {
        YigdConfig config = YigdConfig.getConfig();
        if (!this.graveBackups.containsKey(profile)) {
            this.graveBackups.put(profile, new ArrayList());
        }
        List<GraveComponent> playerGraves = this.graveBackups.get(profile);
        playerGraves.add(component);
        this.graveMap.put(component.getGraveId(), component);
        if (playerGraves.size() > config.graveConfig.maxBackupsPerPerson) {
            GraveComponent toBeRemoved = playerGraves.get(0);
            this.delete(toBeRemoved.getGraveId());
            if (toBeRemoved.getStatus() == GraveStatus.UNCLAIMED && config.graveConfig.dropFromOldestWhenDeleted) {
                toBeRemoved.dropAllGraveItems();
            }
        }
        if (config.extraFeatures.graveCompass.pointToClosest != ExtraFeaturesConfig.GraveCompassConfig.CompassGraveTarget.DISABLED && component.getStatus() == GraveStatus.UNCLAIMED) {
            GraveCompassHelper.addGravePosition(component.getWorldRegistryKey(), component.getPos(), profile.getId());
        }
    }

    @NotNull
    public List<GraveComponent> getBackupData(GameProfile profile) {
        return this.graveBackups.computeIfAbsent(profile, k -> new ArrayList());
    }

    public Optional<GraveComponent> getGrave(UUID graveId) {
        return Optional.ofNullable(this.graveMap.get(graveId));
    }

    public ListMode getGraveListMode() {
        return this.graveListMode;
    }

    public void setGraveListMode(ListMode listMode) {
        this.graveListMode = listMode;
    }

    public void addToList(GameProfile profile) {
        this.affectedPlayers.add(profile);
    }

    public boolean removeFromList(GameProfile profile) {
        return this.affectedPlayers.remove(profile);
    }

    public boolean isInList(GameProfile profile) {
        return this.affectedPlayers.contains(profile);
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 respawnNbt = new class_2499();
        class_2499 graveNbt = new class_2499();
        class_2487 graveListNbt = new class_2487();
        for (Map.Entry<GameProfile, RespawnComponent> entry : this.respawnEffects.entrySet()) {
            class_2487 respawnCompound = new class_2487();
            respawnCompound.method_10566("user", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)entry.getKey()));
            respawnCompound.method_10566("component", (class_2520)entry.getValue().toNbt());
            respawnNbt.add((Object)respawnCompound);
        }
        for (Map.Entry<GameProfile, Object> entry : this.graveBackups.entrySet()) {
            class_2487 graveCompound = new class_2487();
            graveCompound.method_10566("user", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)entry.getKey()));
            class_2499 graveNbtList = new class_2499();
            for (GraveComponent graveComponent : (List)entry.getValue()) {
                graveNbtList.add((Object)graveComponent.toNbt());
            }
            graveCompound.method_10566("graves", (class_2520)graveNbtList);
            graveNbt.add((Object)graveCompound);
        }
        graveListNbt.method_10582("listMode", this.graveListMode.name());
        class_2499 affectedPlayersNbt = new class_2499();
        for (GameProfile profile : this.affectedPlayers) {
            affectedPlayersNbt.add((Object)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)profile));
        }
        graveListNbt.method_10566("affectedPlayers", (class_2520)affectedPlayersNbt);
        nbt.method_10566("respawns", (class_2520)respawnNbt);
        nbt.method_10566("graves", (class_2520)graveNbt);
        nbt.method_10566("whitelist", (class_2520)graveListNbt);
        return nbt;
    }

    public static class_18 fromNbt(class_2487 nbt, MinecraftServer server) {
        INSTANCE.clear();
        class_2499 respawnNbt = nbt.method_10554("respawns", 10);
        class_2499 graveNbt = nbt.method_10554("graves", 10);
        for (class_2520 respawnElement : respawnNbt) {
            class_2487 respawnCompound = (class_2487)respawnElement;
            INSTANCE.addRespawnComponent(class_2512.method_10683((class_2487)respawnCompound.method_10562("user")), RespawnComponent.fromNbt(respawnCompound.method_10562("component")));
        }
        for (class_2520 graveElement : graveNbt) {
            class_2487 graveCompound = (class_2487)graveElement;
            GameProfile user = class_2512.method_10683((class_2487)graveCompound.method_10562("user"));
            class_2499 gravesList = graveCompound.method_10554("graves", 10);
            for (class_2520 grave : gravesList) {
                GraveBlockEntity be;
                class_2586 class_25862;
                GraveComponent component = GraveComponent.fromNbt((class_2487)grave, server);
                INSTANCE.addBackup(user, component);
                class_3218 world = component.getWorld();
                if (world == null || !world.method_37116(new class_1923(component.getPos()).method_8324()) || !((class_25862 = world.method_8321(component.getPos())) instanceof GraveBlockEntity) || (be = (GraveBlockEntity)class_25862).getGraveId() == null || !be.getGraveId().equals(component.getGraveId())) continue;
                be.setComponent(component);
            }
        }
        class_2487 graveListNbt = nbt.method_10562("whitelist");
        ListMode listMode = ListMode.valueOf(graveListNbt.method_10558("listMode"));
        INSTANCE.setGraveListMode(listMode);
        class_2499 affectedPlayersNbt = graveListNbt.method_10554("affectedPlayers", 9);
        for (class_2520 e : affectedPlayersNbt) {
            GameProfile profile = class_2512.method_10683((class_2487)((class_2487)e));
            INSTANCE.addToList(profile);
        }
        return INSTANCE;
    }
}

