/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.config;

import com.b1n_ry.yigd.config.ClaimPriority;
import com.b1n_ry.yigd.config.DropType;
import com.b1n_ry.yigd.config.MapEntryConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

public class GraveConfig {
    public boolean enabled = true;
    public boolean storeItems = true;
    public boolean storeXp = true;
    @Comment(value="Inform player where the grave generated when respawning")
    public boolean informGraveLocation = true;
    @Comment(value="If true, you HAVE to have `requiredItemCount` number of `requiredItem` for a grave to generate. That many of that item will then be consumed")
    public boolean requireItem = false;
    public String requiredItem = "yigd:grave";
    public int requiredItemCount = 1;
    public boolean requireShovelToLoot = false;
    @ConfigEntry.Gui.CollapsibleObject
    public RetrieveMethods retrieveMethods = new RetrieveMethods();
    public boolean mergeStacksOnRetrieve = true;
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public DropType dropOnRetrieve = DropType.IN_INVENTORY;
    public boolean dropGraveBlock = false;
    public boolean generateEmptyGraves = false;
    @Comment(value="Allows everyone to bypass spawn protection for grave blocks")
    public boolean overrideSpawnProtection = true;
    @Comment(value="Which of the layout in the grave or in your inventory should be prioritized")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public ClaimPriority claimPriority = ClaimPriority.GRAVE;
    @ConfigEntry.Gui.CollapsibleObject
    public GraveRobbing graveRobbing = new GraveRobbing();
    @ConfigEntry.Gui.CollapsibleObject
    public GraveTimeout graveTimeout = new GraveTimeout();
    @Comment(value="If false, layout prioritizing doesn't care if armor is cursed with binding")
    public boolean treatBindingCurse = true;
    public boolean generateGraveInVoid = true;
    @Comment(value="Minimum y-level a grave can spawn in a dimension")
    public List<MapEntryConfig.IntType> minimumGraveYLevel = new ArrayList<MapEntryConfig.IntType>(){
        {
            this.add(new MapEntryConfig.IntType("minecraft:overworld", -60));
            this.add(new MapEntryConfig.IntType("minecraft:the_nether", 3));
            this.add(new MapEntryConfig.IntType("minecraft:the_end", 3));
            this.add(new MapEntryConfig.IntType("misc", 3));
        }
    };
    public boolean generateOnlyWithinBorder = true;
    public List<String> ignoredDeathTypes = new ArrayList<String>();
    @Comment(value="Allow players to unlock their graves through GUI")
    public boolean unlockable = true;
    @ConfigEntry.Gui.CollapsibleObject
    public RandomSpawn randomSpawn = new RandomSpawn();
    public boolean generateOnLastGroundPos = false;
    public boolean tryGenerateOnGround = false;
    @ConfigEntry.Gui.CollapsibleObject
    public Range generationMaxDistance = new Range();
    public boolean useSoftBlockWhitelist = false;
    public boolean useStrictBlockBlacklist = true;
    public boolean replaceOldWhenClaimed = true;
    public boolean dropItemsIfDestroyed = false;
    public boolean notifyOwnerIfDestroyed = true;
    @Comment(value="If true, graves will persist when claiming them, and right clicking on them after that will let you know when and how they died. Can also then be mined")
    @ConfigEntry.Gui.CollapsibleObject
    public PersistentGraves persistentGraves = new PersistentGraves();
    public List<String> dimensionBlacklist = new ArrayList<String>();
    @ConfigEntry.Gui.CollapsibleObject
    public BlockUnderGrave blockUnderGrave = new BlockUnderGrave();
    @Comment(value="When people leave, should the game let everyone know where they have a grave?")
    public boolean sellOutOfflinePeople = false;
    @Comment(value="Max amount of backed up graves")
    public int maxBackupsPerPerson = 50;
    public boolean dropFromOldestWhenDeleted = true;

    public static class RetrieveMethods {
        public boolean onClick = true;
        public boolean onBreak = false;
        public boolean onSneak = false;
        public boolean onStand = false;
    }

    public static class GraveRobbing {
        public boolean enabled = true;
        public boolean killerSkipWaitTime = false;
        public int afterTime = 1;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public TimeUnit timeUnit = TimeUnit.HOURS;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ClaimPriority robPriority = ClaimPriority.INVENTORY;
        public boolean notifyWhenRobbed = true;
        public boolean tellWhoRobbed = true;
    }

    public static class GraveTimeout {
        public boolean enabled = false;
        public int afterTime = 5;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public TimeUnit timeUnit = TimeUnit.HOURS;
        public boolean dropContentsOnTimeout = true;
    }

    public static class RandomSpawn {
        public int percentSpawnChance = 0;
        public String spawnEntity = "minecraft:zombie";
        public String spawnNbt = "{ArmorItems:[{},{},{},{id:\"minecraft:player_head\",tag:{SkullOwner:\"${owner.name}\"},Count:1b}]}";
    }

    public static class Range {
        public int x = 5;
        public int y = 5;
        public int z = 5;
    }

    public static class PersistentGraves {
        public boolean enabled = false;
        public boolean showDeathDay = true;
        public boolean showDeathIrlTime = true;
        public boolean useAmPm = true;
    }

    public static class BlockUnderGrave {
        public boolean enabled = true;
        public List<MapEntryConfig.StringType> blockInDimensions = new ArrayList<MapEntryConfig.StringType>(){
            {
                this.add(new MapEntryConfig.StringType("minecraft:overworld", "minecraft:cobblestone"));
                this.add(new MapEntryConfig.StringType("minecraft:the_nether", "minecraft:soul_soil"));
                this.add(new MapEntryConfig.StringType("minecraft:the_end", "minecraft:end_stone"));
                this.add(new MapEntryConfig.StringType("misc", "minecraft:dirt"));
            }
        };
        @Comment(value="Defines whether the block under grave can be generated in claims where the player can NOT place blocks if protection api compat is enabled")
        public boolean generateOnProtectedLand = false;
        @Comment(value="Defines whether the block under grave can be generated in claims where the player CAN place blocks if protection api compat is enabled")
        public boolean generateInOwnClaim = true;
    }
}

