/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class TrinketsCompat
implements InvModCompat<Map<String, Map<String, class_2371<GraveItem>>>> {
    @Override
    public String getModName() {
        return "trinkets";
    }

    @Override
    public void clear(class_3222 player) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
            for (Map.Entry groupEntry : trinketComponent.getInventory().entrySet()) {
                for (Map.Entry slotEntry : ((Map)groupEntry.getValue()).entrySet()) {
                    ((TrinketInventory)slotEntry.getValue()).method_5448();
                }
            }
        });
    }

    @Override
    public CompatComponent<Map<String, Map<String, class_2371<GraveItem>>>> readNbt(class_2487 nbt) {
        HashMap<String, Map<String, class_2371<GraveItem>>> inventory = new HashMap<String, Map<String, class_2371<GraveItem>>>();
        for (String groupName : nbt.method_10541()) {
            class_2487 groupNbt = nbt.method_10562(groupName);
            HashMap<String, class_2371<GraveItem>> groupMap = new HashMap<String, class_2371<GraveItem>>();
            for (String slotName : groupNbt.method_10541()) {
                class_2487 slotNbt = groupNbt.method_10562(slotName);
                class_2371<GraveItem> items = InventoryComponent.listFromNbt(slotNbt, itemNbt -> {
                    String dropRuleString;
                    class_1799 stack = class_1799.method_7915((class_2487)itemNbt);
                    DropRule dropRule = itemNbt.method_10545("dropRule") ? ((dropRuleString = itemNbt.method_10558("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultTrinketsDropRule : DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultTrinketsDropRule;
                    return new GraveItem(stack, dropRule);
                }, InventoryComponent.EMPTY_GRAVE_ITEM, "inventory", "size");
                groupMap.put(slotName, items);
            }
            inventory.put(groupName, groupMap);
        }
        return new TrinketsCompatComponent((Map<String, Map<String, class_2371<GraveItem>>>)inventory);
    }

    @Override
    public CompatComponent<Map<String, Map<String, class_2371<GraveItem>>>> getNewComponent(class_3222 player) {
        return new TrinketsCompatComponent(player);
    }

    private static class TrinketsCompatComponent
    extends CompatComponent<Map<String, Map<String, class_2371<GraveItem>>>> {
        public TrinketsCompatComponent(class_3222 player) {
            super(player);
        }

        public TrinketsCompatComponent(Map<String, Map<String, class_2371<GraveItem>>> inventory) {
            super(inventory);
        }

        private DropRule convertDropRule(TrinketEnums.DropRule dropRule) {
            return switch (dropRule) {
                case TrinketEnums.DropRule.KEEP -> DropRule.KEEP;
                case TrinketEnums.DropRule.DESTROY -> DropRule.DESTROY;
                default -> YigdConfig.getConfig().compatConfig.defaultTrinketsDropRule;
            };
        }

        @Override
        public Map<String, Map<String, class_2371<GraveItem>>> getInventory(class_3222 player) {
            HashMap<String, Map<String, class_2371<GraveItem>>> items = new HashMap<String, Map<String, class_2371<GraveItem>>>();
            TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
                for (Map.Entry group : component.getInventory().entrySet()) {
                    String groupString = (String)group.getKey();
                    HashMap<String, class_2371> slotMap = new HashMap<String, class_2371>();
                    for (Map.Entry slot : ((Map)group.getValue()).entrySet()) {
                        String slotString = (String)slot.getKey();
                        TrinketInventory trinketInventory = (TrinketInventory)slot.getValue();
                        class_2371 itemsInInventory = class_2371.method_10211();
                        for (int i = 0; i < trinketInventory.method_5439(); ++i) {
                            class_1799 stack = trinketInventory.method_5438(i);
                            SlotReference ref = new SlotReference(trinketInventory, i);
                            TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket((class_1792)stack.method_7909()).getDropRule(stack, ref, (class_1309)player);
                            itemsInInventory.add((Object)new GraveItem(trinketInventory.method_5438(i), this.convertDropRule(dropRule)));
                        }
                        slotMap.put(slotString, itemsInInventory);
                    }
                    items.put(groupString, slotMap);
                }
            });
            return items;
        }

        @Override
        public class_2371<class_1799> pullBindingCurseItems(class_3222 playerRef) {
            class_2371 noUnequipItems = class_2371.method_10211();
            if (!YigdConfig.getConfig().graveConfig.treatBindingCurse) {
                return noUnequipItems;
            }
            Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)playerRef);
            if (trinketComponent.isPresent()) {
                Map trinketInventory = ((TrinketComponent)trinketComponent.get()).getInventory();
                for (Map.Entry group : ((Map)this.inventory).entrySet()) {
                    Map componentSlots = (Map)trinketInventory.get(group.getKey());
                    if (componentSlots == null) continue;
                    for (Map.Entry slot : ((Map)group.getValue()).entrySet()) {
                        TrinketInventory trinketSlot = (TrinketInventory)componentSlots.get(slot.getKey());
                        if (trinketSlot == null) continue;
                        class_2371 slotItems = (class_2371)slot.getValue();
                        for (int i = 0; i < slotItems.size(); ++i) {
                            GraveItem graveItem = (GraveItem)slotItems.get(i);
                            class_1799 item = graveItem.stack;
                            if (item.method_7960()) continue;
                            SlotReference ref = new SlotReference(trinketSlot, i);
                            if (TrinketsApi.getTrinket((class_1792)item.method_7909()).canUnequip(item, ref, (class_1309)playerRef)) continue;
                            noUnequipItems.add((Object)item.method_7972());
                            slotItems.set(i, (Object)InventoryComponent.EMPTY_GRAVE_ITEM);
                        }
                    }
                }
            }
            return noUnequipItems;
        }

        @Override
        public class_2371<GraveItem> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)merger);
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry groupEntry : mergingInventory.entrySet()) {
                String groupName = (String)groupEntry.getKey();
                Map slotMap = (Map)((Map)this.inventory).get(groupName);
                if (slotMap == null) {
                    for (class_2371 class_23712 : ((Map)groupEntry.getValue()).values()) {
                        for (GraveItem graveItem2 : class_23712) {
                            extraItems.add((Object)graveItem2.copy());
                        }
                    }
                    continue;
                }
                for (Map.Entry entry : ((Map)groupEntry.getValue()).entrySet()) {
                    String slotName = (String)entry.getKey();
                    class_2371 stacks = (class_2371)slotMap.get(slotName);
                    class_2371 mergingItems = (class_2371)entry.getValue();
                    if (stacks == null) {
                        for (GraveItem graveItem3 : mergingItems) {
                            extraItems.add((Object)graveItem3.copy());
                        }
                        continue;
                    }
                    for (int i = 0; i < mergingItems.size(); ++i) {
                        GraveItem mergingGraveItem = ((GraveItem)mergingItems.get(i)).copy();
                        class_1799 mergingStack = mergingGraveItem.stack;
                        if (mergingStack.method_7960()) continue;
                        if (stacks.size() <= i) {
                            extraItems.add((Object)mergingGraveItem);
                            continue;
                        }
                        GraveItem currentGraveItem = (GraveItem)stacks.get(i);
                        class_1799 currentStack = currentGraveItem.stack;
                        if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !this.canUnequip(trinketComponent.orElse(null), slotName, groupName, i, mergingStack, merger)) {
                            extraItems.add((Object)currentGraveItem);
                            stacks.set(i, (Object)mergingGraveItem);
                            continue;
                        }
                        if (!currentStack.method_7960()) {
                            extraItems.add((Object)mergingGraveItem);
                            continue;
                        }
                        stacks.set(i, (Object)mergingGraveItem);
                    }
                }
            }
            extraItems.removeIf(graveItem -> graveItem.stack.method_7960());
            return extraItems;
        }

        private boolean canUnequip(@Nullable TrinketComponent component, String slot, String group, int index, class_1799 item, class_3222 player) {
            if (component == null) {
                return true;
            }
            Map trinketGroup = (Map)component.getInventory().get(group);
            if (trinketGroup == null) {
                return true;
            }
            TrinketInventory trinketInventory = (TrinketInventory)trinketGroup.get(slot);
            if (trinketInventory == null || trinketInventory.method_5439() <= index) {
                return true;
            }
            if (item.method_7960()) {
                return true;
            }
            SlotReference ref = new SlotReference(trinketInventory, index);
            return TrinketsApi.getTrinket((class_1792)item.method_7909()).canUnequip(item, ref, (class_1309)player);
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            class_2371 extraItems = class_2371.method_10211();
            TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
                for (Map.Entry group : ((Map)this.inventory).entrySet()) {
                    Map componentSlots = (Map)trinketComponent.getInventory().get(group.getKey());
                    if (componentSlots == null) {
                        for (class_2371 class_23712 : ((Map)group.getValue()).values()) {
                            for (GraveItem graveItem : class_23712) {
                                extraItems.add((Object)graveItem.stack.method_7972());
                            }
                        }
                        continue;
                    }
                    for (Map.Entry entry : ((Map)group.getValue()).entrySet()) {
                        TrinketInventory trinketInventory = (TrinketInventory)componentSlots.get(entry.getKey());
                        class_2371 slotItems = (class_2371)entry.getValue();
                        if (trinketInventory == null) {
                            for (GraveItem graveItem : slotItems) {
                                extraItems.add((Object)graveItem.stack.method_7972());
                            }
                            continue;
                        }
                        for (int i = 0; i < slotItems.size(); ++i) {
                            GraveItem graveItem;
                            graveItem = (GraveItem)slotItems.get(i);
                            class_1799 item = graveItem.stack.method_7972();
                            if (i >= trinketInventory.method_5439()) {
                                extraItems.add((Object)item);
                                continue;
                            }
                            trinketInventory.method_5447(i, item);
                        }
                    }
                }
            });
            extraItems.removeIf(class_1799::method_7960);
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            for (Map group : ((Map)this.inventory).values()) {
                for (class_2371 slotItems : group.values()) {
                    for (GraveItem graveItem : slotItems) {
                        class_1799 item = graveItem.stack;
                        if (item.method_7960()) continue;
                        DropRule dropRule = graveItem.dropRule;
                        if (dropRule == DropRule.PUT_IN_GRAVE) {
                            dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(item, -1, context, true);
                        }
                        graveItem.dropRule = dropRule;
                    }
                }
            }
        }

        @Override
        public class_2371<GraveItem> getAsGraveItemList() {
            class_2371 allItems = class_2371.method_10211();
            for (Map slotMap : ((Map)this.inventory).values()) {
                for (class_2371 itemStacks : slotMap.values()) {
                    allItems.addAll((Collection)itemStacks);
                }
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, Map<String, class_2371<GraveItem>>>> filterInv(Predicate<DropRule> predicate) {
            HashMap<String, Map<String, class_2371<GraveItem>>> filtered = new HashMap<String, Map<String, class_2371<GraveItem>>>();
            for (Map.Entry group : ((Map)this.inventory).entrySet()) {
                HashMap<String, class_2371> filteredGroup = new HashMap<String, class_2371>();
                for (Map.Entry slot : ((Map)group.getValue()).entrySet()) {
                    class_2371 filteredSlot = class_2371.method_10211();
                    class_2371 slotItems = (class_2371)slot.getValue();
                    for (GraveItem graveItem : slotItems) {
                        if (predicate.test(graveItem.dropRule)) {
                            filteredSlot.add((Object)graveItem);
                            continue;
                        }
                        filteredSlot.add((Object)InventoryComponent.EMPTY_GRAVE_ITEM);
                    }
                    filteredGroup.put((String)slot.getKey(), filteredSlot);
                }
                filtered.put((String)group.getKey(), filteredGroup);
            }
            return new TrinketsCompatComponent((Map<String, Map<String, class_2371<GraveItem>>>)filtered);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            for (Map group : ((Map)this.inventory).values()) {
                for (class_2371 slot : group.values()) {
                    for (GraveItem graveItem : slot) {
                        class_1799 stack = graveItem.stack;
                        if (!predicate.test(stack)) continue;
                        stack.method_7934(itemCount);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (Map slotMap : ((Map)this.inventory).values()) {
                for (class_2371 items : slotMap.values()) {
                    Collections.fill(items, InventoryComponent.EMPTY_GRAVE_ITEM);
                }
            }
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            for (Map.Entry group : ((Map)this.inventory).entrySet()) {
                class_2487 groupNbt = new class_2487();
                for (Map.Entry slot : ((Map)group.getValue()).entrySet()) {
                    class_2371 slotItems = (class_2371)slot.getValue();
                    class_2487 slotNbt = InventoryComponent.listToNbt(slotItems, graveItem -> {
                        class_2487 itemNbt = new class_2487();
                        graveItem.stack.method_7953(itemNbt);
                        itemNbt.method_10582("dropRule", graveItem.dropRule.name());
                        return itemNbt;
                    }, graveItem -> graveItem.stack.method_7960(), "inventory", "size");
                    groupNbt.method_10566((String)slot.getKey(), (class_2520)slotNbt);
                }
                nbt.method_10566((String)group.getKey(), (class_2520)groupNbt);
            }
            return nbt;
        }
    }
}

