/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class TravelersBackpackCompat
implements InvModCompat<GraveItem> {
    public static boolean isTrinketIntegrationEnabled() {
        try {
            return TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getModName() {
        return "travelers backpack";
    }

    @Override
    public void clear(class_3222 player) {
        ComponentUtils.getComponent((class_1657)player).removeWearable();
    }

    @Override
    public CompatComponent<GraveItem> readNbt(class_2487 nbt) {
        class_1799 stack = class_1799.method_7915((class_2487)nbt);
        DropRule dropRule = nbt.method_10545("dropRule") ? DropRule.valueOf(nbt.method_10558("dropRule")) : YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
        return new TBCompatComponent(new GraveItem(stack, dropRule));
    }

    @Override
    public CompatComponent<GraveItem> getNewComponent(class_3222 player) {
        return new TBCompatComponent(player);
    }

    private static class TBCompatComponent
    extends CompatComponent<GraveItem> {
        public TBCompatComponent(class_3222 player) {
            super(player);
        }

        public TBCompatComponent(GraveItem inventory) {
            super(inventory);
        }

        @Override
        public GraveItem getInventory(class_3222 player) {
            DropRule defaultDropRule = YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
            class_1799 stack = ComponentUtils.getComponent((class_1657)player).getWearable();
            return stack == null ? InventoryComponent.EMPTY_GRAVE_ITEM : new GraveItem(stack, defaultDropRule);
        }

        @Override
        public class_2371<GraveItem> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            GraveItem graveItem = (GraveItem)mergingComponent.inventory;
            class_1799 mergingStack = graveItem.stack;
            class_1799 currentStack = ((GraveItem)this.inventory).stack;
            if (mergingStack.method_7960()) {
                return extraItems;
            }
            if (!currentStack.method_7960()) {
                extraItems.add((Object)graveItem);
                return extraItems;
            }
            this.inventory = new GraveItem(mergingStack, graveItem.dropRule);
            return extraItems;
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            if (((GraveItem)this.inventory).stack.method_7960()) {
                return class_2371.method_10211();
            }
            ComponentUtils.equipBackpack((class_1657)player, (class_1799)((GraveItem)this.inventory).stack.method_7972());
            return class_2371.method_10211();
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            DropRule dropRule = compatConfig.defaultTravelersBackpackDropRule;
            class_1799 stack = ((GraveItem)this.inventory).stack;
            if (stack.method_7960()) {
                return;
            }
            if (dropRule == DropRule.PUT_IN_GRAVE) {
                dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
            }
            ((GraveItem)this.inventory).dropRule = dropRule;
        }

        @Override
        public class_2371<GraveItem> getAsGraveItemList() {
            class_2371 stacks = class_2371.method_10211();
            stacks.add((Object)((GraveItem)this.inventory));
            return stacks;
        }

        @Override
        public CompatComponent<GraveItem> filterInv(Predicate<DropRule> predicate) {
            GraveItem graveItem = predicate.test(((GraveItem)this.inventory).dropRule) ? (GraveItem)this.inventory : InventoryComponent.EMPTY_GRAVE_ITEM;
            return new TBCompatComponent(graveItem);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            class_1799 stack = ((GraveItem)this.inventory).stack;
            if (predicate.test(stack)) {
                stack.method_7934(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.inventory = InventoryComponent.EMPTY_GRAVE_ITEM;
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            ((GraveItem)this.inventory).stack.method_7953(nbt);
            nbt.method_10582("dropRule", ((GraveItem)this.inventory).dropRule.name());
            return nbt;
        }
    }
}

