/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.friendlyfire.Config;
import net.darkhax.friendlyfire.Constants;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6025;
import net.minecraft.class_6862;

public class FriendlyFireCommon {
    private static final class_6862<class_1792> BYPASS_PET = Services.TAGS.itemTag(new class_2960("friendlyfire", "bypass_pet"));
    private static final class_6862<class_1792> BYPASS_ALL = Services.TAGS.itemTag(new class_2960("friendlyfire", "bypass_all_protection"));
    private static final class_6862<class_1299<?>> GENERAL_PROTECTION = Services.TAGS.entityTag(new class_2960("friendlyfire", "general_protection"));
    private static final class_6862<class_1299<?>> PLAYER_PROTECTION = Services.TAGS.entityTag(new class_2960("friendlyfire", "player_protection"));
    private static final class_6862<class_1299<?>> BYPASSED_PROTECTION = Services.TAGS.entityTag(new class_2960("friendlyfire", "bypassed_entity_types"));
    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "friendlyfire.json"));

    public static void init() {
        Constants.LOG.debug("Protect children = {}", (Object)FriendlyFireCommon.CONFIG.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", (Object)FriendlyFireCommon.CONFIG.reflectDamage);
    }

    public static boolean preventAttack(class_1297 target, class_1282 source, float amount) {
        boolean preventDamage;
        class_1297 attacker = source.method_5529();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof class_3222) {
            class_3222 player = (class_3222)attacker;
            if (FriendlyFireCommon.CONFIG.displayHitWarning) {
                player.method_7353((class_2561)class_2561.method_43469((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.method_5477()}), true);
            }
        }
        return preventDamage;
    }

    private static boolean isProtected(class_1297 target, class_1297 attacker, float amount) {
        class_1296 agable;
        UUID ownerId;
        class_1799 heldItem;
        if (target.method_5864().method_20210(BYPASSED_PROTECTION)) {
            return false;
        }
        if (target == null || attacker == null || attacker.method_18276()) {
            return false;
        }
        if (attacker instanceof class_1309) {
            class_1309 attackerLiving = (class_1309)attacker;
            v0 = attackerLiving.method_6047();
        } else {
            v0 = heldItem = class_1799.field_8037;
        }
        if (heldItem.method_31573(BYPASS_ALL)) {
            return false;
        }
        if (target.method_5864().method_20210(GENERAL_PROTECTION)) {
            return true;
        }
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (target.method_5864().method_20210(PLAYER_PROTECTION)) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(target)) != null && !heldItem.method_31573(BYPASS_PET)) {
            if (FriendlyFireCommon.CONFIG.protectPetsFromOwner && ownerId.equals(attacker.method_5667())) {
                if (FriendlyFireCommon.CONFIG.reflectDamage) {
                    attacker.method_5643(attacker.method_37908().method_48963().method_48830(), amount);
                }
                return true;
            }
            if (FriendlyFireCommon.CONFIG.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        return FriendlyFireCommon.CONFIG.protectChildren && attacker instanceof class_1657 && !(target instanceof class_1569) && target instanceof class_1296 && (agable = (class_1296)target).method_6109() && !attacker.method_18276();
    }

    @Nullable
    private static UUID getOwner(class_1297 entity) {
        if (entity instanceof class_6025) {
            class_6025 ownable = (class_6025)entity;
            return ownable.method_6139();
        }
        if (entity instanceof class_1496) {
            class_1496 horse = (class_1496)entity;
            return horse.method_6139();
        }
        return null;
    }
}

