/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers;

import dev.sterner.guardvillagers.GuardVillagersConfig;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import dev.sterner.guardvillagers.common.network.GuardFollowPacket;
import dev.sterner.guardvillagers.common.network.GuardPatrolPacket;
import dev.sterner.guardvillagers.common.screenhandler.GuardVillagerScreenHandler;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GuardVillagers
implements ModInitializer {
    public static final String MODID = "guardvillagers";
    public static final class_3917<GuardVillagerScreenHandler> GUARD_SCREEN_HANDLER = new ExtendedScreenHandlerType(GuardVillagerScreenHandler::new);
    public static final class_1299<GuardEntity> GUARD_VILLAGER = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960("guardvillagers", "guard"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_6294, GuardEntity::new).dimensions(class_4048.method_18385((float)0.6f, (float)1.8f)).build());
    public static final class_1792 GUARD_SPAWN_EGG = new class_1826(GUARD_VILLAGER, 5651507, 8412749, new class_1792.class_1793());
    public static class_3414 GUARD_AMBIENT = class_3414.method_47908((class_2960)new class_2960("guardvillagers", "entity.guard.ambient"));
    public static class_3414 GUARD_HURT = class_3414.method_47908((class_2960)new class_2960("guardvillagers", "entity.guard.hurt"));
    public static class_3414 GUARD_DEATH = class_3414.method_47908((class_2960)new class_2960("guardvillagers", "entity.guard.death"));

    public static class_1268 getHandWith(class_1309 livingEntity, Predicate<class_1792> itemPredicate) {
        return itemPredicate.test(livingEntity.method_6047().method_7909()) ? class_1268.field_5808 : class_1268.field_5810;
    }

    public void onInitialize() {
        MidnightConfig.init((String)MODID, GuardVillagersConfig.class);
        FabricDefaultAttributeRegistry.register(GUARD_VILLAGER, (class_5132.class_5133)GuardEntity.createAttributes());
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MODID, "guard_spawn_egg"), (Object)GUARD_SPAWN_EGG);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960("guard_screen"), GUARD_SCREEN_HANDLER);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)new class_2960(MODID, "entity.guard.ambient"), (Object)GUARD_AMBIENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)new class_2960(MODID, "entity.guard.hurt"), (Object)GUARD_HURT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)new class_2960(MODID, "entity.guard.death"), (Object)GUARD_DEATH);
        ServerPlayNetworking.registerGlobalReceiver(GuardFollowPacket.PACKET_TYPE, GuardFollowPacket::handle);
        ServerPlayNetworking.registerGlobalReceiver(GuardPatrolPacket.PACKET_TYPE, GuardPatrolPacket::handle);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)GUARD_SPAWN_EGG));
        ServerLivingEntityEvents.ALLOW_DAMAGE.register(this::onDamage);
        UseEntityCallback.EVENT.register(this::villagerConvert);
    }

    private boolean onDamage(class_1309 entity, class_1282 source, float amount) {
        boolean isGolem;
        class_1297 attacker = source.method_5529();
        if (entity == null || attacker == null) {
            return true;
        }
        boolean shouldDamage = true;
        boolean isVillager = entity.method_5864() == class_1299.field_6077 || entity.method_5864() == GUARD_VILLAGER;
        boolean bl = isGolem = isVillager || entity.method_5864() == class_1299.field_6147;
        if (isGolem && attacker.method_5864() == GUARD_VILLAGER && !GuardVillagersConfig.guardArrowsHurtVillagers) {
            shouldDamage = false;
        }
        if (isVillager && attacker instanceof class_1308) {
            List list = attacker.method_37908().method_18467(class_1308.class, attacker.method_5829().method_1009(GuardVillagersConfig.guardVillagerHelpRange, 5.0, GuardVillagersConfig.guardVillagerHelpRange));
            for (class_1308 mob : list) {
                boolean type = mob.method_5864() == GUARD_VILLAGER || mob.method_5864() == class_1299.field_6147;
                boolean trueSourceGolem = attacker.method_5864() == GUARD_VILLAGER || attacker.method_5864() == class_1299.field_6147;
                if (trueSourceGolem || !type || mob.method_5968() != null) continue;
                mob.method_5980((class_1309)((class_1308)attacker));
            }
        }
        return shouldDamage;
    }

    private class_1269 villagerConvert(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        class_1646 villagerEntity;
        class_1297 target;
        class_1799 itemStack = player.method_5998(hand);
        if ((itemStack.method_7909() instanceof class_1829 || itemStack.method_7909() instanceof class_1764) && player.method_5715() && entityHitResult != null && (target = entityHitResult.method_17782()) instanceof class_1646 && !(villagerEntity = (class_1646)target).method_6109() && (villagerEntity.method_7231().method_16924() == class_3852.field_17051 || villagerEntity.method_7231().method_16924() == class_3852.field_17062) && (!GuardVillagersConfig.convertVillagerIfHaveHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.convertVillagerIfHaveHotv)) {
            this.convertVillager(villagerEntity, player, world);
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void convertVillager(class_1646 villagerEntity, class_1657 player, class_1937 world) {
        player.method_6104(class_1268.field_5808);
        class_1799 itemstack = player.method_6118(class_1304.field_6173);
        GuardEntity guard = (GuardEntity)GUARD_VILLAGER.method_5883(world);
        if (guard == null) {
            return;
        }
        if (player.method_37908().method_8608()) {
            class_2400 particleEffect = class_2398.field_11211;
            for (int i = 0; i < 10; ++i) {
                double d0 = villagerEntity.method_6051().method_43059() * 0.02;
                double d1 = villagerEntity.method_6051().method_43059() * 0.02;
                double d2 = villagerEntity.method_6051().method_43059() * 0.02;
                villagerEntity.method_37908().method_8406((class_2394)particleEffect, villagerEntity.method_23317() + (double)(villagerEntity.method_6051().method_43057() * villagerEntity.method_17681() * 2.0f) - (double)villagerEntity.method_17681(), villagerEntity.method_23318() + 0.5 + (double)(villagerEntity.method_6051().method_43057() * villagerEntity.method_17681()), villagerEntity.method_23321() + (double)(villagerEntity.method_6051().method_43057() * villagerEntity.method_17681() * 2.0f) - (double)villagerEntity.method_17681(), d0, d1, d2);
            }
        }
        guard.method_5719((class_1297)villagerEntity);
        guard.field_6241 = villagerEntity.field_6241;
        guard.method_5808(villagerEntity.method_23317(), villagerEntity.method_23318(), villagerEntity.method_23321(), villagerEntity.method_36454(), villagerEntity.method_36455());
        guard.method_5783(class_3417.field_14815, 1.0f, 1.0f);
        guard.method_5673(class_1304.field_6173, itemstack.method_7972());
        guard.guardInventory.method_5447(5, itemstack.method_7972());
        int i = GuardEntity.getRandomTypeForBiome((class_1936)guard.method_37908(), guard.method_24515());
        guard.setGuardVariant(i);
        guard.method_5971();
        guard.method_5665(villagerEntity.method_5797());
        guard.method_5880(villagerEntity.method_5807());
        guard.method_5946(class_1304.field_6169, 100.0f);
        guard.method_5946(class_1304.field_6174, 100.0f);
        guard.method_5946(class_1304.field_6166, 100.0f);
        guard.method_5946(class_1304.field_6172, 100.0f);
        guard.method_5946(class_1304.field_6173, 100.0f);
        guard.method_5946(class_1304.field_6171, 100.0f);
        world.method_8649((class_1297)guard);
        villagerEntity.method_19176(class_4140.field_18438);
        villagerEntity.method_19176(class_4140.field_18439);
        villagerEntity.method_19176(class_4140.field_18440);
        villagerEntity.method_31472();
    }

    public static boolean hotvChecker(class_1657 player, GuardEntity guard) {
        return player.method_6059(class_1294.field_18980) && GuardVillagersConfig.giveGuardStuffHotv || !GuardVillagersConfig.giveGuardStuffHotv || guard.getPlayerEntityReputation(player) > GuardVillagersConfig.reputationRequirement && !player.method_37908().method_8608();
    }
}

