/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.particle_core.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.fzzyhmstrs.particle_core.PcConfig;
import me.fzzyhmstrs.particle_core.SynchronizedIdentityHashMap;
import me.fzzyhmstrs.particle_core.interfaces.TickResult;
import me.fzzyhmstrs.particle_core.plugin.PcConditionTester;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_148;
import net.minecraft.class_3999;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Restriction(require={@Condition(type=Condition.Type.TESTER, tester=PcConditionTester.class)})
@Debug(export=true)
@Environment(value=EnvType.CLIENT)
@Mixin(value={class_702.class}, priority=100000)
public abstract class ParticleManagerAsyncMixin {
    @Unique
    private static final Set<Class<?>> unsafeParticles = ConcurrentHashMap.newKeySet();
    @Shadow
    @Final
    private Map<class_3999, Queue<class_703>> field_3830;
    @Shadow
    protected class_638 field_3834;
    @Unique
    private static final Object lock = new Object(){};

    @Shadow
    protected abstract void method_3059(class_703 var1);

    @Shadow
    protected abstract void method_34022(class_5878 var1, int var2);

    @Shadow
    protected abstract void method_3048(Collection<class_703> var1);

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="com/google/common/collect/Maps.newIdentityHashMap ()Ljava/util/IdentityHashMap;")})
    private IdentityHashMap<?, ?> particle_core_setupSynchronizedParticleMap(Operation<IdentityHashMap<?, ?>> original) {
        return new SynchronizedIdentityHashMap((IdentityHashMap)original.call(new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"addParticle(Lnet/minecraft/client/particle/Particle;)V"}, at={@At(value="INVOKE", target="java/util/Queue.add (Ljava/lang/Object;)Z")})
    private boolean particle_core_synchronizeParticleAdds(Queue<? extends class_703> instance, Object e, Operation<Boolean> original) {
        Object object = lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[]{instance, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="java/util/Map.forEach (Ljava/util/function/BiConsumer;)V")})
    private void particle_core_asyncParticleTicking(Map<class_3999, Queue<class_703>> instance, BiConsumer<? super class_3999, ? extends Queue<class_703>> v, Operation<Void> original) {
        if (!((Boolean)PcConfig.INSTANCE.getImpl().getAsynchronousTicking().get()).booleanValue()) {
            original.call(new Object[]{instance, v});
        } else {
            try {
                Set<Map.Entry<class_3999, Queue<class_703>>> entries = this.field_3830.entrySet();
                Map<class_3999, Queue<class_703>> map = this.field_3830;
                synchronized (map) {
                    ArrayList<CompletableFuture<TickResult.Results>> futures = new ArrayList<CompletableFuture<TickResult.Results>>(entries.size());
                    float threshold = (float)((Integer)PcConfig.INSTANCE.getImpl().getMaxParticlesPerSheet().get()).intValue() * 0.35f;
                    for (Map.Entry<class_3999, Queue<class_703>> entry : entries) {
                        this.field_3834.method_16107().method_15396(entry.getKey().toString());
                        if (entry.getValue().isEmpty() || !(threshold < (float)entry.getValue().size())) continue;
                        futures.add(CompletableFuture.supplyAsync(() -> this.asyncTickParticles((Collection)entry.getValue())));
                    }
                    for (Map.Entry<class_3999, Queue<class_703>> entry : entries) {
                        if (!entry.getValue().isEmpty() && !(threshold >= (float)entry.getValue().size())) continue;
                        this.syncTickParticles((Collection<class_703>)entry.getValue());
                        this.field_3834.method_16107().method_15407();
                    }
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
                    for (CompletableFuture completableFuture : futures) {
                        this.finalizeParticles((TickResult.Results)completableFuture.join());
                        this.field_3834.method_16107().method_15407();
                    }
                }
            }
            catch (Exception e) {
                PcConfig.INSTANCE.getLogger().error("Asynchronous particle ticking may have encountered a concurrency problem; disabling", (Throwable)e);
                PcConfig.INSTANCE.getImpl().getAsynchronousTicking().validateAndSet((Object)false);
            }
        }
    }

    @Unique
    private void syncTickParticles(Collection<class_703> particles) {
        this.method_3048(particles);
    }

    @Unique
    private TickResult.Results asyncTickParticles(Collection<class_703> particleCollection) {
        Consumer<class_703> tick = this::method_3059;
        List<TickResult> results = particleCollection.parallelStream().map(p -> this.tickParticleSafe(tick, (class_703)p)).toList();
        return new TickResult.Results(results, particleCollection);
    }

    @Unique
    private TickResult tickParticleSafe(Consumer<class_703> tick, class_703 particle) {
        try {
            if (unsafeParticles.contains(particle.getClass())) {
                return new TickResult(true, particle);
            }
            tick.accept(particle);
        }
        catch (class_148 e) {
            if (e.getCause() != null) {
                String msg = e.getCause().getMessage();
                if (msg != null && (Objects.equals(msg, "Accessing LegacyRandomSource from multiple threads") || msg.contains("ThreadLocalRandom accessed from a different thread"))) {
                    unsafeParticles.add(particle.getClass());
                    return new TickResult(true, particle);
                }
                if (this.checkStackTrace(e.getCause())) {
                    unsafeParticles.add(particle.getClass());
                    return new TickResult(true, particle);
                }
            }
            throw e;
        }
        return new TickResult(false, particle);
    }

    @Unique
    private boolean checkStackTrace(Throwable e) {
        StackTraceElement[] elements = e.getStackTrace();
        if (elements.length == 0) {
            return false;
        }
        String clazz = elements[0].getClassName();
        return clazz.contains("ThreadingDetector") || clazz.contains("CheckedThreadLocalRandom");
    }

    @Unique
    private void finalizeParticles(TickResult.Results result) {
        int i = 0;
        for (TickResult tr : result.results()) {
            if (!tr.failure()) continue;
            ++i;
            this.method_3059(tr.particle());
        }
        if (i > result.originalCollection().size() * 2 / 3) {
            PcConfig.INSTANCE.getLogger().error("Asynchronous particle ticking encountered issues with over 2/3 of particles; disabling");
            PcConfig.INSTANCE.getImpl().getAsynchronousTicking().validateAndSet((Object)false);
        }
        Iterator<? extends class_703> iterator = result.originalCollection().iterator();
        while (iterator.hasNext()) {
            class_703 particle = iterator.next();
            if (particle.method_3086()) continue;
            particle.method_34019().ifPresent(group -> this.method_34022((class_5878)group, -1));
            iterator.remove();
        }
    }
}

