/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule.file;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.anti_ad.mc.common.util.IndentedData;
import org.anti_ad.mc.common.util.IndentedDataFileParser;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFile$parseContent$2;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFilePreprocessManagerKt;
import org.anti_ad.mc.ipnext.parser.RuleParser;
import org.anti_ad.mc.ipnext.parser.SyntaxErrorException;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nRuleFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleFile.kt\norg/anti_ad/mc/ipnext/item/rule/file/RuleFile\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,65:1\n372#2,7:66\n*S KotlinDebug\n*F\n+ 1 RuleFile.kt\norg/anti_ad/mc/ipnext/item/rule/file/RuleFile\n*L\n50#1:66,7\n*E\n"})
public final class RuleFile {
    @NotNull
    private final String fileName;
    @NotNull
    private final String content;
    @NotNull
    private final Map rulesMap;

    public RuleFile(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.fileName = string;
        this.content = string2;
        this.rulesMap = new LinkedHashMap();
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Map getRulesMap() {
        return this.rulesMap;
    }

    public final void parseContent() {
        Log.INSTANCE.trace("[-] Parsing file " + this.fileName);
        for (IndentedData indentedData : IndentedDataFileParser.Companion.parse$default((IndentedDataFileParser.Companion)IndentedDataFileParser.Companion, (List)RuleFilePreprocessManagerKt.preprocessRules(StringsKt.lines((CharSequence)this.content)), (String)this.fileName, (int)0, (int)4, null).getSubData()) {
            Log.INSTANCE.trace("    - parsing rule: " + indentedData.getText());
            try {
                RuleDefinition ruleDefinition = RuleParser.INSTANCE.parseRuleDefinition(indentedData);
                Map map = this.rulesMap;
                String string = ruleDefinition.getRuleName();
                Object object = map.get(string);
                if (object == null) {
                    object = new ArrayList();
                    map.put(string, object);
                }
                ((List)object).add(ruleDefinition);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                Log.INSTANCE.warn("Syntax error in '" + this.fileName + "' (" + indentedData.getText() + ")");
                Log.INSTANCE.warn("  > at: " + syntaxErrorException.getLine() + ":" + syntaxErrorException.getPos() + " " + syntaxErrorException.getMsg());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Log.INSTANCE.trace(new RuleFile$parseContent$2(this));
        Log.INSTANCE.trace("    " + this.fileName + " parse finished");
    }
}

