/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_3300;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1076.class})
abstract class LanguageManagerMixin {
    @Shadow
    private Map<String, class_1077> field_5324;

    LanguageManagerMixin() {
    }

    @Shadow
    public abstract class_1077 method_4668(String var1);

    @Redirect(method={"reload"}, at=@At(value="INVOKE", ordinal=0, remap=false, target="Ljava/util/List;add(Ljava/lang/Object;)Z"))
    boolean onReload$addFallbacks(List<String> list, Object enUsCode) {
        if (Config.getInstance().language.equals("*")) {
            return true;
        }
        if (this.field_5324.isEmpty()) {
            return list.add((String)enUsCode);
        }
        Lists.reverse(Config.getInstance().fallbacks).stream().filter(code -> Objects.nonNull(this.method_4668((String)code))).forEach(list::add);
        return true;
    }

    @ModifyExpressionValue(method={"reload"}, at={@At(value="INVOKE", remap=false, target="Ljava/lang/String;equals(Ljava/lang/Object;)Z")})
    boolean onReload$ignoreNoLanguage(boolean original) {
        return Config.getInstance().language.equals("*") || this.field_5324.isEmpty();
    }

    @Inject(method={"reload"}, at={@At(value="INVOKE", ordinal=0, remap=false, target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    void onReload$setSystemLanguage(class_3300 manager, CallbackInfo ci) {
        if (LanguageReload.shouldSetSystemLanguage) {
            LanguageReload.shouldSetSystemLanguage = false;
            LanguageReload.LOGGER.info("Language is not set. Setting it to system language");
            Locale locale = Locale.getDefault();
            List<String> matchingLanguages = this.field_5324.keySet().stream().filter(code -> code.split("_")[0].equalsIgnoreCase(locale.getLanguage())).toList();
            int count = matchingLanguages.size();
            if (count > 1) {
                matchingLanguages.stream().filter(code -> {
                    String[] split = code.split("_");
                    if (split.length < 2) {
                        return false;
                    }
                    return split[1].equalsIgnoreCase(locale.getCountry());
                }).findFirst().ifPresent(lang -> LanguageManagerMixin.setSystemLanguage(lang, locale));
            } else if (count == 1) {
                LanguageManagerMixin.setSystemLanguage(matchingLanguages.get(0), locale);
            }
        }
    }

    @Unique
    private static void setSystemLanguage(String lang, Locale locale) {
        LanguageReload.LOGGER.info("Set language to {} (mapped from {})", (Object)lang, (Object)locale.toLanguageTag());
        LanguageReload.setLanguage(lang);
    }
}

