/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import jerozgen.languagereload.access.IAdvancementsScreen;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.mixin.BookScreenAccessor;
import jerozgen.languagereload.mixin.ClientChunkManagerAccessor;
import jerozgen.languagereload.mixin.ClientChunkMapAccessor;
import jerozgen.languagereload.mixin.MinecraftClientAccessor;
import jerozgen.languagereload.mixin.SignTextAccessor;
import jerozgen.languagereload.mixin.TextDisplayEntityAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1076;
import net.minecraft.class_1124;
import net.minecraft.class_1297;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_457;
import net.minecraft.class_8113;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LanguageReload {
    public static final Logger LOGGER = LogManager.getLogger((String)"Language Reload");
    public static final String MOD_ID = "languagereload";
    public static final String NO_LANGUAGE = "*";
    public static boolean shouldSetSystemLanguage = false;

    public static void reloadLanguages() {
        class_310 client = class_310.method_1551();
        client.method_1526().method_14491(client.method_1478());
        LanguageReload.reloadSearch();
        client.method_24288();
        client.field_1705.method_1743().method_1817();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_3872) {
            class_3872 bookScreen = (class_3872)class_4372;
            ((BookScreenAccessor)bookScreen).languagereload_setCachedPageIndex(-1);
        } else {
            class_4372 = client.field_1755;
            if (class_4372 instanceof class_457) {
                class_457 advancementsScreen = (class_457)class_4372;
                ((IAdvancementsScreen)advancementsScreen).languagereload_recreateWidgets();
            }
        }
        if (client.field_1687 != null) {
            ClientChunkManagerAccessor chunkManager = (ClientChunkManagerAccessor)client.field_1687.method_2935();
            AtomicReferenceArray<class_2818> chunks = ((ClientChunkMapAccessor)chunkManager.languagereload_getChunks()).languagereload_getChunks();
            for (int i = 0; i < chunks.length(); ++i) {
                class_2818 chunk = chunks.get(i);
                if (chunk == null) continue;
                for (class_2586 blockEntity : chunk.method_12214().values()) {
                    if (!(blockEntity instanceof class_2625)) continue;
                    class_2625 sign = (class_2625)blockEntity;
                    ((SignTextAccessor)sign.method_49853()).languagereload_setOrderedMessages(null);
                    ((SignTextAccessor)sign.method_49854()).languagereload_setOrderedMessages(null);
                }
            }
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!(entity instanceof class_8113.class_8123)) continue;
                class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
                ((TextDisplayEntityAccessor)textDisplay).languagereload_setTextLines(null);
            }
        }
    }

    public static void reloadSearch() {
        class_310 client = class_310.method_1551();
        class_1124 searchManager = ((MinecraftClientAccessor)client).languagereload_getSearchManager();
        searchManager.method_14491(client.method_1478());
    }

    public static void setLanguage(@Nullable String language) {
        if (language == null || language.equals(NO_LANGUAGE)) {
            LanguageReload.setLanguage(NO_LANGUAGE, null);
        } else if (language.equals("en_us")) {
            LanguageReload.setLanguage("en_us", null);
        } else {
            LanguageReload.setLanguage(language, new LinkedList<String>(){
                {
                    this.add("en_us");
                }
            });
        }
    }

    public static void setLanguage(@Nullable String language, @Nullable LinkedList<@NotNull String> fallbacks) {
        String newLanguage = language == null ? NO_LANGUAGE : language;
        LinkedList newFallbacks = fallbacks == null ? new LinkedList() : fallbacks;
        class_310 client = class_310.method_1551();
        class_1076 languageManager = client.method_1526();
        Config config = Config.getInstance();
        boolean languageIsSame = languageManager.method_4669().equals(newLanguage);
        boolean fallbacksAreSame = config.fallbacks.equals(newFallbacks);
        if (languageIsSame && fallbacksAreSame) {
            return;
        }
        config.previousLanguage = languageManager.method_4669();
        config.previousFallbacks = config.fallbacks;
        config.language = newLanguage;
        config.fallbacks = newFallbacks;
        Config.save();
        languageManager.method_4667(newLanguage);
        client.field_1690.field_1883 = newLanguage;
        client.field_1690.method_1640();
        LanguageReload.reloadLanguages();
    }

    @NotNull
    public static @NotNull LinkedList<@NotNull String> getLanguages() {
        LinkedList<String> list = new LinkedList<String>();
        String language = class_310.method_1551().method_1526().method_4669();
        if (!language.equals(NO_LANGUAGE)) {
            list.add(language);
        }
        list.addAll(Config.getInstance().fallbacks);
        return list;
    }
}

