/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.satisfy.meadow.core.entity.ChairEntity;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class GeneralUtil {
    public static final class_2754<LineConnectingType> LINE_CONNECTING_TYPE = class_2754.method_11850((String)"type", LineConnectingType.class);
    private static final Map<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>> CHAIRS = new HashMap<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>>();

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(DeferredRegister<class_2248> registerB, Registrar<class_2248> registrarB, DeferredRegister<class_1792> registerI, Registrar<class_1792> registrarI, class_2960 name, Supplier<T> block) {
        RegistrySupplier toReturn = GeneralUtil.registerWithoutItem(registerB, registrarB, name, block);
        GeneralUtil.registerItem(registerI, registrarI, name, () -> new class_1747((class_2248)toReturn.get(), new class_1792.class_1793()));
        return toReturn;
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithoutItem(DeferredRegister<class_2248> register, Registrar<class_2248> registrar, class_2960 path, Supplier<T> block) {
        return Platform.isForge() ? register.register(path.method_12832(), block) : registrar.register(path, block);
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItem(DeferredRegister<class_1792> register, Registrar<class_1792> registrar, class_2960 path, Supplier<T> itemSupplier) {
        return Platform.isForge() ? register.register(path.method_12832(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static boolean matchesRecipe(class_1263 inventory, class_2371<class_1856> recipe, int startIndex, int endIndex) {
        ArrayList<class_1799> inputStacks = new ArrayList<class_1799>();
        for (int i = startIndex; i <= endIndex; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            inputStacks.add(stack.method_7972());
        }
        if (inputStacks.size() != recipe.size()) {
            return false;
        }
        ArrayList<class_1856> unmatched = new ArrayList<class_1856>((Collection<class_1856>)recipe);
        for (class_1799 input : inputStacks) {
            boolean matched = false;
            Iterator iter = unmatched.iterator();
            while (iter.hasNext()) {
                if (!((class_1856)iter.next()).method_8093(input)) continue;
                iter.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return unmatched.isEmpty();
    }

    public static Collection<class_3222> tracking(class_3218 world, class_1923 pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.method_14178().field_17254.method_17210(pos, false);
    }

    public static Collection<class_3222> tracking(class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new class_1923(pos));
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static Optional<class_3545<Float, Float>> getRelativeHitCoordinatesForBlockFace(class_3965 blockHitResult, class_2350 direction, class_2350[] unAllowedDirections) {
        class_2350 hitDirection = blockHitResult.method_17780();
        for (class_2350 unAllowed : unAllowedDirections) {
            if (unAllowed != hitDirection) continue;
            return Optional.empty();
        }
        if (hitDirection != direction && hitDirection != class_2350.field_11036 && hitDirection != class_2350.field_11033) {
            return Optional.empty();
        }
        class_2338 adjacentPos = blockHitResult.method_17777().method_10093(hitDirection);
        class_243 hitLocation = blockHitResult.method_17784().method_1023((double)adjacentPos.method_10263(), (double)adjacentPos.method_10264(), (double)adjacentPos.method_10260());
        float x = (float)hitLocation.method_10216();
        float z = (float)hitLocation.method_10215();
        float y = (float)hitLocation.method_10214();
        class_2350 effectiveDirection = hitDirection == class_2350.field_11036 || hitDirection == class_2350.field_11033 ? direction : hitDirection;
        return switch (effectiveDirection) {
            case class_2350.field_11043 -> Optional.of(new class_3545((Object)Float.valueOf(1.0f - x), (Object)Float.valueOf(y)));
            case class_2350.field_11035 -> Optional.of(new class_3545((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
            case class_2350.field_11039 -> Optional.of(new class_3545((Object)Float.valueOf(z), (Object)Float.valueOf(y)));
            case class_2350.field_11034 -> Optional.of(new class_3545((Object)Float.valueOf(1.0f - z), (Object)Float.valueOf(y)));
            default -> Optional.empty();
        };
    }

    public static class_2371<class_1856> deserializeIngredients(JsonArray json) {
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 0; i < json.size(); ++i) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)json.get(i));
            if (ingredient.method_8103()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static class_1269 onUse(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit, double extraHeight) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_5811;
        }
        if (GeneralUtil.isPlayerSitting(player)) {
            return class_1269.field_5811;
        }
        if (hit.method_17780() == class_2350.field_11033) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = hit.method_17777();
        if (!GeneralUtil.isOccupied(world, hitPos) && player.method_5998(hand).method_7960()) {
            ChairEntity chair = (ChairEntity)((class_1299)EntityTypeRegistry.CHAIR.get()).method_5883(world);
            assert (chair != null);
            chair.method_5808((double)hitPos.method_10263() + 0.5, (double)hitPos.method_10264() + 0.25 + extraHeight, (double)hitPos.method_10260() + 0.5, 0.0f, 0.0f);
            if (GeneralUtil.addChairEntity(world, hitPos, chair, player.method_24515())) {
                world.method_8649((class_1297)chair);
                player.method_5804((class_1297)chair);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void onStateReplaced(class_1937 world, class_2338 pos) {
        ChairEntity entity;
        if (!world.field_9236 && (entity = GeneralUtil.getChairEntity(world, pos)) != null) {
            GeneralUtil.removeChairEntity(world, pos);
            entity.method_5772();
        }
    }

    public static boolean addChairEntity(class_1937 world, class_2338 blockPos, ChairEntity entity, class_2338 playerPos) {
        if (!world.field_9236) {
            class_2960 id = GeneralUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, class_2338>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.field_9236 && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.method_8608() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static class_2338 getPreviousPlayerPosition(class_1657 player, ChairEntity chairEntity) {
        class_2960 id;
        if (!player.method_37908().method_8608() && CHAIRS.containsKey(id = GeneralUtil.getDimensionTypeId(player.method_37908()))) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (class_2338)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(class_1937 world, class_2338 pos) {
        class_2960 id = GeneralUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(class_1657 player) {
        for (class_2960 i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).method_5626((class_1297)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static class_2960 getDimensionTypeId(class_1937 world) {
        return world.method_44013().method_29177();
    }

    public static enum LineConnectingType implements class_3542
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }

    public static enum ShutterType implements class_3542
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        NONE("none");

        private final String name;
        public static final class_2754<ShutterType> SHUTTER_TYPE;

        private ShutterType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            SHUTTER_TYPE = class_2754.method_11850((String)"type", ShutterType.class);
        }
    }
}

