/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.satisfy.meadow.core.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronCategory
implements IRecipeCategory<CookingCauldronRecipe> {
    public static final RecipeType<CookingCauldronRecipe> COOKING_CAULDRON = RecipeType.create((String)"meadow", (String)"cooking_cauldron", CookingCauldronRecipe.class);
    private static final int BACKGROUND_WIDTH = 160;
    private static final int BACKGROUND_HEIGHT = 70;
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 10;
    private static final int ARROW_U = 176;
    private static final int ARROW_V = 14;
    private static final int ARROW_WIDTH = 24;
    private static final int ARROW_HEIGHT = 17;
    private static final int MAX_TIME = 200;
    private static final int WIDTH_OF = 26;
    private static final int HEIGHT_OF = 10;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final class_2561 localizedName;
    private static final int FLUID_X = 173;
    private static final int FLUID_Y = 23;
    private static final int FLUID_WIDTH = 8;
    private static final int FLUID_HEIGHT = 43;
    private final class_2960 texture = new class_2960("meadow", "textures/gui/cooking_cauldron_gui.png");

    public CookingCauldronCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(this.texture, 10, 10, 160, 70);
        this.arrow = helper.drawableBuilder(this.texture, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((class_2248)ObjectRegistry.COOKING_CAULDRON.get()).method_8389().method_7854());
        this.burnIcon = helper.createDrawable(this.texture, 176, 0, 14, 14);
        this.localizedName = ((class_2248)ObjectRegistry.COOKING_CAULDRON.get()).method_9518();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CookingCauldronRecipe recipe, IFocusGroup focuses) {
        class_2371<class_1856> ingredients = recipe.method_8117();
        for (int i = 0; i < ingredients.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + i % 3 * 18, 7 + i / 3 * 18).addIngredients((class_1856)ingredients.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 17).addItemStack(recipe.getResultItem());
    }

    public void draw(CookingCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 60, 17);
        this.burnIcon.draw(guiGraphics, 98, 42);
        this.drawFluid(guiGraphics, recipe.getFluidAmount());
    }

    private void drawFluid(class_332 guiGraphics, int fluidAmount) {
        int filledHeight = Math.min(fluidAmount, 100) * 43 / 100;
        int x = 147;
        int y = 13 + (43 - filledHeight);
        guiGraphics.method_25302(this.texture, x, y, 176, 31 + (43 - filledHeight), 8, filledHeight);
    }

    @NotNull
    public RecipeType<CookingCauldronRecipe> getRecipeType() {
        return COOKING_CAULDRON;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

