/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.core.compat.jei.category.CheesePressCategory;
import net.satisfy.meadow.core.compat.jei.category.CookingCauldronCategory;
import net.satisfy.meadow.core.compat.jei.category.WoodCutterCategory;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.core.util.MeadowIdentifier;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class MeadowJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingCauldronCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CheesePressCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodCutterCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        class_1863 rm = Objects.requireNonNull(class_310.method_1551().field_1687).method_8433();
        List cookingCauldronRecipes = rm.method_30027((class_3956)RecipeRegistry.COOKING.get());
        registration.addRecipes(CookingCauldronCategory.COOKING_CAULDRON, cookingCauldronRecipes);
        List cheesePressRecipes = rm.method_30027((class_3956)RecipeRegistry.CHEESE.get());
        registration.addRecipes(CheesePressCategory.CHEESE_PRESS, cheesePressRecipes);
        List woodcuttingRecipes = rm.method_30027((class_3956)RecipeRegistry.WOODCUTTING.get());
        registration.addRecipes(WoodCutterCategory.WOODCUTTER, woodcuttingRecipes);
    }

    @NotNull
    public class_2960 getPluginUid() {
        return new MeadowIdentifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CheeseFormGuiHandler.class, (class_3917)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get(), CheesePressCategory.CHEESE_PRESS, 1, 2, 3, 36);
        registration.addRecipeTransferHandler(CookingCauldronGuiHandler.class, (class_3917)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get(), CookingCauldronCategory.COOKING_CAULDRON, 1, 6, 7, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.WOODCUTTER.get()).method_8389().method_7854(), new RecipeType[]{WoodCutterCategory.WOODCUTTER});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.COOKING_CAULDRON.get()).method_8389().method_7854(), new RecipeType[]{CookingCauldronCategory.COOKING_CAULDRON});
        registration.addRecipeCatalyst(((class_2248)ObjectRegistry.CHEESE_FORM.get()).method_8389().method_7854(), new RecipeType[]{CheesePressCategory.CHEESE_PRESS});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, class_1856 ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

