/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.core.block.CookingCauldronBlock;
import net.satisfy.meadow.core.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingCauldronBlockEntity
extends class_2586
implements ImplementedInventory,
class_3908 {
    private static final int MAX_CAPACITY = 8;
    private static final int OUTPUT_SLOT = 0;
    public static final int MAX_COOKING_TIME = 200;
    private static final int INGREDIENTS_START = 1;
    private static final int INGREDIENTS_END = 6;
    private static final int FLUID_INPUT_SLOT = 7;
    private static final int[] SLOTS_FOR_REST = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 7};
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private int cookingTime;
    private boolean isBeingBurned;
    private int fluidLevel;
    private int currentCraftingDuration;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CookingCauldronBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingCauldronBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> CookingCauldronBlockEntity.this.fluidLevel;
                case 3 -> CookingCauldronBlockEntity.this.currentCraftingDuration;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CookingCauldronBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingCauldronBlockEntity.this.isBeingBurned = value != 0;
                    break;
                }
                case 2: {
                    CookingCauldronBlockEntity.this.fluidLevel = value;
                    break;
                }
                case 3: {
                    CookingCauldronBlockEntity.this.currentCraftingDuration = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private boolean fluidInputProcessed = false;

    public CookingCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.COOKING_CAULDRON.get(), pos, state);
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        return side == class_2350.field_11033 ? SLOTS_FOR_DOWN : SLOTS_FOR_REST;
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cookingTime = nbt.method_10550("CookingTime");
        this.isBeingBurned = nbt.method_10577("IsBeingBurned");
        this.fluidLevel = nbt.method_10550("FluidLevel");
        this.currentCraftingDuration = nbt.method_10550("CurrentCraftingDuration");
    }

    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("CookingTime", this.cookingTime);
        nbt.method_10556("IsBeingBurned", this.isBeingBurned);
        nbt.method_10569("FluidLevel", this.fluidLevel);
        nbt.method_10569("CurrentCraftingDuration", this.currentCraftingDuration);
    }

    public boolean isBeingBurned() {
        if (this.method_10997() == null) {
            throw new NullPointerException("Null world invoked");
        }
        if (((Boolean)this.method_11010().method_11654((class_2769)CookingCauldronBlock.HANGING)).booleanValue()) {
            return true;
        }
        Optional optionalList = class_7923.field_41175.method_40266(TagRegistry.ALLOWS_COOKING);
        class_6885.class_6888 entryList = optionalList.orElse(null);
        return entryList != null && entryList.method_40241((class_6880)this.method_10997().method_8320(this.method_11016().method_10074()).method_26204().method_40142());
    }

    private boolean canCraft(CookingCauldronRecipe recipe) {
        if (recipe == null || recipe.getResultItem().method_7960()) {
            return false;
        }
        class_1799 outputSlotStack = this.method_5438(0);
        class_1799 result = recipe.getResultItem().method_7972();
        if (outputSlotStack.method_7960()) {
            return true;
        }
        if (!class_1799.method_31577((class_1799)outputSlotStack, (class_1799)result)) {
            return false;
        }
        return outputSlotStack.method_7947() + result.method_7947() <= outputSlotStack.method_7914();
    }

    private void craft(CookingCauldronRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        class_1799 recipeOutput = recipe.assemble();
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            this.method_5447(0, recipeOutput.method_7972());
        } else if (class_1799.method_7984((class_1799)outputSlotStack, (class_1799)recipe.getResultItem()) && outputSlotStack.method_7947() < outputSlotStack.method_7914()) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        boolean[] ingredientUsed = new boolean[7];
        block0: for (class_1856 ingredient : recipe.method_8117()) {
            for (int slotIndex = 1; slotIndex <= 6; ++slotIndex) {
                if (ingredientUsed[slotIndex] || !ingredient.method_8093(this.method_5438(slotIndex))) continue;
                ingredientUsed[slotIndex] = true;
                class_1799 stackInSlot = this.method_5438(slotIndex);
                class_1799 remainderStack = this.getRemainderItem(stackInSlot);
                stackInSlot.method_7934(1);
                if (remainderStack.method_7960()) continue block0;
                if (stackInSlot.method_7960()) {
                    this.method_5447(slotIndex, remainderStack);
                    continue block0;
                }
                this.handleRemainder(remainderStack, slotIndex);
                continue block0;
            }
        }
        this.consumeFluid(recipe.getFluidAmount());
    }

    private void handleRemainder(class_1799 remainderStack, int originalSlot) {
        if (originalSlot == 7) {
            class_1799 currentFluidSlot = this.method_5438(7);
            if (currentFluidSlot.method_7960()) {
                this.method_5447(7, remainderStack.method_7972());
            } else {
                this.dropItemIntoWorld(remainderStack, this.field_11867);
            }
            return;
        }
        boolean added = false;
        for (int i = 1; i <= 6; ++i) {
            class_1799 is = this.method_5438(i);
            if (is.method_7960()) {
                this.method_5447(i, remainderStack.method_7972());
                added = true;
                break;
            }
            if (!class_1799.method_7984((class_1799)is, (class_1799)remainderStack) || is.method_7947() + remainderStack.method_7947() > is.method_7914()) continue;
            is.method_7933(remainderStack.method_7947());
            added = true;
            break;
        }
        if (!added) {
            this.dropItemIntoWorld(remainderStack, this.field_11867);
        }
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858()));
        }
        return class_1799.field_8037;
    }

    private void dropItemIntoWorld(class_1799 itemStack, class_2338 pos) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            double offsetX = this.field_11863.field_9229.method_43058() * 0.7 + 0.15;
            double offsetY = this.field_11863.field_9229.method_43058() * 0.5 + 0.1;
            double offsetZ = this.field_11863.field_9229.method_43058() * 0.7 + 0.15;
            class_1542 itemEntity = new class_1542(this.field_11863, (double)pos.method_10263() + offsetX, (double)pos.method_10264() + offsetY, (double)pos.method_10260() + offsetZ, itemStack);
            this.field_11863.method_8649((class_1297)itemEntity);
        }
    }

    private void processFluidInput() {
        class_1799 fluidItem = this.method_5438(7);
        if (!fluidItem.method_7960()) {
            boolean processed = false;
            int fluidAmount = 0;
            if (fluidItem.method_31573(TagRegistry.SMALL_WATER_FILL)) {
                fluidAmount = 25;
                processed = true;
            } else if (fluidItem.method_31573(TagRegistry.LARGE_WATER_FILL)) {
                fluidAmount = 50;
                processed = true;
            }
            if (processed) {
                class_1799 consumedItem = fluidItem.method_7971(1);
                this.method_5447(7, fluidItem);
                class_1799 remainder = this.getRemainderItem(consumedItem);
                if (!remainder.method_7960()) {
                    this.handleRemainder(remainder, 7);
                }
                this.addFluid(fluidAmount);
                this.method_5431();
            }
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        class_1799 fluidItem;
        if (world.method_8608()) {
            return;
        }
        if (!this.fluidInputProcessed) {
            this.processFluidInput();
            this.fluidInputProcessed = true;
        }
        if ((fluidItem = this.method_5438(7)).method_7960() || !fluidItem.method_31573(TagRegistry.SMALL_WATER_FILL) && !fluidItem.method_31573(TagRegistry.LARGE_WATER_FILL)) {
            this.fluidInputProcessed = false;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned && ((Boolean)state.method_11654((class_2769)CookingCauldronBlock.LIT)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        CookingCauldronRecipe recipe = world.method_8433().method_8132((class_3956)RecipeRegistry.COOKING.get(), (class_1263)this, world).orElse(null);
        if (this.canCraft(recipe) && this.fluidLevel >= recipe.getFluidAmount()) {
            if (this.currentCraftingDuration == 0) {
                this.currentCraftingDuration = recipe.getCraftingDuration() * 20;
                this.delegate.method_17391(3, this.currentCraftingDuration);
            }
            ++this.cookingTime;
            this.delegate.method_17391(0, this.cookingTime);
            if (this.cookingTime >= this.currentCraftingDuration) {
                this.cookingTime = 0;
                this.currentCraftingDuration = 0;
                this.delegate.method_17391(3, 0);
                this.craft(recipe);
            }
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.cookingTime = 0;
            this.currentCraftingDuration = 0;
            this.delegate.method_17391(0, 0);
            this.delegate.method_17391(3, 0);
            if (((Boolean)state.method_11654((class_2769)CookingCauldronBlock.COOKING)).booleanValue()) {
                world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return ((class_2248)ObjectRegistry.COOKING_CAULDRON.get()).method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new CookingCauldronGuiHandler(syncId, inv, (class_1263)this, this.delegate);
    }

    public int getFluidLevel() {
        return Math.min(this.fluidLevel, 100);
    }

    private void addFluid(int amount) {
        this.fluidLevel = Math.min(this.fluidLevel + amount, 100);
        this.delegate.method_17391(2, this.fluidLevel);
    }

    private void consumeFluid(int amount) {
        this.fluidLevel = Math.max(this.fluidLevel - amount, 0);
        this.delegate.method_17391(2, this.fluidLevel);
    }
}

