/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.fabric.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.ShoulderSurfingCompatMixinPlugin;
import com.github.exopandora.shouldersurfing.fabric.Platform;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.Version;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPluginFabric
extends ShoulderSurfingCompatMixinPlugin {
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPluginFabric.addCommonCompatMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addCreateModMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addIrisMixins(mixins);
        ShoulderSurfingCompatMixinPluginFabric.addSkinLayersMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addIrisMixins(List<String> mixins) {
        String irisModVersion = Mods.IRIS.getModVersion();
        if (irisModVersion != null) {
            Version version = Platform.parseVersionSilent(irisModVersion);
            if (Platform.parseVersionPredicateSilent(">=1.7.0-snapshot").test((Object)version)) {
                mixins.add("iris.MixinSheets_1_7_0");
            } else if (Platform.parseVersionPredicateSilent("<1.7.0-snapshot >=1.6.17").test((Object)version)) {
                mixins.add("iris.MixinSheets_1_6_15");
            }
        }
    }

    private static void addCreateModMixins(List<String> mixins) {
        String createModVersion = Mods.CREATE.getModVersion();
        if (createModVersion != null) {
            Version version = Platform.parseVersionSilent(createModVersion);
            if (Platform.parseVersionPredicateSilent(">=6.0.0").test((Object)version)) {
                mixins.add("create.MixinContraptionHandlerClient_6_0_0");
            } else if (Platform.parseVersionPredicateSilent("<6.0.0").test((Object)version)) {
                mixins.add("create.MixinContraptionHandlerClient_0_5_0");
            }
        }
    }

    private static void addSkinLayersMixins(List<String> mixins) {
        String skinLayersModVersion = Mods.SKIN_LAYERS.getModVersion();
        if (skinLayersModVersion != null) {
            Version version = Platform.parseVersionSilent(skinLayersModVersion);
            if (Platform.parseVersionPredicateSilent(">=1.6.6").test((Object)version)) {
                mixins.add("skinlayers.MixinCustomizableModelPart_1_6_6");
            } else if (Platform.parseVersionPredicateSilent("<1.6.6").test((Object)version)) {
                mixins.add("skinlayers.MixinCustomizableModelPart_1_6_5");
            }
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

