/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.IPlayerInputCallback;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class InputHandler {
    public static final class_304 CAMERA_LEFT = InputHandler.createKeyMapping("adjust_camera_left", 263);
    public static final class_304 CAMERA_RIGHT = InputHandler.createKeyMapping("adjust_camera_right", 262);
    public static final class_304 CAMERA_IN = InputHandler.createKeyMapping("adjust_camera_in", 265);
    public static final class_304 CAMERA_OUT = InputHandler.createKeyMapping("adjust_camera_out", 264);
    public static final class_304 CAMERA_UP = InputHandler.createKeyMapping("adjust_camera_up", 266);
    public static final class_304 CAMERA_DOWN = InputHandler.createKeyMapping("adjust_camera_down", 267);
    public static final class_304 SWAP_SHOULDER = InputHandler.createKeyMapping("swap_shoulder", 79);
    public static final class_304 TOGGLE_FIRST_PERSON = InputHandler.createKeyMapping("toggle_first_person", class_3675.field_16237.method_1444());
    public static final class_304 TOGGLE_THIRD_PERSON_FRONT = InputHandler.createKeyMapping("toggle_third_person_front", class_3675.field_16237.method_1444());
    public static final class_304 TOGGLE_THIRD_PERSON_BACK = InputHandler.createKeyMapping("toggle_third_person_back", class_3675.field_16237.method_1444());
    public static final class_304 FREE_LOOK = InputHandler.createKeyMapping("free_look", 342);
    public static final class_304 TOGGLE_CAMERA_COUPLING = InputHandler.createKeyMapping("toggle_camera_coupling", class_3675.field_16237.method_1444());
    public static final class_304 TOGGLE_X_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_x_offset_presets", class_3675.field_16237.method_1444());
    public static final class_304 TOGGLE_Y_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_y_offset_presets", class_3675.field_16237.method_1444());
    public static final class_304 TOGGLE_Z_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_z_offset_presets", class_3675.field_16237.method_1444());
    private final ShoulderSurfingImpl instance;

    public InputHandler(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public void tick() {
        class_315 options = class_310.method_1551().field_1690;
        while (TOGGLE_FIRST_PERSON.method_1436()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.FIRST_PERSON);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (TOGGLE_THIRD_PERSON_FRONT.method_1436()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.THIRD_PERSON_FRONT);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (TOGGLE_THIRD_PERSON_BACK.method_1436()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.THIRD_PERSON_BACK);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (CAMERA_LEFT.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraLeft();
        }
        while (CAMERA_RIGHT.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraRight();
        }
        while (CAMERA_OUT.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraOut();
        }
        while (CAMERA_IN.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraIn();
        }
        while (CAMERA_UP.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraUp();
        }
        while (CAMERA_DOWN.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraDown();
        }
        while (SWAP_SHOULDER.method_1436()) {
            if (!this.instance.isShoulderSurfing()) continue;
            this.instance.swapShoulder();
        }
        while (options.field_1824.method_1436()) {
            this.instance.togglePerspective();
        }
        while (FREE_LOOK.method_1436()) {
        }
        while (TOGGLE_CAMERA_COUPLING.method_1436()) {
            this.instance.toggleCameraCoupling();
        }
        while (TOGGLE_X_OFFSET_PRESETS.method_1436()) {
            this.instance.toggleOffsetXPreset();
        }
        while (TOGGLE_Y_OFFSET_PRESETS.method_1436()) {
            this.instance.toggleOffsetYPreset();
        }
        while (TOGGLE_Z_OFFSET_PRESETS.method_1436()) {
            this.instance.toggleOffsetZPreset();
        }
    }

    public void updateMovementInput(class_744 input) {
        class_310 minecraft = class_310.method_1551();
        class_1297 cameraEntity = minecraft.method_1560();
        for (IPlayerInputCallback callback : ShoulderSurfingRegistrar.getInstance().getPlayerInputCallbacks()) {
            if (!callback.isForcingVanillaMovementInput(new IPlayerInputCallback.IsForcingVanillaMovementInputContext(minecraft, cameraEntity))) continue;
            return;
        }
        Vec2f moveVector = new Vec2f(input.field_3907, input.field_3905);
        if (this.instance.isShoulderSurfing() && this.instance.isFreeLooking()) {
            moveVector.rotateDegrees(class_3532.method_15381((float)cameraEntity.method_36454(), (float)this.instance.getCamera().getFreeLookYRot()));
            input.field_3907 = moveVector.x();
            input.field_3905 = moveVector.y();
        } else if (this.instance.isShoulderSurfing() && minecraft.field_1724 != null && cameraEntity == minecraft.field_1724) {
            if (moveVector.lengthSquared() > 0.0) {
                ShoulderSurfingCamera camera = this.instance.getCamera();
                class_746 player = minecraft.field_1724;
                float yRot = player.method_36454();
                if (this.instance.isEntityRotationDecoupled((class_1309)player, minecraft)) {
                    float cameraXRot = camera.getXRot();
                    float cameraYRot = camera.getYRot();
                    Vec2f rotated = moveVector.rotateDegrees(cameraYRot);
                    float xRot = cameraXRot * 0.5f;
                    float xRotO = player.method_36455();
                    float yRotO = yRot;
                    yRot = (float)class_3532.method_15338((double)(Math.atan2(-rotated.x(), rotated.y()) * 57.2957763671875));
                    xRot = xRotO + class_3532.method_15381((float)xRotO, (float)xRot) * 0.25f;
                    yRot = yRotO + class_3532.method_15381((float)yRotO, (float)yRot) * 0.25f;
                    player.method_36457(xRot);
                    player.method_36456(yRot);
                }
                moveVector = moveVector.rotateDegrees(class_3532.method_15381((float)yRot, (float)camera.getYRot()));
            }
            input.field_3907 = moveVector.x();
            input.field_3905 = moveVector.y();
        }
    }

    @NotNull
    private static class_304 createKeyMapping(String key, int keyCode) {
        return new class_304("key.shouldersurfing." + key, keyCode, "Shoulder Surfing");
    }
}

