/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import io.github.moremcmeta.moremcmeta.api.client.texture.FrameGroup;
import io.github.moremcmeta.moremcmeta.api.client.texture.FrameIndexOutOfBoundsException;
import io.github.moremcmeta.moremcmeta.api.client.texture.FrameView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class FrameGroupImpl<F extends FrameView>
implements FrameGroup<F> {
    private final List<F> FRAMES;

    public FrameGroupImpl(List<? extends F> frames) {
        Objects.requireNonNull(frames, "Frames cannot be null");
        if (frames.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("No frame can be null");
        }
        this.FRAMES = new ArrayList<F>(frames);
    }

    public <T> FrameGroupImpl(List<? extends T> frames, BiFunction<? super T, ? super Integer, ? extends F> viewConstructor) {
        this(IntStream.range(0, Objects.requireNonNull(frames, "Frames cannot be null").size()).mapToObj(index -> (FrameView)Objects.requireNonNull(viewConstructor, "View constructor cannot be null").apply(Objects.requireNonNull(frames.get(index), "No frame can be null"), index)).toList());
    }

    @Override
    public F frame(int index) {
        if (index < 0 || index >= this.FRAMES.size()) {
            throw new FrameIndexOutOfBoundsException(index);
        }
        return (F)((FrameView)this.FRAMES.get(index));
    }

    @Override
    public int frames() {
        return this.FRAMES.size();
    }

    @Override
    @NotNull
    public Iterator<F> iterator() {
        return this.FRAMES.iterator();
    }
}

