/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.moremcmeta.moremcmeta.impl.client.mixinaccess.NamedTexture;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class BoundTextureState {
    public static final ConcurrentHashMap<Integer, NamedTexture> TEXTURES_BY_ID = new ConcurrentHashMap();
    public static final int[] BOUND_TEXTURES = new int[12];

    public static Optional<NamedTexture> currentTexture() {
        int activeTexture = GlStateManager._getActiveTexture() - 33984;
        if (activeTexture < 0 || activeTexture >= BOUND_TEXTURES.length) {
            return Optional.empty();
        }
        int textureId = BOUND_TEXTURES[activeTexture];
        if (textureId == -1) {
            return Optional.empty();
        }
        if (textureId >= 0) {
            return Optional.ofNullable(TEXTURES_BY_ID.get(textureId));
        }
        return Optional.empty();
    }

    private BoundTextureState() {
    }
}

