/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import com.google.common.collect.ImmutableSet;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Atlas;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Sprite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2960;

public final class AtlasFinder {
    private final Function<class_2960, ? extends Atlas> ATLAS_GETTER;
    private final Set<class_2960> ATLAS_LOCATIONS;

    public AtlasFinder(Function<class_2960, ? extends Atlas> atlasGetter, Set<class_2960> atlasLocations) {
        this.ATLAS_GETTER = Objects.requireNonNull(atlasGetter, "Atlas getter cannot be null");
        this.ATLAS_LOCATIONS = ImmutableSet.copyOf((Collection)Objects.requireNonNull(atlasLocations, "Atlas locations cannot be null"));
    }

    public List<Sprite> findSprites(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        return this.findNew(location);
    }

    private List<Sprite> findNew(class_2960 location) {
        ArrayList<Sprite> results = new ArrayList<Sprite>();
        for (class_2960 atlasLocation : this.ATLAS_LOCATIONS) {
            Atlas atlas = this.ATLAS_GETTER.apply(atlasLocation);
            Objects.requireNonNull(atlas, "Atlas getter cannot supply null");
            results.addAll(atlas.sprite(location));
        }
        return results;
    }
}

