/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.resource;

import com.google.common.collect.ImmutableMap;
import io.github.moremcmeta.moremcmeta.api.client.metadata.GuiScaling;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureData;
import io.github.moremcmeta.moremcmeta.impl.client.resource.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_6328;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

@class_6328
public final class SpriteFrameSizeFixPack
implements class_3262 {
    private static final String VANILLA_METADATA_EXTENSION = ".mcmeta";
    private final ImmutableMap<? extends class_2960, ? extends TextureData<?>> TEXTURES;
    private final ImmutableMap<? extends String, ? extends StreamSource> ROOT_RESOURCES;

    public SpriteFrameSizeFixPack(Map<? extends class_2960, ? extends TextureData<?>> textures, Map<? extends String, ? extends StreamSource> rootResources) {
        Objects.requireNonNull(textures, "Textures cannot be null");
        Objects.requireNonNull(rootResources, "Root resources cannot be null");
        this.TEXTURES = ImmutableMap.copyOf(textures);
        this.ROOT_RESOURCES = ImmutableMap.copyOf(rootResources);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... resourceNames) {
        Objects.requireNonNull(resourceNames, "Resource name cannot be null");
        if (resourceNames.length > 0 && this.ROOT_RESOURCES.containsKey((Object)resourceNames[0])) {
            return () -> ((StreamSource)this.ROOT_RESOURCES.get((Object)resourceNames[0])).get();
        }
        return null;
    }

    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        Objects.requireNonNull(packType, "Pack type cannot be null");
        Objects.requireNonNull(location, "Location cannot be null");
        if (packType != class_3264.field_14188) {
            return null;
        }
        Optional<class_2960> textureLocationOptional = this.getTextureLocation(location);
        if (textureLocationOptional.isEmpty()) {
            return null;
        }
        class_2960 textureLocation = textureLocationOptional.get();
        boolean isKnownTexture = this.TEXTURES.containsKey((Object)textureLocation);
        boolean isVanillaMetadata = location.method_12832().endsWith(VANILLA_METADATA_EXTENSION);
        if (isKnownTexture && isVanillaMetadata) {
            TextureData textureData = (TextureData)this.TEXTURES.get((Object)textureLocation);
            int frameWidth = textureData.frameSize().width();
            int frameHeight = textureData.frameSize().height();
            Optional<GuiScaling> guiScaling = textureData.guiScaling();
            return () -> new ByteArrayInputStream(SpriteFrameSizeFixPack.makeReplacementJson(guiScaling, frameWidth, frameHeight).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String pathStart, class_3262.class_7664 resourceOutput) {
        Objects.requireNonNull(packType, "Pack type cannot be null");
        Objects.requireNonNull(namespace, "Namespace cannot be null");
        Objects.requireNonNull(pathStart, "Path start cannot be null");
        Objects.requireNonNull(resourceOutput, "Resource supplier cannot be null");
        if (packType == class_3264.field_14190) {
            return;
        }
        Object directoryStart = !pathStart.isEmpty() ? pathStart + "/" : "";
        this.TEXTURES.keySet().forEach(arg_0 -> this.lambda$listResources$3(namespace, (String)directoryStart, resourceOutput, arg_0));
    }

    public Set<String> method_14406(class_3264 packType) {
        Objects.requireNonNull(packType, "Pack type cannot be null");
        return packType == class_3264.field_14188 ? this.TEXTURES.keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet()) : Set.of();
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metadataSectionSerializer) {
        Objects.requireNonNull(metadataSectionSerializer, "Serializer cannot be null");
        return null;
    }

    public String method_14409() {
        return "__MoreMcmeta Internal__";
    }

    public void close() {
    }

    private Optional<class_2960> getTextureLocation(class_2960 location) {
        return Optional.ofNullable(class_2960.method_43902((String)location.method_12836(), (String)location.method_12832().replace(VANILLA_METADATA_EXTENSION, "")));
    }

    private Optional<class_2960> getMetadataLocation(class_2960 location) {
        return Optional.ofNullable(class_2960.method_43902((String)location.method_12836(), (String)(location.method_12832() + VANILLA_METADATA_EXTENSION)));
    }

    private static String makeReplacementJson(Optional<GuiScaling> guiScalingOptional, int frameWidth, int frameHeight) {
        ArrayList<String> sections = new ArrayList<String>();
        sections.add(String.format("\"animation\": { \"width\": %d, \"height\": %d, \"frames\": [0] }", frameWidth, frameHeight));
        guiScalingOptional.ifPresent(guiScaling -> sections.add(SpriteFrameSizeFixPack.makeGuiScalingJson(guiScaling, frameWidth, frameHeight)));
        return String.format("{ %s }", String.join((CharSequence)", ", sections));
    }

    private static String makeGuiScalingJson(GuiScaling guiScaling, int frameWidth, int frameHeight) {
        Object scaling = String.format("\"type\": \"%s\"", guiScaling.name());
        if (guiScaling instanceof GuiScaling.Tile || guiScaling instanceof GuiScaling.NineSlice) {
            scaling = (String)scaling + String.format(", \"width\": %d, \"height\": %d", frameWidth, frameHeight);
        }
        if (guiScaling instanceof GuiScaling.NineSlice) {
            GuiScaling.NineSlice nineSlice = (GuiScaling.NineSlice)guiScaling;
            scaling = (String)scaling + String.format(", \"border\": { \"left\": %d, \"right\": %d, \"top\": %d, \"bottom\": %d }", nineSlice.left(), nineSlice.right(), nineSlice.top(), nineSlice.bottom());
        }
        return String.format("\"gui\": { \"scaling\": { %s } }", scaling);
    }

    private /* synthetic */ void lambda$listResources$3(String namespace, String directoryStart, class_3262.class_7664 resourceOutput, class_2960 location) {
        String path = location.method_12832();
        boolean isRightNamespace = location.method_12836().equals(namespace);
        boolean isRightPath = path.startsWith(directoryStart);
        if (isRightNamespace && isRightPath) {
            this.getMetadataLocation(location).ifPresent(metadataLocation -> resourceOutput.accept(metadataLocation, this.method_14405(class_3264.field_14188, (class_2960)metadataLocation)));
        }
    }
}

