/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.moremcmeta.moremcmeta.impl.client.mixinaccess.LocatableSpriteAtlas;
import io.github.moremcmeta.moremcmeta.impl.client.mixinaccess.NamedTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.BoundTextureState;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_291.class})
public class VertexBufferMixin {
    @Unique
    private final Map<NamedTexture, Set<class_2960>> BOUND_TEXTURE_TO_BASES = new HashMap<NamedTexture, Set<class_2960>>();
    @Unique
    private final LongSet UV_COORDS = new LongRBTreeSet();
    @Unique
    private boolean dirty;
    @Shadow
    @Nullable
    private class_293 field_29339;

    @Inject(method={"upload(Lcom/mojang/blaze3d/vertex/BufferBuilder$RenderedBuffer;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/BufferBuilder$RenderedBuffer;drawState()Lcom/mojang/blaze3d/vertex/BufferBuilder$DrawState;")})
    private void moremcmeta_onBufferUpload(class_287.class_7433 meshData, CallbackInfo callbackInfo) {
        class_287.class_4574 drawState = meshData.method_43583();
        class_293 newFormat = drawState.comp_749();
        int verticesPerPolygon = drawState.comp_752().field_27384;
        int uOffset = 0;
        boolean hasUv = false;
        for (class_296 element : newFormat.method_1357()) {
            if (element.method_1382().equals((Object)class_296.class_298.field_1636)) {
                hasUv = true;
                break;
            }
            uOffset += element.method_1387();
        }
        if (!hasUv) {
            this.BOUND_TEXTURE_TO_BASES.clear();
            this.UV_COORDS.clear();
            this.dirty = false;
            return;
        }
        if (!newFormat.equals((Object)this.field_29339)) {
            this.BOUND_TEXTURE_TO_BASES.clear();
            this.UV_COORDS.clear();
        }
        this.dirty = true;
        int vOffset = uOffset + 4;
        int vertexSize = newFormat.method_1362();
        ByteBuffer vertexBuffer = meshData.method_43581();
        if (vertexBuffer == null) {
            return;
        }
        int vertices = drawState.comp_750();
        int baseIndex = 0;
        for (int polygon = 0; polygon < vertices / verticesPerPolygon; ++polygon) {
            float uSum = 0.0f;
            float vSum = 0.0f;
            for (int vertex = 0; vertex < verticesPerPolygon; ++vertex) {
                uSum += vertexBuffer.getFloat(baseIndex + uOffset);
                vSum += vertexBuffer.getFloat(baseIndex + vOffset);
                baseIndex += vertexSize;
            }
            float centerU = uSum / (float)verticesPerPolygon;
            float centerV = vSum / (float)verticesPerPolygon;
            this.UV_COORDS.add(VertexBufferMixin.packUv(centerU, centerV));
        }
    }

    @Inject(method={"draw()V"}, at={@At(value="HEAD")})
    private void moremcmeta_onBufferDraw(CallbackInfo callbackInfo) {
        int oldActiveTexture = GlStateManager._getActiveTexture();
        GlStateManager._activeTexture((int)33984);
        BoundTextureState.currentTexture().ifPresent(boundTexture -> {
            Set textures = this.BOUND_TEXTURE_TO_BASES.computeIfAbsent((NamedTexture)boundTexture, key -> new HashSet());
            if (this.dirty) {
                if (boundTexture instanceof LocatableSpriteAtlas) {
                    LocatableSpriteAtlas boundAtlas = (LocatableSpriteAtlas)((Object)boundTexture);
                    LongIterator longIterator = this.UV_COORDS.iterator();
                    while (longIterator.hasNext()) {
                        long packedCoords = (Long)longIterator.next();
                        float centerU = VertexBufferMixin.unpackU(packedCoords);
                        float centerV = VertexBufferMixin.unpackV(packedCoords);
                        Optional<class_1058> possibleSprite = boundAtlas.moremcmeta_findSprite(centerU, centerV);
                        possibleSprite.ifPresent(sprite -> textures.add(sprite.method_45851().method_45816()));
                    }
                } else {
                    textures.addAll(boundTexture.moremcmeta_names());
                }
                this.dirty = false;
                this.UV_COORDS.clear();
            }
            NamedTexture.uploadDependencies(textures);
        });
        GlStateManager._activeTexture((int)oldActiveTexture);
    }

    private static long packUv(float u, float v) {
        return (long)Float.floatToIntBits(u) << 32 | (long)Float.floatToIntBits(v);
    }

    private static float unpackU(long packedCoords) {
        return Float.intBitsToFloat((int)(packedCoords >>> 32));
    }

    private static float unpackV(long packedCoords) {
        return Float.intBitsToFloat((int)packedCoords);
    }
}

