/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.moremcmeta.moremcmeta.impl.client.mixinaccess.NamedTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.BoundTextureState;
import net.minecraft.class_1059;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GlStateManager.class}, remap=false)
public class GlStateManagerMixin {
    @Shadow
    private static int activeTexture;

    @Inject(method={"_deleteTexture(I)V"}, at={@At(value="HEAD")})
    private static void moremcmeta_onDeleteTexture(int textureId, CallbackInfo callbackInfo) {
        for (int index = 0; index < BoundTextureState.BOUND_TEXTURES.length; ++index) {
            if (BoundTextureState.BOUND_TEXTURES[index] != textureId) continue;
            BoundTextureState.BOUND_TEXTURES[index] = -1;
        }
    }

    @Inject(method={"_deleteTextures([I)V"}, at={@At(value="HEAD")})
    private static void moremcmeta_onDeleteTextures(int[] textureIds, CallbackInfo callbackInfo) {
        block0: for (int index = 0; index < BoundTextureState.BOUND_TEXTURES.length; ++index) {
            for (int textureId : textureIds) {
                if (BoundTextureState.BOUND_TEXTURES[index] != textureId) continue;
                BoundTextureState.BOUND_TEXTURES[index] = -1;
                continue block0;
            }
        }
    }

    @Inject(method={"_bindTexture(I)V"}, at={@At(value="RETURN")})
    private static void moremcmeta_onBindTexture(int textureId, CallbackInfo callbackInfo) {
        if (activeTexture < 0 || activeTexture >= BoundTextureState.BOUND_TEXTURES.length) {
            return;
        }
        BoundTextureState.BOUND_TEXTURES[GlStateManagerMixin.activeTexture] = textureId;
        NamedTexture boundTexture = BoundTextureState.TEXTURES_BY_ID.get(textureId);
        if (boundTexture != null && !(boundTexture instanceof class_1059)) {
            NamedTexture.uploadDependencies(boundTexture.moremcmeta_names());
        }
    }
}

