/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.io;

import com.google.common.collect.ImmutableList;
import io.github.moremcmeta.moremcmeta.api.client.metadata.AnalyzedMetadata;
import io.github.moremcmeta.moremcmeta.api.client.texture.ColorTransform;
import io.github.moremcmeta.moremcmeta.api.client.texture.ComponentBuilder;
import io.github.moremcmeta.moremcmeta.api.client.texture.CurrentFrameView;
import io.github.moremcmeta.moremcmeta.api.client.texture.IllegalFrameReferenceException;
import io.github.moremcmeta.moremcmeta.api.client.texture.MutableFrameView;
import io.github.moremcmeta.moremcmeta.api.client.texture.TextureComponent;
import io.github.moremcmeta.moremcmeta.api.math.Area;
import io.github.moremcmeta.moremcmeta.impl.client.io.FrameReader;
import io.github.moremcmeta.moremcmeta.impl.client.io.ImageAllocator;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureData;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CleanupComponent;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImage;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImageFrame;
import io.github.moremcmeta.moremcmeta.impl.client.texture.EventDrivenTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.FrameGroupImpl;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Triple;

public final class TextureDataAssembler<I extends CloseableImage> {
    public static final int EXTERNAL_DEFAULT_COMPONENTS = 1;
    private static final int INTERNAL_DEFAULT_COMPONENTS = 1;
    private final ImageAllocator ALLOCATOR;
    private final BiFunction<? super I, Integer, ? extends List<? extends I>> MIPMAP_GENERATOR;

    public TextureDataAssembler(ImageAllocator allocator, BiFunction<? super I, Integer, ? extends List<? extends I>> mipmapGenerator) {
        this.ALLOCATOR = Objects.requireNonNull(allocator, "Allocator cannot be null");
        this.MIPMAP_GENERATOR = Objects.requireNonNull(mipmapGenerator, "Mipmap generator cannot be null");
    }

    public EventDrivenTexture.Builder assemble(TextureData<? extends I> data) {
        Objects.requireNonNull(data, "Data cannot be null");
        I original = data.image();
        int frameWidth = data.frameSize().width();
        int frameHeight = data.frameSize().height();
        boolean blur = data.blur();
        boolean clamp = data.clamp();
        int maxMipmapX = class_3532.method_15351((int)Integer.lowestOneBit(frameWidth));
        int maxMipmapY = class_3532.method_15351((int)Integer.lowestOneBit(frameHeight));
        int layers = data.analyzedMetadata().size() + 1 + 1;
        List<? extends I> mipmaps = this.MIPMAP_GENERATOR.apply(original, Math.min(maxMipmapX, maxMipmapY));
        ImmutableList<CloseableImageFrame> frames = this.readFrames(mipmaps, frameWidth, frameHeight, layers);
        CloseableImageFrame generatedFrame = this.createGeneratedFrame(mipmaps, frameWidth, frameHeight, blur, clamp, layers);
        Runnable closeMipmaps = () -> {
            frames.forEach(CloseableImageFrame::close);
            generatedFrame.close();
        };
        EventDrivenTexture.Builder builder = new EventDrivenTexture.Builder();
        builder.setPredefinedFrames((List<? extends CloseableImageFrame>)frames).setGeneratedFrame(generatedFrame);
        for (int index = 0; index < data.analyzedMetadata().size(); ++index) {
            Triple<String, AnalyzedMetadata, ComponentBuilder> metadata = data.analyzedMetadata().get(index);
            AnalyzedMetadata sectionData = (AnalyzedMetadata)metadata.getMiddle();
            builder.add(this.buildComponent((ComponentBuilder)metadata.getRight(), (List<CloseableImageFrame>)frames, generatedFrame, sectionData, index));
        }
        builder.add(new CleanupComponent(closeMipmaps));
        return builder;
    }

    private ImmutableList<CloseableImageFrame> readFrames(List<? extends I> mipmaps, int frameWidth, int frameHeight, int layers) {
        int mipmap = mipmaps.size() - 1;
        FrameReader<CloseableImageFrame> frameReader = new FrameReader<CloseableImageFrame>(frameData -> {
            ImmutableList subImageMipmaps = (ImmutableList)IntStream.rangeClosed(0, mipmap).mapToObj(level -> ((CloseableImage)mipmaps.get(level)).subImage(frameData.xOffset() >> level, frameData.yOffset() >> level, frameData.width() >> level, frameData.height() >> level)).collect(ImmutableList.toImmutableList());
            return new CloseableImageFrame((FrameReader.FrameData)frameData, (ImmutableList<? extends CloseableImage>)subImageMipmaps, layers);
        });
        return frameReader.read(((CloseableImage)mipmaps.get(0)).width(), ((CloseableImage)mipmaps.get(0)).height(), frameWidth, frameHeight);
    }

    private CloseableImageFrame createGeneratedFrame(List<? extends I> mipmaps, int frameWidth, int frameHeight, boolean blur, boolean clamp, int layers) {
        ImmutableList.Builder images = new ImmutableList.Builder();
        for (int level = 0; level < mipmaps.size(); ++level) {
            int mipmappedWidth = frameWidth >> level;
            int mipmappedHeight = frameHeight >> level;
            CloseableImage image = this.ALLOCATOR.allocate(mipmappedWidth, mipmappedHeight, level, blur, clamp);
            image.copyFrom((CloseableImage)mipmaps.get(level));
            images.add((Object)image);
        }
        return new CloseableImageFrame(new FrameReader.FrameData(frameWidth, frameHeight, 0, 0), (ImmutableList<? extends CloseableImage>)images.build(), layers);
    }

    private TextureComponent<? super CurrentFrameView> buildComponent(ComponentBuilder builder, List<CloseableImageFrame> frames, CloseableImageFrame generatedFrame, AnalyzedMetadata metadata, int layer) {
        FrameGroupImpl<MutableFrameViewImpl> mutableFrames = new FrameGroupImpl<MutableFrameViewImpl>(frames, (frame, index) -> {
            if (index == 0) {
                return new MutableFrameViewImpl(layer, (CloseableImageFrame)frame, generatedFrame);
            }
            return new MutableFrameViewImpl(layer, (CloseableImageFrame)frame, new CloseableImageFrame[0]);
        });
        TextureComponent<? super CurrentFrameView> component = builder.build(metadata, mutableFrames);
        mutableFrames.forEach(MutableFrameViewImpl::invalidate);
        return component;
    }

    private static class MutableFrameViewImpl
    implements MutableFrameView {
        private final CloseableImageFrame FRAME;
        private final CloseableImageFrame[] OTHER_FRAMES;
        private final int LAYER;
        private boolean valid;

        public MutableFrameViewImpl(int layer, CloseableImageFrame frame, CloseableImageFrame ... otherFrames) {
            this.LAYER = layer;
            this.FRAME = frame;
            this.OTHER_FRAMES = otherFrames;
            this.valid = true;
        }

        @Override
        public int width() {
            this.checkValid();
            return this.FRAME.width();
        }

        @Override
        public int height() {
            this.checkValid();
            return this.FRAME.height();
        }

        @Override
        public void transform(ColorTransform transform, Area applyArea) {
            this.checkValid();
            this.FRAME.applyTransform(transform, applyArea, this.LAYER);
            for (CloseableImageFrame frame : this.OTHER_FRAMES) {
                frame.applyTransform(transform, applyArea, this.LAYER);
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        private void checkValid() throws IllegalFrameReferenceException {
            if (!this.valid) {
                throw new IllegalFrameReferenceException();
            }
        }
    }
}

