/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import io.github.moremcmeta.moremcmeta.impl.client.resource.ResourceCollection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public final class RootResourcesAdapter
implements ResourceCollection {
    public static final String ROOT_NAMESPACE = "__moremcmeta_root__";
    private final class_3262 ORIGINAL;
    private final Map<class_2960, class_7367<InputStream>> ROOT_RESOURCES;
    private final String ROOT_PATH_PREFIX;

    public static boolean isRootResource(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        return ROOT_NAMESPACE.equals(location.method_12836());
    }

    public static class_2960 locateForPackScreen(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        if (RootResourcesAdapter.isRootResource(location)) {
            return new class_2960("minecraft", location.method_12832());
        }
        return location;
    }

    public RootResourcesAdapter(class_3262 original) {
        this.ORIGINAL = Objects.requireNonNull(original, "Original pack cannot be null");
        this.ROOT_RESOURCES = new ConcurrentHashMap<class_2960, class_7367<InputStream>>();
        String packId = this.ORIGINAL.method_14409();
        String sanitizedName = class_156.method_30309((String)packId, class_2960::method_29184);
        String idHash = Hashing.sha1().hashUnencodedChars((CharSequence)packId).toString();
        this.ROOT_PATH_PREFIX = "pack/" + sanitizedName + "/" + idHash + "/";
    }

    @Override
    public InputStream find(class_3264 resourceType, class_2960 location) throws IOException {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(location, "Location cannot be null");
        class_7367<InputStream> resourceSupplier = this.ROOT_RESOURCES.get(location);
        if (resourceSupplier == null) {
            throw new IOException(String.format("Could not find %s in pack type %s", location, resourceType));
        }
        return (InputStream)resourceSupplier.get();
    }

    @Override
    public boolean contains(class_3264 resourceType, class_2960 location) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(location, "Location cannot be null");
        return this.ROOT_RESOURCES.containsKey(location);
    }

    @Override
    public Collection<class_2960> list(class_3264 resourceType, String namespace, String pathStart, Predicate<String> fileFilter) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(namespace, "Namespace cannot be null");
        Objects.requireNonNull(pathStart, "Path start cannot be null");
        Objects.requireNonNull(fileFilter, "File filter cannot be null");
        return ImmutableList.of();
    }

    @Override
    public Set<String> namespaces(class_3264 resourceType) {
        Objects.requireNonNull(resourceType, "Resource type cannot be null");
        return ImmutableSet.of((Object)ROOT_NAMESPACE);
    }

    @Override
    public class_2960 locateRootResource(String rootResource) {
        Objects.requireNonNull(rootResource, "Root resource name cannot be null");
        String fileName = rootResource.replaceAll("^pack.png", "icon");
        class_2960 location = new class_2960(ROOT_NAMESPACE, this.ROOT_PATH_PREFIX + fileName);
        this.ROOT_RESOURCES.computeIfAbsent(location, loc -> this.ORIGINAL.method_14410(new String[]{rootResource}));
        return location;
    }
}

