/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.particles.trail;

import it.hurts.octostudios.octolib.modules.particles.OctoRenderManager;
import it.hurts.octostudios.octolib.modules.particles.RenderProvider;
import it.hurts.octostudios.octolib.modules.particles.trail.DefaultTrailBuffer;
import it.hurts.octostudios.octolib.modules.particles.trail.TrailBuffer;
import it.hurts.octostudios.octolib.util.ColorUtils;
import it.hurts.octostudios.octolib.util.TesselatorUtils;
import it.hurts.octostudios.octolib.util.VectorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public interface TrailProvider
extends RenderProvider<TrailProvider, TrailBuffer> {
    @Override
    default public TrailBuffer createBuffer() {
        return new DefaultTrailBuffer(this.getTrailMaxLength());
    }

    @Override
    default public boolean shouldRender(TrailBuffer buffer) {
        return this.isTrailAlive() || !this.disappearAfterDeath() && buffer.size() != 0;
    }

    @Override
    default public class_243 getRenderPosition(float partialTick) {
        return this.getTrailPosition(partialTick);
    }

    public class_243 getTrailPosition(float var1);

    @Override
    @Deprecated
    default public double getRenderDistance() {
        return this.getTrailRenderDistance();
    }

    default public double getTrailRenderDistance() {
        return 64.0;
    }

    @Override
    @Deprecated
    default public int getUpdateFrequency() {
        return this.getTrailUpdateFrequency();
    }

    public int getTrailUpdateFrequency();

    public boolean isTrailAlive();

    default public boolean isTrailGrowing() {
        return true;
    }

    default public boolean disappearAfterDeath() {
        return false;
    }

    public int getTrailMaxLength();

    public int getTrailFadeInColor();

    public int getTrailFadeOutColor();

    public double getTrailScale();

    default public int getTrailInterpolationPoints() {
        return 1;
    }

    default public List<class_243> getTrailRenderPositions(List<class_243> points, float pTicks) {
        if (points.size() < 3) {
            return points;
        }
        ArrayList<class_243> interpolated = new ArrayList<class_243>(List.of(points.get(0)));
        for (int i = 1; i < points.size() - 2; ++i) {
            interpolated.add(points.get(i + 1).method_35590(points.get(i), (double)pTicks));
        }
        return interpolated;
    }

    @Override
    @Deprecated
    default public void render(float pTicks, class_4587 poseStack, class_4597 bufferSourceList) {
        this.renderTrail(pTicks, poseStack, bufferSourceList);
    }

    default public void renderTrail(float pTicks, class_4587 poseStack, class_4597 bufferSourceList) {
        class_638 world = class_310.method_1551().field_1687;
        class_243 matrixTranslation = this.getRenderPosition(pTicks);
        if (world == null) {
            return;
        }
        long time = world.method_8510();
        int segments = this.getTrailMaxLength();
        if (segments <= 0 || this.getTrailUpdateFrequency() <= 0) {
            return;
        }
        ArrayList<class_243> partialPoses = new ArrayList<class_243>();
        float partial = (float)((int)(time % (long)this.getTrailUpdateFrequency())) + pTicks;
        TrailBuffer buffer = (TrailBuffer)OctoRenderManager.getOrCreateBuffer(this);
        List<class_243> points = new ArrayList<class_243>();
        if (this.isTrailAlive()) {
            points.add(new class_243(0.0, 0.0, 0.0));
        }
        for (class_243 vec3 : buffer) {
            points.add(vec3.method_1020(matrixTranslation));
        }
        if ((points = this.getTrailRenderPositions(points, pTicks)).size() > 2) {
            for (int i = 0; i < points.size() - 1; ++i) {
                float p;
                class_243 p0 = i == 0 ? points.get(0) : points.get(i - 1);
                class_243 p1 = points.get(i);
                class_243 p2 = points.get(i + 1);
                class_243 p3 = i == points.size() - 2 ? points.get(points.size() - 1) : points.get(i + 2);
                partialPoses.add(p1);
                for (float f = p = (float)(this.getTrailInterpolationPoints() + 1); f < 1.0f; f += 1.0f / p) {
                    partialPoses.add(VectorUtils.catmullromVec(f, p0, p1, p2, p3));
                }
            }
            partialPoses.add(points.get(points.size() - 1));
        } else {
            partialPoses.addAll(points);
        }
        if (points.size() > 1 && this.getTrailMaxLength() + 1 == points.size()) {
            int i = partialPoses.size() - 1;
            partialPoses.set(i, ((class_243)partialPoses.get(i)).method_1019(((class_243)partialPoses.get(i - 1)).method_1020((class_243)partialPoses.get(i)).method_1021((double)partial / (double)this.getTrailUpdateFrequency() * (double)this.getTrailInterpolationPoints())));
        }
        this.draw3dTrail(partialPoses, poseStack, bufferSourceList);
    }

    default public void draw3dTrail(List<class_243> partialPoses, class_4587 poseStack, class_4597 bufferSourceList) {
        class_243[][] crossVecs = new class_243[partialPoses.size()][3];
        for (int i = 1; i < partialPoses.size(); ++i) {
            class_243 pos1 = partialPoses.get(i - 1);
            class_243 pos2 = partialPoses.get(i);
            class_243 vec1 = pos2.method_1020(pos1);
            class_243 vec1n = vec1.method_1029();
            class_243 notScaled = Math.abs(vec1n.field_1352) + Math.abs(vec1n.field_1350) < 0.05 ? vec1.method_1031(0.05, 0.0, 0.0).method_1036(VectorUtils.Y_VEC) : vec1.method_1036(VectorUtils.Y_VEC);
            double len = 1.0f - (float)(i - 1) / (float)partialPoses.size();
            crossVecs[i - 1][0] = notScaled.method_1029().method_1021(this.getTrailScale() * len);
            class_243 axis = partialPoses.get(i - 1).method_1020(partialPoses.get(i));
            crossVecs[i - 1][1] = VectorUtils.rotate(crossVecs[i - 1][0], axis, 100.0).method_1029().method_1021(crossVecs[i - 1][0].method_1033());
            crossVecs[i - 1][2] = VectorUtils.rotate(crossVecs[i - 1][0], axis, -100.0).method_1029().method_1021(crossVecs[i - 1][0].method_1033());
        }
        Color color1 = new Color(this.getTrailFadeInColor(), true);
        Color color2 = new Color(this.getTrailFadeOutColor(), true);
        poseStack.method_22903();
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        for (int i = 0; i < partialPoses.size() && crossVecs[i][0] != null; ++i) {
            class_243 pos2;
            Color c1 = ColorUtils.blend(color1, color2, (float)i / (float)(partialPoses.size() - 1));
            Color c2 = ColorUtils.blend(color1, color2, ((float)i + 1.0f) / (float)(partialPoses.size() - 1));
            class_243 pos_i = partialPoses.get(i);
            class_243 pos11 = pos_i.method_1019(crossVecs[i][0]);
            class_243 pos12 = pos_i.method_1019(crossVecs[i][1]);
            class_243 pos13 = pos_i.method_1019(crossVecs[i][2]);
            class_4588 tes = bufferSourceList.getBuffer(TesselatorUtils.TRAIL_RENDER_TYPE);
            if (i == 0 && partialPoses.size() > 1) {
                pos2 = pos_i.method_1019(pos_i.method_1020(partialPoses.get(1)).method_1029().method_1021(crossVecs[i][0].method_1033()));
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.field_1352, (float)pos12.field_1351, (float)pos12.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos11.field_1352, (float)pos11.field_1351, (float)pos11.field_1350, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.field_1352, (float)pos13.field_1351, (float)pos13.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos12.field_1352, (float)pos12.field_1351, (float)pos12.field_1350, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.field_1352, (float)pos11.field_1351, (float)pos11.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos13.field_1352, (float)pos13.field_1351, (float)pos13.field_1350, c1, c2);
            }
            if (i == crossVecs.length - 1 || crossVecs[i + 1][0] == null) {
                pos2 = partialPoses.get(i + 1);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.field_1352, (float)pos11.field_1351, (float)pos11.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos12.field_1352, (float)pos12.field_1351, (float)pos12.field_1350, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.field_1352, (float)pos12.field_1351, (float)pos12.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos13.field_1352, (float)pos13.field_1351, (float)pos13.field_1350, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.field_1352, (float)pos13.field_1351, (float)pos13.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, (float)pos11.field_1352, (float)pos11.field_1351, (float)pos11.field_1350, c1, c2);
                continue;
            }
            class_243 pos21 = partialPoses.get(i + 1).method_1019(crossVecs[i + 1][0]);
            class_243 pos22 = partialPoses.get(i + 1).method_1019(crossVecs[i + 1][1]);
            class_243 pos23 = partialPoses.get(i + 1).method_1019(crossVecs[i + 1][2]);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.field_1352, (float)pos11.field_1351, (float)pos11.field_1350, (float)pos21.field_1352, (float)pos21.field_1351, (float)pos21.field_1350, (float)pos22.field_1352, (float)pos22.field_1351, (float)pos22.field_1350, (float)pos12.field_1352, (float)pos12.field_1351, (float)pos12.field_1350, c1, c2);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.field_1352, (float)pos12.field_1351, (float)pos12.field_1350, (float)pos22.field_1352, (float)pos22.field_1351, (float)pos22.field_1350, (float)pos23.field_1352, (float)pos23.field_1351, (float)pos23.field_1350, (float)pos13.field_1352, (float)pos13.field_1351, (float)pos13.field_1350, c1, c2);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.field_1352, (float)pos13.field_1351, (float)pos13.field_1350, (float)pos23.field_1352, (float)pos23.field_1351, (float)pos23.field_1350, (float)pos21.field_1352, (float)pos21.field_1351, (float)pos21.field_1350, (float)pos11.field_1352, (float)pos11.field_1351, (float)pos11.field_1350, c1, c2);
        }
        poseStack.method_22909();
    }
}

