/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.JsonHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class PotionProviderRecipe
implements class_1860<class_8566> {
    private final class_2960 id;
    private final class_2371<class_1856> providers;
    private final List<class_1842> potions;

    public PotionProviderRecipe(class_2960 id, class_2371<class_1856> providers, List<class_1842> potions) {
        this.id = id;
        this.providers = providers;
        this.potions = potions;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return "potion_provider";
    }

    public class_2371<class_1856> method_8117() {
        return this.providers;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean matches(class_8566 inv, class_1937 worldIn) {
        return false;
    }

    public class_1799 assemble(class_8566 wrapper, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Jeed.getPotionProviderSerializer();
    }

    public class_3956<?> method_17716() {
        return Jeed.getPotionProviderType();
    }

    public List<class_1842> getPotions() {
        return this.potions.isEmpty() ? class_7923.field_41179.method_10220().toList() : this.potions;
    }

    public static class Serializer
    implements class_1865<PotionProviderRecipe> {
        public PotionProviderRecipe fromJson(class_2960 recipeId, JsonObject json) {
            List<class_1842> potions;
            class_2371<class_1856> providers = JsonHelper.readIngredients(class_3518.method_15261((JsonObject)json, (String)"providers"));
            try {
                potions = JsonHelper.readPotionList(class_3518.method_15261((JsonObject)json, (String)"potions"));
            }
            catch (Exception ignored) {
                potions = new ArrayList<class_1842>();
            }
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            return new PotionProviderRecipe(recipeId, providers, potions);
        }

        @Nullable
        public PotionProviderRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int i = buffer.method_10816();
            class_2371 providers = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            providers.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            int x = buffer.method_10816();
            ArrayList<class_1842> potions = new ArrayList<class_1842>();
            for (int y = 0; y < x; ++y) {
                potions.add(JsonHelper.getPotion(buffer.method_10810()));
            }
            return new PotionProviderRecipe(recipeId, (class_2371<class_1856>)providers, potions);
        }

        public void toNetwork(class_2540 buffer, PotionProviderRecipe recipe) {
            buffer.method_10804(recipe.providers.size());
            for (class_1856 result : recipe.providers) {
                result.method_8088(buffer);
            }
            buffer.method_10804(recipe.potions.size());
            for (class_1842 potion : recipe.potions) {
                buffer.method_10812(class_7923.field_41179.method_10221((Object)potion));
            }
        }
    }
}

