/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.display;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.HSLColor;
import net.mehvahdjukaar.jeed.plugin.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectBox;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.plugin.jei.display.TabIcon;
import net.mehvahdjukaar.jeed.plugin.jei.ingredient.EffectInstanceRenderer;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1856;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class EffectInfoRecipeCategory
implements IRecipeCategory<EffectInfoRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final IDrawable effectBackground;

    public EffectInfoRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(Constants.RECIPE_WIDTH, Constants.RECIPE_HEIGHT);
        this.effectBackground = new EffectBox();
        this.icon = new TabIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
    }

    public RecipeType<EffectInfoRecipe> getRecipeType() {
        return EffectInfoRecipe.TYPE;
    }

    public class_2561 getTitle() {
        return Constants.LOCALIZED_NAME;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(EffectInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        int size;
        int xPos = 0;
        int yPos = this.effectBackground.getHeight() + 4 + Constants.Y_OFFSET;
        class_327 font = class_310.method_1551().field_1772;
        class_1291 effect = recipe.getEffect().method_5579();
        class_5250 name = (class_5250)effect.method_5560();
        int color = HSLColor.getProcessedColor(effect.method_5556());
        name.method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_27703(class_5251.method_27717((int)color)));
        float x = (float)Constants.RECIPE_WIDTH / 2.0f - (float)font.method_27525((class_5348)name) / 2.0f;
        graphics.method_35720(font, class_2477.method_10517().method_30934((class_5348)name), (int)x, 0, -16777216);
        for (class_5348 descriptionLine : recipe.getDescription()) {
            graphics.method_51430(font, class_2477.method_10517().method_30934(descriptionLine), xPos, yPos, -16777216, false);
            Objects.requireNonNull(font);
            yPos += 9 + Constants.LINE_SPACING;
        }
        if (Jeed.hasIngredientList() && (size = recipe.ingredients.size()) != 0) {
            int maxSlots = size <= Constants.SLOTS_PER_ROW ? Constants.SLOTS_PER_ROW : Constants.SLOTS_PER_ROW * Constants.ROWS;
            for (int slotId = 0; slotId < maxSlots; ++slotId) {
                int slotX = 1 + (int)((float)Constants.RECIPE_WIDTH / 2.0f + (float)Constants.SLOT_W * ((float)(slotId % Constants.SLOTS_PER_ROW) - (float)Constants.SLOTS_PER_ROW / 2.0f));
                this.slotBackground.draw(graphics, slotX, Constants.RECIPE_HEIGHT - Constants.SLOT_W * (1 + slotId / Constants.SLOTS_PER_ROW));
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EffectInfoRecipe recipe, IFocusGroup focuses) {
        IIngredientType<class_1293> type = JEIPlugin.EFFECT_INGREDIENT_TYPE;
        IRecipeSlotBuilder mainSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (Constants.RECIPE_WIDTH - 18) / 2, Constants.Y_OFFSET + 3).setCustomRenderer(type, (IIngredientRenderer)EffectInstanceRenderer.INSTANCE_SLOT).addIngredient(type, (Object)recipe.getEffect());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient(type, (Object)recipe.getEffect());
        if (Jeed.hasEffectBox()) {
            mainSlot.setBackground(this.effectBackground, -3, -3);
        }
        if (Jeed.hasIngredientList()) {
            List<class_1856> slotContents = recipe.slots;
            int rowsCount = slotContents.size() <= Constants.SLOTS_PER_ROW ? 1 : Constants.ROWS;
            for (int slotId = 0; slotId < slotContents.size(); ++slotId) {
                int x = (int)((float)Constants.RECIPE_WIDTH / 2.0f + (float)Constants.ROWS + (float)Constants.SLOT_W * ((float)(slotId % Constants.SLOTS_PER_ROW) - (float)Constants.SLOTS_PER_ROW / 2.0f));
                int y = 1 + Constants.RECIPE_HEIGHT - Constants.SLOT_W * (rowsCount - slotId / Constants.SLOTS_PER_ROW);
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(slotContents.get(slotId));
            }
        }
    }
}

