/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.searchtree;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1123;
import net.minecraft.class_1124;
import org.embeddedt.modernfix.ModernFix;

public class LazySearchTree<T>
implements class_1123<T> {
    private final List<T> contents;
    private final Function<List<T>, class_1123<T>> treeBuilder;
    private volatile class_1123<T> realTree;

    public LazySearchTree(List<T> contents, Function<List<T>, class_1123<T>> treeBuilder) {
        this.contents = contents;
        this.treeBuilder = treeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_1123<T> getRealTree() {
        class_1123<T> t = this.realTree;
        if (t == null) {
            LazySearchTree lazySearchTree = this;
            synchronized (lazySearchTree) {
                t = this.realTree;
                if (t == null) {
                    ModernFix.LOGGER.info("Building search tree for {} items (this may take a while)...", (Object)this.contents.size());
                    Stopwatch s = Stopwatch.createStarted();
                    t = this.treeBuilder.apply(this.contents);
                    t.method_4799();
                    s.stop();
                    ModernFix.LOGGER.info("Building search tree for {} items took {}", (Object)this.contents.size(), (Object)s);
                    this.realTree = t;
                }
            }
        }
        return t;
    }

    public List<T> method_4810(String query) {
        if (query.isEmpty()) {
            return this.contents;
        }
        return this.getRealTree().method_4810(query);
    }

    public void method_4799() {
        class_1123<T> t = this.realTree;
        if (t != null) {
            t.method_4799();
        }
    }

    public static <T> class_1124.class_7456<T> decorate(class_1124.class_7456<T> originalSupplier) {
        return list -> new LazySearchTree(list, originalSupplier);
    }
}

