/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.handler;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.crystalnest.soul_fire_d.Constants;
import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FireResourceReloadListener
extends class_4309 {
    protected static final ArrayList<class_2960> ddfiresUnregister = new ArrayList();
    protected static final ArrayList<class_2960> ddfiresRegister = new ArrayList();
    private static final String SOURCE_FIELD_NAME = "source";
    private static final String CAMPFIRE_FIELD_NAME = "campfire";

    protected FireResourceReloadListener() {
        super(new Gson(), "fires");
    }

    protected static void handle(@Nullable class_3222 player) {
        for (class_2960 fireType : ddfiresUnregister) {
            Services.NETWORK.sendToClient(player, fireType);
        }
        for (class_2960 fireType : ddfiresRegister) {
            Services.NETWORK.sendToClient(player, FireManager.getFire(fireType));
        }
    }

    private static JsonObject getJsonObject(String identifier, JsonElement element) throws IllegalStateException {
        try {
            return element.getAsJsonObject();
        }
        catch (IllegalStateException e) {
            Constants.LOGGER.error("soul_fire_d encountered a non-blocking DDFire error!\nError parsing ddfire [{}]: not a JSON object.", (Object)identifier);
            throw e;
        }
    }

    private static <T> T parse(String identifier, String field, JsonObject data, Function<JsonElement, T> parser) throws NullPointerException, UnsupportedOperationException, IllegalStateException, NumberFormatException {
        try {
            return parser.apply(data.get(field));
        }
        catch (IllegalStateException | NullPointerException | NumberFormatException | UnsupportedOperationException e) {
            Constants.LOGGER.error("soul_fire_d encountered a non-blocking DDFire error!\nError parsing required field \"{}\" for ddfire [{}]: missing or malformed field.", (Object)field, (Object)identifier);
            throw e;
        }
    }

    private static <T> T parse(String identifier, String field, JsonObject data, Function<JsonElement, T> parser, T fallback) throws UnsupportedOperationException, IllegalStateException, NumberFormatException {
        try {
            return parser.apply(data.get(field));
        }
        catch (NullPointerException e) {
            return fallback;
        }
        catch (IllegalStateException | NumberFormatException | UnsupportedOperationException e) {
            Constants.LOGGER.error("soul_fire_d encountered a non-blocking DDFire error!\nError parsing optional field \"{}\" for ddfire [{}]: malformed field.", (Object)field, (Object)identifier);
            throw e;
        }
    }

    private static void unregisterFires() {
        for (class_2960 fireType : ddfiresRegister) {
            if (FireManager.unregisterFire(fireType) == null) continue;
            ddfiresUnregister.add(fireType);
        }
        ddfiresRegister.clear();
    }

    private static void registerFire(class_2960 fireType, Fire fire) {
        if (FireManager.registerFire(fire) != null) {
            ddfiresRegister.add(fireType);
        } else {
            Constants.LOGGER.error("Unable to register ddfire [{}].", (Object)fireType);
        }
    }

    protected void apply(Map<class_2960, JsonElement> fires, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        FireResourceReloadListener.unregisterFires();
        for (Map.Entry<class_2960, JsonElement> fire : fires.entrySet()) {
            String jsonIdentifier = fire.getKey().method_12832();
            try {
                JsonObject jsonData = FireResourceReloadListener.getJsonObject(jsonIdentifier, fire.getValue());
                String mod = FireResourceReloadListener.parse(jsonIdentifier, "mod", jsonData, JsonElement::getAsString);
                if (Services.PLATFORM.isModLoaded(mod)) {
                    JsonArray jsonFires = FireResourceReloadListener.parse(jsonIdentifier, "fires", jsonData, JsonElement::getAsJsonArray);
                    for (JsonElement element : jsonFires) {
                        JsonObject jsonFire = FireResourceReloadListener.getJsonObject(jsonIdentifier, element);
                        class_2960 fireType = new class_2960(mod, FireResourceReloadListener.parse(jsonIdentifier, "fire", jsonFire, JsonElement::getAsString));
                        Fire.Builder builder = FireManager.fireBuilder(fireType).setDamage(FireResourceReloadListener.parse(fireType.toString(), "damage", jsonFire, JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue()).setInvertHealAndHarm(FireResourceReloadListener.parse(fireType.toString(), "invertHealAndHarm", jsonFire, JsonElement::getAsBoolean, false)).removeComponent(Fire.Component.CAMPFIRE_ITEM).removeComponent(Fire.Component.LANTERN_BLOCK).removeComponent(Fire.Component.LANTERN_ITEM).removeComponent(Fire.Component.TORCH_BLOCK).removeComponent(Fire.Component.TORCH_ITEM).removeComponent(Fire.Component.WALL_TORCH_BLOCK).removeComponent(Fire.Component.FLAME_PARTICLE);
                        if (jsonFire.get(SOURCE_FIELD_NAME) != null && jsonFire.get(SOURCE_FIELD_NAME).isJsonNull()) {
                            builder.removeComponent(Fire.Component.SOURCE_BLOCK);
                        } else {
                            String source = FireResourceReloadListener.parse(fireType.toString(), SOURCE_FIELD_NAME, jsonFire, JsonElement::getAsString, null);
                            if (source != null && class_2960.method_20207((String)source)) {
                                builder.setComponent(Fire.Component.SOURCE_BLOCK, new class_2960(source));
                            }
                        }
                        if (jsonFire.get(CAMPFIRE_FIELD_NAME) != null && jsonFire.get(CAMPFIRE_FIELD_NAME).isJsonNull()) {
                            builder.removeComponent(Fire.Component.CAMPFIRE_BLOCK);
                        } else {
                            String campfire = FireResourceReloadListener.parse(fireType.toString(), CAMPFIRE_FIELD_NAME, jsonFire, JsonElement::getAsString, null);
                            if (campfire != null && class_2960.method_20207((String)campfire)) {
                                builder.setComponent(Fire.Component.CAMPFIRE_BLOCK, new class_2960(campfire));
                            }
                        }
                        builder.removeFireAspect();
                        builder.removeFlame();
                        FireResourceReloadListener.registerFire(fireType, builder.build());
                    }
                    continue;
                }
                Constants.LOGGER.warn("Registering of ddfires for [{}] is canceled: {} is not loaded.", (Object)mod, (Object)mod);
            }
            catch (IllegalStateException | NullPointerException | NumberFormatException | UnsupportedOperationException e) {
                Constants.LOGGER.error("Registering of ddfires for [{}] is canceled.", (Object)jsonIdentifier);
            }
        }
    }
}

