/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.enchantment;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import java.util.List;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;

public final class FireEnchantmentHelper {
    private FireEnchantmentHelper() {
    }

    public static int getBaseFireAspect(class_1309 entity) {
        return FireEnchantmentHelper.getFireEquipmentLevel(class_1893.field_9124, entity);
    }

    public static int getBaseFireAspect(class_1799 stack) {
        return FireEnchantmentHelper.getFireLevel(class_1893.field_9124, stack);
    }

    public static int getAnyFireAspect(class_1309 entity) {
        return FireEnchantmentHelper.getWhichFireAspect(entity).getLevel();
    }

    public static int getAnyFireAspect(class_1799 stack) {
        return FireEnchantmentHelper.getWhichFireAspect(stack).getLevel();
    }

    public static FireEnchantment getWhichFireAspect(class_1309 entity) {
        return FireEnchantmentHelper.getAnyFireEnchantment(entity, FireManager.getComponentList(Fire.Component.FIRE_ASPECT_ENCHANTMENT), FireEnchantmentHelper::getBaseFireAspect, class_1890::method_8203);
    }

    public static FireEnchantment getWhichFireAspect(class_1799 stack) {
        return FireEnchantmentHelper.getAnyFireEnchantment(stack, FireManager.getComponentList(Fire.Component.FIRE_ASPECT_ENCHANTMENT), FireEnchantmentHelper::getBaseFireAspect, class_1890::method_8225);
    }

    public static int getBaseFlame(class_1309 entity) {
        return FireEnchantmentHelper.getFireEquipmentLevel(class_1893.field_9126, entity);
    }

    public static int getBaseFlame(class_1799 stack) {
        return FireEnchantmentHelper.getFireLevel(class_1893.field_9126, stack);
    }

    public static int getAnyFlame(class_1309 entity) {
        return FireEnchantmentHelper.getWhichFlame(entity).getLevel();
    }

    public static int getAnyFlame(class_1799 stack) {
        return FireEnchantmentHelper.getWhichFlame(stack).getLevel();
    }

    public static FireEnchantment getWhichFlame(class_1309 entity) {
        return FireEnchantmentHelper.getAnyFireEnchantment(entity, FireManager.getComponentList(Fire.Component.FLAME_ENCHANTMENT), FireEnchantmentHelper::getBaseFlame, class_1890::method_8203);
    }

    public static FireEnchantment getWhichFlame(class_1799 stack) {
        return FireEnchantmentHelper.getAnyFireEnchantment(stack, FireManager.getComponentList(Fire.Component.FLAME_ENCHANTMENT), FireEnchantmentHelper::getBaseFlame, class_1890::method_8225);
    }

    private static <T> FireEnchantment getAnyFireEnchantment(T enchanted, List<? extends class_1887> enchantments, ToIntFunction<T> getBaseFireEnchantment, ToIntBiFunction<class_1887, T> getLevel) {
        int fireEnchantmentLevel = getBaseFireEnchantment.applyAsInt(enchanted);
        class_2960 fireType = FireManager.DEFAULT_FIRE_TYPE;
        if (fireEnchantmentLevel <= 0) {
            for (class_1887 class_18872 : enchantments) {
                int enchantmentLevel = getLevel.applyAsInt(class_18872, (class_1887)enchanted);
                if (enchantmentLevel <= 0) continue;
                fireEnchantmentLevel = enchantmentLevel;
                fireType = ((FireTyped)class_18872).getFireType();
                break;
            }
        }
        return new FireEnchantment(fireEnchantmentLevel, (class_2960)(fireEnchantmentLevel > 0 ? fireType : null));
    }

    private static int getFireEquipmentLevel(class_1887 enchantment, class_1309 entity) {
        int i = 0;
        for (class_1799 stack : enchantment.method_8185(entity).values()) {
            int j = class_1890.method_8225((class_1887)enchantment, (class_1799)stack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    private static int getFireLevel(class_1887 enchantment, class_1799 stack) {
        if (!stack.method_7960()) {
            class_2960 idToFind = class_1890.method_37423((class_1887)enchantment);
            class_2499 tags = stack.method_7921();
            for (int i = 0; i < tags.size(); ++i) {
                class_2487 tag = tags.method_10602(i);
                class_2960 enchantmentId = class_1890.method_37427((class_2487)tag);
                if (enchantmentId == null || !enchantmentId.equals((Object)idToFind)) continue;
                return class_1890.method_37424((class_2487)tag);
            }
        }
        return 0;
    }

    public static class FireEnchantment {
        private final int level;
        private final class_2960 fireType;
        private final boolean applied;

        FireEnchantment(int level, class_2960 fireType) {
            this.level = level;
            this.fireType = fireType;
            this.applied = level > 0 && (FireManager.DEFAULT_FIRE_TYPE.equals((Object)fireType) || FireManager.isRegisteredType(fireType));
        }

        public int getLevel() {
            return this.level;
        }

        public class_2960 getFireType() {
            return this.fireType;
        }

        public boolean isApplied() {
            return this.applied;
        }
    }
}

