/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api;

import com.google.common.base.Suppliers;
import it.crystalnest.cobweb.api.pack.DynamicDataPack;
import it.crystalnest.cobweb.api.pack.DynamicTagBuilder;
import it.crystalnest.cobweb.api.registry.CobwebRegister;
import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import it.crystalnest.soul_fire_d.Constants;
import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.block.CustomCampfireBlock;
import it.crystalnest.soul_fire_d.api.block.CustomFireBlock;
import it.crystalnest.soul_fire_d.api.block.CustomLanternBlock;
import it.crystalnest.soul_fire_d.api.block.CustomTorchBlock;
import it.crystalnest.soul_fire_d.api.block.CustomWallTorchBlock;
import it.crystalnest.soul_fire_d.api.block.entity.CustomCampfireBlockEntity;
import it.crystalnest.soul_fire_d.api.block.entity.DynamicBlockEntityType;
import it.crystalnest.soul_fire_d.api.type.FireTypeChanger;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1827;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FireManager {
    public static final String FIRE_TYPE_TAG = "FireType";
    public static final class_2960 DEFAULT_FIRE_TYPE = new class_2960("");
    public static final class_2960 SOUL_FIRE_TYPE = new class_2960("soul");
    public static final Fire DEFAULT_FIRE = new Fire(DEFAULT_FIRE_TYPE, 15, 1.0f, false, true, Fire.Builder.DEFAULT_IN_FIRE_GETTER, Fire.Builder.DEFAULT_ON_FIRE_GETTER, Fire.Builder.DEFAULT_BEHAVIOR, Map.ofEntries(Map.entry(Fire.Component.SOURCE_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_10036)), Map.entry(Fire.Component.CAMPFIRE_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_17350)), Map.entry(Fire.Component.LANTERN_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_16541)), Map.entry(Fire.Component.TORCH_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_10336)), Map.entry(Fire.Component.WALL_TORCH_BLOCK, class_7923.field_41175.method_10221((Object)class_2246.field_10099)), Map.entry(Fire.Component.FLAME_PARTICLE, class_7923.field_41180.method_10221((Object)class_2398.field_11240)), Map.entry(Fire.Component.FIRE_ASPECT_ENCHANTMENT, class_7923.field_41176.method_10221((Object)class_1893.field_9124)), Map.entry(Fire.Component.FLAME_ENCHANTMENT, class_7923.field_41176.method_10221((Object)class_1893.field_9126))));
    public static final Supplier<DynamicBlockEntityType<CustomCampfireBlockEntity>> CUSTOM_CAMPFIRE_ENTITY_TYPE = CobwebRegistry.of((class_5321)class_7924.field_41255, (String)"soul_fire_d").register("custom_campfire", () -> new DynamicBlockEntityType(CustomCampfireBlockEntity::new));
    private static final DynamicDataPack FIRE_SOURCE_TAGS = DynamicDataPack.named((class_2960)new class_2960("soul_fire_d", "fire_source_tags"));
    private static final DynamicDataPack CAMPFIRE_TAGS = DynamicDataPack.named((class_2960)new class_2960("soul_fire_d", "campfire_tags"));
    private static final ConcurrentHashMap<class_2960, Fire> FIRES = new ConcurrentHashMap();

    private FireManager() {
    }

    public static Fire.Builder fireBuilder(String modId, String fireId) {
        return new Fire.Builder(modId, fireId);
    }

    public static Fire.Builder fireBuilder(class_2960 fireType) {
        return new Fire.Builder(fireType);
    }

    @Nullable
    public static synchronized Fire registerFire(Fire fire) {
        Fire previous = FIRES.computeIfAbsent(fire.getFireType(), key -> {
            Fire.Component.SOURCE_BLOCK.getOptionalValue(fire).ifPresent(block -> ((FireTypeChanger)block).setFireType((class_2960)key));
            Fire.Component.CAMPFIRE_BLOCK.getOptionalValue(fire).ifPresent(block -> ((FireTypeChanger)block).setFireType((class_2960)key));
            return fire;
        });
        if (previous != fire) {
            class_2960 fireType = fire.getFireType();
            Constants.LOGGER.error("Fire [{}] was already registered with the following value: {}", (Object)fireType, (Object)FireManager.getFire(fireType));
            return null;
        }
        return fire;
    }

    public static synchronized Map<class_2960, @Nullable Fire> registerFires(Fire ... fires) {
        return FireManager.registerFires(List.of(fires));
    }

    public static synchronized Map<class_2960, @Nullable Fire> registerFires(List<Fire> fires) {
        HashMap<class_2960, @Nullable Fire> outcomes = new HashMap<class_2960, Fire>();
        for (Fire fire : fires) {
            outcomes.put(fire.getFireType(), FireManager.registerFire(fire));
        }
        return outcomes;
    }

    @Nullable
    @ApiStatus.Internal
    public static synchronized Fire unregisterFire(class_2960 fireType) {
        return FIRES.remove(fireType);
    }

    public static Supplier<CustomFireBlock> registerFireSource(class_2960 fireType, class_6862<class_2248> base, class_3620 color) {
        return FireManager.registerFireSource(fireType, type -> new CustomFireBlock((class_2960)type, base, color));
    }

    public static Supplier<CustomFireBlock> registerFireSource(class_2960 fireType, class_6862<class_2248> base, class_4970.class_2251 properties) {
        return FireManager.registerFireSource(fireType, type -> new CustomFireBlock((class_2960)type, base, properties));
    }

    public static <T extends CustomFireBlock> Supplier<T> registerFireSource(class_2960 fireType, Function<class_2960, T> supplier) {
        com.google.common.base.Supplier source = Suppliers.memoize(() -> (CustomFireBlock)supplier.apply(fireType));
        FIRE_SOURCE_TAGS.add(new Supplier[]{() -> FireManager.lambda$registerFireSource$7((Supplier)source)});
        return CobwebRegistry.ofBlocks((String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.SOURCE_BLOCK), (Supplier)source);
    }

    public static Supplier<CustomCampfireBlock> registerCampfire(class_2960 fireType, boolean spawnParticles) {
        return FireManager.registerCampfire(fireType, type -> new CustomCampfireBlock((class_2960)type, spawnParticles));
    }

    public static Supplier<CustomCampfireBlock> registerCampfire(class_2960 fireType, boolean spawnParticles, class_4970.class_2251 properties) {
        return FireManager.registerCampfire(fireType, type -> new CustomCampfireBlock((class_2960)type, spawnParticles, properties));
    }

    public static <T extends CustomCampfireBlock> Supplier<T> registerCampfire(class_2960 fireType, Function<class_2960, T> supplier) {
        com.google.common.base.Supplier campfire = Suppliers.memoize(() -> (CustomCampfireBlock)supplier.apply(fireType));
        CAMPFIRE_TAGS.add(new Supplier[]{() -> FireManager.lambda$registerCampfire$11((Supplier)campfire)});
        return CobwebRegistry.ofBlocks((String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_BLOCK), (Supplier)campfire);
    }

    public static Supplier<class_1747> registerCampfireItem(class_2960 fireType) {
        return FireManager.registerCampfireItem(fireType, campfire -> new class_1747(campfire, new class_1792.class_1793()));
    }

    public static <T extends class_1747> Supplier<T> registerCampfireItem(class_2960 fireType, Function<class_2248, T> supplier) {
        return CobwebRegistry.ofItems((String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.CAMPFIRE_ITEM), () -> (class_1747)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.CAMPFIRE_BLOCK)));
    }

    public static Supplier<class_2400> registerParticle(class_2960 fireType) {
        return FireManager.registerParticle(fireType, () -> new class_2400(false));
    }

    public static <T extends class_2396<?>> Supplier<T> registerParticle(class_2960 fireType, Supplier<T> supplier) {
        return CobwebRegistry.of((class_5321)class_7924.field_41210, (String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.FLAME_PARTICLE), supplier);
    }

    public static Pair<Supplier<CustomTorchBlock>, Supplier<CustomWallTorchBlock>> registerTorch(class_2960 fireType) {
        return FireManager.registerTorch(fireType, CustomTorchBlock::new, CustomWallTorchBlock::new);
    }

    public static <T extends CustomTorchBlock, W extends CustomWallTorchBlock> Pair<Supplier<T>, Supplier<W>> registerTorch(class_2960 fireType, BiFunction<class_2960, Supplier<? extends class_2394>, T> torchSupplier, BiFunction<class_2960, Supplier<? extends class_2394>, W> wallTorchSupplier) {
        CobwebRegister blocks = CobwebRegistry.ofBlocks((String)fireType.method_12836());
        return Pair.of((Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_BLOCK), () -> (CustomTorchBlock)torchSupplier.apply(fireType, () -> (class_2394)FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE))), (Object)blocks.register(FireManager.getComponentPath(fireType, Fire.Component.WALL_TORCH_BLOCK), () -> (CustomWallTorchBlock)wallTorchSupplier.apply(fireType, () -> (class_2394)FireManager.getRequiredComponent(fireType, Fire.Component.FLAME_PARTICLE))));
    }

    public static Supplier<class_1827> registerTorchItem(class_2960 fireType) {
        return FireManager.registerTorchItem(fireType, (torch, wallTorch) -> new class_1827(torch, wallTorch, new class_1792.class_1793(), class_2350.field_11033));
    }

    public static <T extends class_1827> Supplier<T> registerTorchItem(class_2960 fireType, BiFunction<class_2248, class_2248, T> supplier) {
        return CobwebRegistry.ofItems((String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.TORCH_ITEM), () -> (class_1827)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK), FireManager.getRequiredComponent(fireType, Fire.Component.WALL_TORCH_BLOCK)));
    }

    public static Supplier<CustomLanternBlock> registerLantern(class_2960 fireType) {
        return FireManager.registerLantern(fireType, CustomLanternBlock::new);
    }

    public static <T extends CustomLanternBlock> Supplier<T> registerLantern(class_2960 fireType, Function<class_2960, T> supplier) {
        return CobwebRegistry.ofBlocks((String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_BLOCK), () -> (CustomLanternBlock)supplier.apply(fireType));
    }

    public static Supplier<class_1747> registerLanternItem(class_2960 fireType) {
        return FireManager.registerLanternItem(fireType, lantern -> new class_1747(lantern, new class_1792.class_1793()));
    }

    public static <T extends class_1747> Supplier<T> registerLanternItem(class_2960 fireType, Function<class_2248, T> supplier) {
        return CobwebRegistry.ofItems((String)fireType.method_12836()).register(FireManager.getComponentPath(fireType, Fire.Component.LANTERN_ITEM), () -> (class_1747)supplier.apply(FireManager.getRequiredComponent(fireType, Fire.Component.LANTERN_BLOCK)));
    }

    public static Fire getFire(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) ? FireManager.getFire(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE;
    }

    public static Fire getFire(@Nullable class_2960 fireType) {
        return FIRES.getOrDefault(FireManager.ensure(fireType), DEFAULT_FIRE);
    }

    public static List<Fire> getFires() {
        return FIRES.values().stream().toList();
    }

    public static <T> T getProperty(class_2960 fireType, Function<Fire, T> getter) {
        return getter.apply(FireManager.getFire(fireType));
    }

    @Nullable
    public static class_2960 getComponentId(class_2960 fireType, Fire.Component<?, ?> component) {
        return FireManager.getFire(fireType).getComponent(component);
    }

    @Nullable
    public static <R, T extends R> T getComponent(class_2960 fireType, Fire.Component<R, T> component) {
        return component.getValue(FireManager.getComponentId(fireType, component));
    }

    @NotNull
    private static String getComponentPath(class_2960 fireType, Fire.Component<?, ?> component) {
        return Objects.requireNonNull(FireManager.getComponentId(fireType, component)).method_12832();
    }

    @NotNull
    public static <R, T extends R> T getRequiredComponent(class_2960 fireType, Fire.Component<R, T> component) throws NullPointerException {
        return Objects.requireNonNull(component.getValue(FireManager.getComponentId(fireType, component)));
    }

    public static <T> List<T> getPropertyList(Function<Fire, T> getter) {
        return FIRES.values().stream().map(getter).toList();
    }

    public static List<class_2960> getComponentIdList(Fire.Component<?, ?> component) {
        return FIRES.values().stream().map(fire -> fire.getComponent(component)).filter(Objects::nonNull).toList();
    }

    public static <R, T extends R> List<T> getComponentList(Fire.Component<R, T> component) {
        return FIRES.values().stream().map(component::getValue).filter(Objects::nonNull).toList();
    }

    public static boolean isValidType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId);
    }

    public static boolean isValidType(@Nullable class_2960 fireType) {
        return fireType != null && Strings.isNotBlank((String)fireType.method_12836()) && Strings.isNotBlank((String)fireType.method_12832());
    }

    public static boolean isRegisteredType(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidFireId(fireId) && FireManager.isRegisteredType(FireManager.fireType(modId, fireId));
    }

    public static boolean isRegisteredType(@Nullable class_2960 fireType) {
        return fireType != null && FIRES.containsKey(fireType);
    }

    public static boolean isValidFireId(@Nullable String fireId) {
        return Strings.isNotBlank((String)fireId) && class_2960.method_20208((String)fireId);
    }

    public static boolean isRegisteredFireId(@Nullable String fireId) {
        return FireManager.isValidFireId(fireId) && FIRES.keySet().stream().anyMatch(fireType -> fireType.method_12832().equals(fireId));
    }

    public static boolean isValidModId(@Nullable String modId) {
        return Strings.isNotBlank((String)modId) && class_2960.method_20209((String)modId);
    }

    public static boolean isRegisteredModId(@Nullable String modId) {
        return FireManager.isValidModId(modId) && FIRES.keySet().stream().anyMatch(fireType -> fireType.method_12836().equals(modId));
    }

    public static class_2960 sanitize(@Nullable String modId, @Nullable String fireId) {
        return FireManager.isValidModId(modId) && FireManager.isValidModId(fireId) ? FireManager.sanitize(FireManager.fireType(modId, fireId)) : DEFAULT_FIRE_TYPE;
    }

    public static class_2960 sanitize(@Nullable class_2960 fireType) {
        return FireManager.isValidType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static class_2960 ensure(@Nullable String modId, @Nullable String fireId) {
        String trimmedModId = modId == null ? "" : modId.trim();
        String trimmedFireId = fireId == null ? "" : fireId.trim();
        return FireManager.isValidModId(trimmedModId) && FireManager.isValidFireId(trimmedFireId) ? FireManager.ensure(new class_2960(trimmedModId, trimmedFireId)) : DEFAULT_FIRE_TYPE;
    }

    public static class_2960 ensure(@Nullable class_2960 fireType) {
        return FireManager.isRegisteredType(fireType) ? fireType : DEFAULT_FIRE_TYPE;
    }

    public static List<class_2960> getFireTypes() {
        return FIRES.keySet().stream().toList();
    }

    public static List<String> getFireIds() {
        return FIRES.keySet().stream().map(class_2960::method_12832).toList();
    }

    public static List<String> getModIds() {
        return FIRES.keySet().stream().map(class_2960::method_12836).toList();
    }

    public static class_1282 getInFireDamageSourceFor(class_1297 entity, class_2960 fireType) {
        return FireManager.getFire(fireType).getInFire(entity);
    }

    public static class_1282 getOnFireDamageSourceFor(class_1297 entity, class_2960 fireType) {
        return FireManager.getFire(fireType).getOnFire(entity);
    }

    public static void setOnFire(class_1297 entity, int seconds, class_2960 fireType) {
        FireManager.setOnFire(entity, seconds, fireType, class_1297::method_5639);
    }

    @ApiStatus.Internal
    public static void setOnFire(class_1297 entity, int seconds, class_2960 fireType, BiConsumer<class_1297, Integer> setOnFireFunction) {
        setOnFireFunction.accept(entity, seconds);
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
    }

    public static boolean damageInFire(class_1297 entity, class_2960 fireType) {
        return FireManager.damageInFire(entity, fireType, (TriFunction<class_1297, class_1282, Float, Boolean>)((TriFunction)class_1297::method_5643));
    }

    @ApiStatus.Internal
    public static boolean damageInFire(class_1297 entity, class_2960 fireType, TriFunction<class_1297, class_1282, Float, Boolean> hurtFunction) {
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
        return FireManager.harmOrHeal(entity, FireManager.getInFireDamageSourceFor(entity, fireType), FireManager.getProperty(fireType, Fire::getDamage).floatValue(), FireManager.getProperty(fireType, Fire::invertHealAndHarm), hurtFunction);
    }

    public static boolean damageOnFire(class_1297 entity, class_2960 fireType) {
        return FireManager.damageOnFire(entity, fireType, (TriFunction<class_1297, class_1282, Float, Boolean>)((TriFunction)class_1297::method_5643));
    }

    @ApiStatus.Internal
    public static boolean damageOnFire(class_1297 entity, class_2960 fireType, TriFunction<class_1297, class_1282, Float, Boolean> hurtFunction) {
        ((FireTypeChanger)entity).setFireType(FireManager.ensure(fireType));
        return FireManager.harmOrHeal(entity, FireManager.getOnFireDamageSourceFor(entity, fireType), FireManager.getProperty(fireType, Fire::getDamage).floatValue(), FireManager.getProperty(fireType, Fire::invertHealAndHarm), hurtFunction);
    }

    private static boolean harmOrHeal(class_1297 entity, class_1282 damageSource, float damage, boolean invertHealAndHarm, TriFunction<class_1297, class_1282, Float, Boolean> hurtFunction) {
        Predicate behavior = FireManager.getProperty(((FireTyped)entity).getFireType(), Fire::getBehavior);
        if (behavior.test(entity) && Float.compare(damage, 0.0f) != 0) {
            if (damage > 0.0f) {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    if (livingEntity.method_5999() && invertHealAndHarm) {
                        livingEntity.method_6025(damage);
                        return false;
                    }
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(damage));
                }
                return (Boolean)hurtFunction.apply((Object)entity, (Object)damageSource, (Object)Float.valueOf(damage));
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (livingEntity.method_5999() && invertHealAndHarm) {
                    return (Boolean)hurtFunction.apply((Object)livingEntity, (Object)damageSource, (Object)Float.valueOf(-damage));
                }
                livingEntity.method_6025(-damage);
                return false;
            }
        }
        return false;
    }

    public static void writeTag(class_2487 tag, @Nullable class_2960 fireType) {
        tag.method_10582(FIRE_TYPE_TAG, FireManager.ensure(fireType).toString());
    }

    public static class_2960 readTag(class_2487 tag) {
        return FireManager.ensure(class_2960.method_12829((String)tag.method_10558(FIRE_TYPE_TAG)));
    }

    private static class_2960 fireType(@Nullable String modId, @Nullable String fireId) {
        return new class_2960(Objects.requireNonNull(modId), Objects.requireNonNull(fireId));
    }

    private static /* synthetic */ DynamicTagBuilder lambda$registerCampfire$11(Supplier campfire) {
        return DynamicTagBuilder.of((class_5321)class_7924.field_41254, (class_6862[])new class_6862[]{class_3481.field_23799}).addElement((Object)((class_2248)campfire.get()));
    }

    private static /* synthetic */ DynamicTagBuilder lambda$registerFireSource$7(Supplier source) {
        return DynamicTagBuilder.of((class_5321)class_7924.field_41254, (class_6862[])new class_6862[]{class_3481.field_21952}).addElement((Object)((class_2248)source.get()));
    }

    static {
        FIRE_SOURCE_TAGS.register();
        CAMPFIRE_TAGS.register();
    }
}

