/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.emissiveplugin.fabric.model;

import io.github.moremcmeta.emissiveplugin.ModConstants;
import io.github.moremcmeta.emissiveplugin.metadata.OverlayMetadata;
import io.github.moremcmeta.emissiveplugin.metadata.TransparencyMode;
import io.github.moremcmeta.emissiveplugin.model.OverlayQuadFunction;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public final class OverlayBakedModel
extends ForwardingBakedModel {
    private static final Renderer RENDERER = RendererAccess.INSTANCE.getRenderer();
    private static final int BLEND_MODES = BlendMode.values().length;
    private static final RenderMaterial[] EMISSIVE_MATERIAL = new RenderMaterial[BLEND_MODES];
    private static final RenderMaterial[] NON_EMISSIVE_MATERIAL = new RenderMaterial[BLEND_MODES];
    private final class_1092 MODEL_MANAGER = class_310.method_1551().method_1554();

    public OverlayBakedModel(class_1087 model) {
        this.wrapped = Objects.requireNonNull(model, "Baked model cannot be null");
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        if (!RendererAccess.INSTANCE.hasRenderer()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        MeshBuilder builder = RENDERER.meshBuilder();
        OverlayQuadTransform transform = new OverlayQuadTransform(builder.getEmitter(), this.MODEL_MANAGER.method_24153(class_1059.field_5275), state);
        context.pushTransform((RenderContext.QuadTransform)transform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        if (transform.emittedAny()) {
            context.meshConsumer().accept(builder.build());
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        if (!RendererAccess.INSTANCE.hasRenderer()) {
            super.emitItemQuads(stack, randomSupplier, context);
            return;
        }
        MeshBuilder builder = RENDERER.meshBuilder();
        OverlayQuadTransform transform = new OverlayQuadTransform(builder.getEmitter(), this.MODEL_MANAGER.method_24153(class_1059.field_5275), null);
        context.pushTransform((RenderContext.QuadTransform)transform);
        super.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
        if (transform.emittedAny()) {
            context.meshConsumer().accept(builder.build());
        }
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    static {
        if (RendererAccess.INSTANCE.hasRenderer()) {
            for (int modeOrdinal = 0; modeOrdinal < BLEND_MODES; ++modeOrdinal) {
                BlendMode mode = BlendMode.values()[modeOrdinal];
                OverlayBakedModel.EMISSIVE_MATERIAL[modeOrdinal] = RENDERER.materialFinder().blendMode(mode).emissive(true).ambientOcclusion(TriState.FALSE).disableDiffuse(true).find();
                OverlayBakedModel.NON_EMISSIVE_MATERIAL[modeOrdinal] = RENDERER.materialFinder().blendMode(mode).find();
            }
        } else {
            LogManager.getLogger().warn("No renderer is present. Overlays will not be rendered.");
        }
    }

    private static class OverlayQuadTransform
    implements RenderContext.QuadTransform {
        private static final int VERTS_PER_QUAD = 4;
        private final QuadEmitter EMITTER;
        private final class_1059 BLOCK_ATLAS;
        private class_2680 blockState;
        private boolean isDefaultSolid;
        private boolean emittedAny;

        public OverlayQuadTransform(QuadEmitter emitter, class_1059 blockAtlas, @Nullable class_2680 blockState) {
            this.EMITTER = emitter;
            this.BLOCK_ATLAS = blockAtlas;
            this.blockState = blockState;
        }

        public boolean transform(MutableQuadView quad) {
            BlendMode blendMode;
            class_1058 baseSprite = this.spriteFromQuad((QuadView)quad);
            Optional<OverlayMetadata> metadataOptional = MetadataRegistry.INSTANCE.metadataFromSpriteName("moremcmeta_emissive_plugin", baseSprite.method_45851().method_45816()).map(metadata -> (OverlayMetadata)metadata);
            if (metadataOptional.isEmpty()) {
                return true;
            }
            this.EMITTER.copyFrom((QuadView)quad);
            OverlayMetadata metadata2 = metadataOptional.get();
            if (metadata2.transparencyMode() == TransparencyMode.TRANSLUCENT) {
                blendMode = BlendMode.TRANSLUCENT;
            } else {
                blendMode = quad.material().blendMode();
                if (this.blockState != null && blendMode == BlendMode.DEFAULT) {
                    this.isDefaultSolid = class_4696.method_23679((class_2680)this.blockState).equals(class_1921.method_23577());
                    this.blockState = null;
                }
                if (this.isDefaultSolid || blendMode == BlendMode.SOLID) {
                    blendMode = BlendMode.CUTOUT_MIPPED;
                }
            }
            this.EMITTER.material((metadata2.isEmissive() ? EMISSIVE_MATERIAL : NON_EMISSIVE_MATERIAL)[blendMode.ordinal()]);
            int facing = quad.lightFace().ordinal();
            class_1058 overlaySprite = this.BLOCK_ATLAS.method_4608(metadata2.overlaySpriteName());
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                float x = this.EMITTER.x(vertexIndex);
                float y = this.EMITTER.y(vertexIndex);
                float z = this.EMITTER.z(vertexIndex);
                this.EMITTER.pos(vertexIndex, x + ModConstants.X_OFFSETS[facing], y + ModConstants.Y_OFFSETS[facing], z + ModConstants.Z_OFFSETS[facing]);
                this.EMITTER.uv(vertexIndex, OverlayQuadFunction.recomputeSpriteCoordinate(this.EMITTER.u(vertexIndex), baseSprite, overlaySprite, class_1058::method_4594, class_1058::method_4577), OverlayQuadFunction.recomputeSpriteCoordinate(this.EMITTER.v(vertexIndex), baseSprite, overlaySprite, class_1058::method_4593, class_1058::method_4575));
            }
            this.EMITTER.emit();
            this.emittedAny = true;
            return true;
        }

        public boolean emittedAny() {
            return this.emittedAny;
        }

        private class_1058 spriteFromQuad(QuadView quad) {
            return SpriteFinder.get((class_1059)this.BLOCK_ATLAS).find(quad);
        }
    }
}

