/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.event;

import com.google.common.collect.Multimap;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.event.IEventHelper;
import net.darkhax.bookshelf.api.event.block.IFarmlandTrampleListener;
import net.darkhax.bookshelf.api.event.client.IRecipeSyncEvent;
import net.darkhax.bookshelf.api.event.entity.IItemUseTickEvent;
import net.darkhax.bookshelf.api.event.entity.player.IPlayerWakeUpEvent;
import net.darkhax.bookshelf.api.event.item.IItemAttributeEvent;
import net.darkhax.bookshelf.api.event.item.IItemTooltipEvent;
import net.darkhax.bookshelf.impl.event.FabricBookshelfEvents;
import net.darkhax.bookshelf.impl.event.FabricItemAttributeEvent;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class EventHelperFabric
implements IEventHelper {
    public static final class_2960 PHASE_BEFORE = new class_2960("bookshelf", "before");
    public static final class_2960 PHASE_AFTER = new class_2960("bookshelf", "after");

    @Override
    public void addItemTooltipListener(IItemTooltipEvent listener, IEventHelper.Ordering ordering) {
        if (Services.PLATFORM.isPhysicalClient()) {
            ItemTooltipCallback.EVENT.register(EventHelperFabric.getPhase(ordering), (s, f, l) -> listener.apply(s, l, f));
        }
    }

    @Override
    public void addPlayerWakeUpListener(IPlayerWakeUpEvent listener, IEventHelper.Ordering ordering) {
        EntitySleepEvents.STOP_SLEEPING.register(EventHelperFabric.getPhase(ordering), (entity, pos) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                listener.apply(player);
            }
        });
    }

    @Override
    public void addRecipeSyncListener(IRecipeSyncEvent listener, IEventHelper.Ordering ordering) {
        if (Services.PLATFORM.isPhysicalClient()) {
            FabricBookshelfEvents.RECIPE_SYNC.register(EventHelperFabric.getPhase(ordering), (Object)listener);
        }
    }

    @Override
    public void addFarmlandTrampleListener(IFarmlandTrampleListener listener, IEventHelper.Ordering ordering) {
        FabricBookshelfEvents.FARMLAND_TRAMPLE_EVENT.register(EventHelperFabric.getPhase(ordering), (Object)listener);
    }

    @Override
    public void addItemAttributeListener(IItemAttributeEvent.Listener listener, IEventHelper.Ordering ordering) {
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, modifiers) -> listener.accept(new FabricItemAttributeEvent(stack, slot, (Multimap<class_1320, class_1322>)modifiers)));
    }

    @Override
    public void addItemUseTickListener(IItemUseTickEvent listener, IEventHelper.Ordering ordering) {
        FabricBookshelfEvents.ITEM_USE_TICK_EVENT.register(EventHelperFabric.getPhase(ordering), (Object)listener);
    }

    private static class_2960 getPhase(IEventHelper.Ordering ordering) {
        return switch (ordering) {
            case IEventHelper.Ordering.BEFORE -> PHASE_BEFORE;
            case IEventHelper.Ordering.DEFAULT -> Event.DEFAULT_PHASE;
            case IEventHelper.Ordering.AFTER -> PHASE_AFTER;
            default -> Event.DEFAULT_PHASE;
        };
    }

    private static void setup(Event<?> event) {
        event.addPhaseOrdering(PHASE_BEFORE, Event.DEFAULT_PHASE);
        event.addPhaseOrdering(Event.DEFAULT_PHASE, PHASE_AFTER);
    }

    static {
        EventHelperFabric.setup(EntitySleepEvents.STOP_SLEEPING);
        EventHelperFabric.setup(FabricBookshelfEvents.RECIPE_SYNC);
        EventHelperFabric.setup(FabricBookshelfEvents.FARMLAND_TRAMPLE_EVENT);
        EventHelperFabric.setup(FabricBookshelfEvents.ITEM_USE_TICK_EVENT);
        if (Services.PLATFORM.isPhysicalClient()) {
            EventHelperFabric.setup(ItemTooltipCallback.EVENT);
        }
    }
}

