/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.RichText;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_3545;
import net.minecraft.class_3728;
import org.jetbrains.annotations.Nullable;

public class RichSelectionManager
extends class_3728 {
    private final Supplier<RichText> textGetter;
    private final Consumer<RichText> textSetter;
    private final Predicate<RichText> textFilter;
    private final StateCallback stateCallback;
    private final Supplier<class_124> colorGetter;
    private final Supplier<Set<class_124>> modifiersGetter;

    public RichSelectionManager(Supplier<RichText> textGetter, Consumer<RichText> textSetter, StateCallback stateCallback, Supplier<String> clipboardGetter, Consumer<String> clipboardSetter, Predicate<RichText> textFilter, Supplier<class_124> colorGetter, Supplier<Set<class_124>> modifiersGetter) {
        super(() -> ((RichText)textGetter.get()).getPlainText(), text -> Scribble.LOGGER.warn("stringSetter called with \"{}\"", text), clipboardGetter, clipboardSetter, s -> true);
        this.textGetter = textGetter;
        this.textSetter = textSetter;
        this.textFilter = textFilter;
        this.stateCallback = stateCallback;
        this.colorGetter = colorGetter;
        this.modifiersGetter = modifiersGetter;
    }

    public boolean method_16199(char c) {
        Predicate<Character> isValidChar = class_155::method_643;
        if (isValidChar.test(Character.valueOf(c))) {
            this.method_16197(String.valueOf(c));
        }
        return true;
    }

    public void method_16197(String string) {
        RichText insertion;
        boolean isFormattedString;
        RichText text = this.textGetter.get();
        int start = Math.min(this.field_16453, this.field_16452);
        int end = Math.max(this.field_16453, this.field_16452);
        boolean bl = isFormattedString = !class_124.method_539((String)string).equals(string.replaceAll(class_124.field_1070.toString(), ""));
        if (isFormattedString) {
            insertion = RichText.fromFormattedString(string);
        } else {
            string = string.replaceAll(class_124.field_1070.toString(), "");
            insertion = new RichText(string, this.colorGetter.get(), this.modifiersGetter.get());
        }
        text = start == end ? text.insert(start, insertion) : text.replace(start, end, insertion);
        if (this.textFilter.test(text)) {
            int newCursorPosition;
            this.textSetter.accept(text);
            String plaintStringToInsert = RichText.fromFormattedString(string).getPlainText();
            this.field_16452 = this.field_16453 = (newCursorPosition = Math.min(text.getPlainText().length(), start + plaintStringToInsert.length()));
            this.notifyCursorFormattingChanged();
        }
    }

    public void method_27564(int offset) {
        RichText text = this.textGetter.get();
        if (this.field_16452 != this.field_16453) {
            int start = Math.min(this.field_16453, this.field_16452);
            int end = Math.max(this.field_16453, this.field_16452);
            text = text.replace(start, end, RichText.empty());
            this.field_16453 = this.field_16452 = start;
        } else {
            int cursor = class_156.method_27761((String)text.getPlainText(), (int)this.field_16453, (int)offset);
            int start = Math.min(cursor, this.field_16453);
            int end = Math.max(cursor, this.field_16453);
            text = text.replace(start, end, RichText.empty());
            this.field_16452 = this.field_16453 = start;
        }
        this.textSetter.accept(text);
        this.notifyCursorFormattingChanged();
    }

    public void method_27559() {
        this.field_16458.accept(this.getSelectedFormattedText());
    }

    public void method_27547() {
        this.field_16458.accept(this.getSelectedFormattedText());
        this.method_27564(0);
    }

    public String getSelectedFormattedText() {
        int i = Math.min(this.field_16453, this.field_16452);
        int j = Math.max(this.field_16453, this.field_16452);
        return this.textGetter.get().subText(i, j).getAsFormattedString();
    }

    public void method_27554() {
        this.method_16197((String)this.field_16456.get());
    }

    public void applyColorForSelection(class_124 color) {
        this.applyFormatting(color, Set.of(), Set.of());
    }

    public void toggleModifierForSelection(class_124 modifier, boolean toggled) {
        if (toggled) {
            this.applyFormatting(null, Set.of(modifier), Set.of());
        } else {
            this.applyFormatting(null, Set.of(), Set.of(modifier));
        }
    }

    private void applyFormatting(@Nullable class_124 newColor, Set<class_124> addModifiers, Set<class_124> removeModifiers) {
        if (this.method_27568()) {
            int start = Math.min(this.field_16453, this.field_16452);
            int end = Math.max(this.field_16453, this.field_16452);
            RichText text = this.textGetter.get().applyFormatting(start, end, newColor, addModifiers, removeModifiers);
            this.textSetter.accept(text);
        }
    }

    public void notifyCursorFormattingChanged() {
        if (this.stateCallback == null) {
            return;
        }
        class_3545<@Nullable class_124, Set<class_124>> format = this.getCursorFormatting();
        class_124 color = (class_124)format.method_15442();
        HashSet<class_124> modifiers = new HashSet<class_124>((Collection)format.method_15441());
        this.stateCallback.onCursorFormattingChanged(color, modifiers);
    }

    public class_3545<@Nullable class_124, Set<class_124>> getCursorFormatting() {
        if (this.textGetter == null) {
            return new class_3545(null, Set.of());
        }
        int start = Math.min(this.field_16453, this.field_16452);
        int end = Math.max(this.field_16453, this.field_16452);
        return this.textGetter.get().getCommonFormat(start, end);
    }

    public void method_27548(int start, int end) {
        super.method_27548(start, end);
        this.notifyCursorFormattingChanged();
    }

    public void method_27563() {
        super.method_27563();
        this.notifyCursorFormattingChanged();
    }

    protected void method_27562(boolean shiftDown) {
        super.method_27562(shiftDown);
        this.notifyCursorFormattingChanged();
    }

    public static interface StateCallback {
        public void onCursorFormattingChanged(@Nullable class_124 var1, Set<class_124> var2);
    }
}

