/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import me.chrr.scribble.Scribble;
import net.minecraft.class_2477;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Platform;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class FileChooser {
    private FileChooser() {
    }

    public static void chooseBook(boolean save, Consumer<Path> pathConsumer) {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                String path;
                PointerBuffer filter = stack.mallocPointer(1);
                filter.put(stack.UTF8((CharSequence)"*.book"));
                filter.flip();
                String defaultPath = String.valueOf(FileChooser.createAndGetBookDirectory()) + "/";
                if (save) {
                    path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)class_2477.method_10517().method_48307("text.scribble.action.save_book_to_file"), (CharSequence)defaultPath, (PointerBuffer)filter, (CharSequence)"Scribble Book (.book)");
                } else {
                    if (Platform.get() == Platform.MACOSX) {
                        filter = null;
                    }
                    path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)class_2477.method_10517().method_48307("text.scribble.action.load_book_from_file"), (CharSequence)defaultPath, (PointerBuffer)filter, (CharSequence)"Scribble Book (.book)", (boolean)false);
                }
                if (path == null) {
                    return;
                }
                try {
                    pathConsumer.accept(Path.of(path, new String[0]));
                }
                catch (InvalidPathException e) {
                    Scribble.LOGGER.error("failed to choose path", (Throwable)e);
                }
            }
        }, "File chooser").start();
    }

    public static Path createAndGetBookDirectory() {
        try {
            if (!Files.exists(Scribble.BOOK_DIR, new LinkOption[0])) {
                Files.createDirectory(Scribble.BOOK_DIR, new FileAttribute[0]);
            }
        }
        catch (Exception ignored) {
            Scribble.LOGGER.warn("couldn't create the default books directory");
        }
        return Scribble.BOOK_DIR;
    }
}

