/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.integration.voicechat;

import com.sonicether.soundphysics.SoundPhysics;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class AudioChannel {
    private static final String VOICECHAT = "voicechat";
    private static final class_2960 VOICECHAT_SOUND = new class_2960("voicechat", "voicechat");
    private final UUID channelId;
    private long lastUpdate;
    private class_243 lastPos;

    public AudioChannel(UUID channelId) {
        this.channelId = channelId;
    }

    public void onSound(int source, @Nullable class_243 soundPos, boolean auxOnly, @Nullable String category) {
        if (soundPos == null) {
            SoundPhysics.setDefaultEnvironment(source, auxOnly);
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 500L && this.lastPos != null && this.lastPos.method_1022(soundPos) < 1.0) {
            return;
        }
        SoundPhysics.setLastSoundCategoryAndName(class_3419.field_15250, category == null ? VOICECHAT_SOUND : new class_2960(VOICECHAT, category));
        if (auxOnly) {
            SoundPhysics.onPlayReverb(soundPos.method_10216(), soundPos.method_10214(), soundPos.method_10215(), source);
        } else {
            SoundPhysics.onPlaySound(soundPos.method_10216(), soundPos.method_10214(), soundPos.method_10215(), source);
        }
        this.lastUpdate = time;
        this.lastPos = soundPos;
    }

    public UUID getChannelId() {
        return this.channelId;
    }

    public boolean canBeRemoved() {
        return System.currentTimeMillis() - this.lastUpdate > 5000L;
    }

    public static boolean isVoicechatSound(class_2960 sound) {
        return sound.method_12836().equals(VOICECHAT);
    }
}

