/*
 * Decompiled with CFR 0.152.
 */
package einstein.armortrimitemfix;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5272;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8057;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorTrimItemFix {
    public static final String MOD_ID = "armortrimitemfix";
    public static final String MOD_NAME = "ArmorTrimItemFix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ArmorTrimItemFix");
    public static final class_2960 TRIM_PATTERN_PREDICATE_ID = ArmorTrimItemFix.loc("trim_pattern");
    public static final float DEFAULT_TRIM_VALUE = 0.001f;
    public static final Map<class_1792, TrimmableData> TRIMMABLES = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_1802.field_8267, new TrimmableData("leather", class_1738.class_8051.field_41934));
        map.put(class_1802.field_8577, new TrimmableData("leather", class_1738.class_8051.field_41935));
        map.put(class_1802.field_8570, new TrimmableData("leather", class_1738.class_8051.field_41936));
        map.put(class_1802.field_8370, new TrimmableData("leather", class_1738.class_8051.field_41937));
        map.put(class_1802.field_8283, new TrimmableData("chainmail", class_1738.class_8051.field_41934));
        map.put(class_1802.field_8873, new TrimmableData("chainmail", class_1738.class_8051.field_41935));
        map.put(class_1802.field_8218, new TrimmableData("chainmail", class_1738.class_8051.field_41936));
        map.put(class_1802.field_8313, new TrimmableData("chainmail", class_1738.class_8051.field_41937));
        map.put(class_1802.field_8743, new TrimmableData("iron", class_1738.class_8051.field_41934));
        map.put(class_1802.field_8523, new TrimmableData("iron", class_1738.class_8051.field_41935));
        map.put(class_1802.field_8396, new TrimmableData("iron", class_1738.class_8051.field_41936));
        map.put(class_1802.field_8660, new TrimmableData("iron", class_1738.class_8051.field_41937));
        map.put(class_1802.field_8862, new TrimmableData("golden", class_1738.class_8051.field_41934));
        map.put(class_1802.field_8678, new TrimmableData("golden", class_1738.class_8051.field_41935));
        map.put(class_1802.field_8416, new TrimmableData("golden", class_1738.class_8051.field_41936));
        map.put(class_1802.field_8753, new TrimmableData("golden", class_1738.class_8051.field_41937));
        map.put(class_1802.field_8805, new TrimmableData("diamond", class_1738.class_8051.field_41934));
        map.put(class_1802.field_8058, new TrimmableData("diamond", class_1738.class_8051.field_41935));
        map.put(class_1802.field_8348, new TrimmableData("diamond", class_1738.class_8051.field_41936));
        map.put(class_1802.field_8285, new TrimmableData("diamond", class_1738.class_8051.field_41937));
        map.put(class_1802.field_22027, new TrimmableData("netherite", class_1738.class_8051.field_41934));
        map.put(class_1802.field_22028, new TrimmableData("netherite", class_1738.class_8051.field_41935));
        map.put(class_1802.field_22029, new TrimmableData("netherite", class_1738.class_8051.field_41936));
        map.put(class_1802.field_22030, new TrimmableData("netherite", class_1738.class_8051.field_41937));
        map.put(class_1802.field_8090, new TrimmableData("turtle", class_1738.class_8051.field_41934));
    });
    public static final TreeSet<MaterialData> TRIM_MATERIALS = (TreeSet)class_156.method_654(new TreeSet(), list -> {
        list.add(new MaterialData("quartz", 0.1f));
        list.add(new MaterialData("iron", 0.2f, (class_1741)class_1740.field_7892, "iron_darker"));
        list.add(new MaterialData("netherite", 0.3f, (class_1741)class_1740.field_21977, "netherite_darker"));
        list.add(new MaterialData("redstone", 0.4f));
        list.add(new MaterialData("copper", 0.5f));
        list.add(new MaterialData("gold", 0.6f, (class_1741)class_1740.field_7895, "gold_darker"));
        list.add(new MaterialData("emerald", 0.7f));
        list.add(new MaterialData("diamond", 0.8f, (class_1741)class_1740.field_7889, "diamond_darker"));
        list.add(new MaterialData("lapis", 0.9f));
        list.add(new MaterialData("amethyst", 1.0f));
    });
    public static final Map<class_2960, Float> TRIM_PATTERNS = ArmorTrimItemFix.createValueSortedMap((Map)class_156.method_654(new HashMap(), map -> {
        List locations = (List)class_156.method_654(new ArrayList(), list -> {
            list.add(class_8057.field_42016.method_29177());
            list.add(class_8057.field_42017.method_29177());
            list.add(class_8057.field_42018.method_29177());
            list.add(class_8057.field_42019.method_29177());
            list.add(class_8057.field_42020.method_29177());
            list.add(class_8057.field_42021.method_29177());
            list.add(class_8057.field_42022.method_29177());
            list.add(class_8057.field_42023.method_29177());
            list.add(class_8057.field_42024.method_29177());
            list.add(class_8057.field_42025.method_29177());
            list.add(class_8057.field_42026.method_29177());
            list.add(class_8057.field_43221.method_29177());
            list.add(class_8057.field_43222.method_29177());
            list.add(class_8057.field_43223.method_29177());
            list.add(class_8057.field_43224.method_29177());
            list.add(class_8057.field_43225.method_29177());
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("storm"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("ram"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("myth"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("greed"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("beast"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("fever"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("wraith"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("nihility"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("horizon"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("origin"));
        });
        float f = 0.0f;
        float f1 = 1.0f / (float)(locations.size() + 1);
        for (class_2960 location : locations) {
            map.put(location, Float.valueOf(f += f1));
        }
    }), Float::compare);

    public static void init() {
    }

    public static void clientSetup() {
        for (class_1792 trimmable : TRIMMABLES.keySet()) {
            ArmorTrimItemFix.registerArmorTrimProperty(trimmable);
        }
    }

    public static void registerArmorTrimProperty(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)TRIM_PATTERN_PREDICATE_ID, (stack, level, entity, seed) -> {
            class_2487 trimTag;
            class_2487 tag = stack.method_7969();
            if (tag != null && tag.method_10545("Trim") && (trimTag = tag.method_10562("Trim")).method_10545("pattern")) {
                String pattern = trimTag.method_10558("pattern");
                Float value = TRIM_PATTERNS.get(class_2960.method_12829((String)pattern));
                return value == null ? 0.001f : value.floatValue();
            }
            return 0.0f;
        });
    }

    public static void registerDevCommand(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"spawnArmorTrimItemFrames").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            class_1937 level = player.method_37908();
            class_5455 registryAccess = level.method_30349();
            class_2378 materialRegistry = registryAccess.method_30530(class_7924.field_42083);
            class_2378 patternRegistry = registryAccess.method_30530(class_7924.field_42082);
            class_2338 playerPos = player.method_24515();
            class_2338.class_2339 pos = playerPos.method_25503();
            int[] zOffset = new int[]{pos.method_10260()};
            TRIMMABLES.forEach((item, type) -> {
                if (pos.method_10263() - playerPos.method_10263() >= (materialRegistry.method_10204() + 1) * 5) {
                    zOffset[0] = pos.method_10260() + patternRegistry.method_10204() + 1;
                    pos.method_33097(playerPos.method_10263());
                    pos.method_33099(zOffset[0]);
                }
                materialRegistry.forEach(material -> {
                    pos.method_33097(pos.method_10263() + 1);
                    patternRegistry.forEach(pattern -> {
                        class_1533 itemFrame = new class_1533(level, level.method_8598(class_2902.class_2903.field_13197, (class_2338)pos.method_33099(pos.method_10260() + 1)), class_2350.field_11036);
                        class_1799 stack = new class_1799((class_1935)item);
                        class_8053.method_48429((class_5455)registryAccess, (class_1799)stack, (class_8053)new class_8053(materialRegistry.method_47983(material), patternRegistry.method_47983(pattern)));
                        itemFrame.method_6935(stack);
                        level.method_8649((class_1297)itemFrame);
                    });
                    pos.method_33099(zOffset[0]);
                });
                pos.method_33097(pos.method_10263() + 1);
            });
            source.method_9226(() -> class_2561.method_43470((String)"Spawned item frames with armor trims"), true);
            return 1;
        }));
    }

    public static class_2960 overrideName(TrimmableData data, class_2960 item, String patternName, String materialName) {
        return ArmorTrimItemFix.loc("item/" + data.armorMaterial() + "/" + data.type().method_48400() + "/" + item.method_12832() + "_" + patternName + "_" + materialName + "_trim");
    }

    public static class_2960 vanillaOverrideName(class_2960 item, String materialName) {
        return new class_2960(item.method_12832() + "_" + materialName + "_trim");
    }

    public static class_2960 layerLoc(class_1738.class_8051 armorType, String patternName, String materialName) {
        return ArmorTrimItemFix.loc("trims/items/" + armorType.method_48400() + "/" + armorType.method_48400() + "_" + patternName + "_trim_" + materialName);
    }

    public static boolean isDoubleLayered(class_1792 item) {
        return item == class_1802.field_8267 || item == class_1802.field_8577 || item == class_1802.field_8570 || item == class_1802.field_8370;
    }

    public static class_2960 loc(String path) {
        return new class_2960(MOD_ID, path);
    }

    private static class_2960 moreArmorTrimsLoc(String path) {
        return new class_2960("more_armor_trims", path);
    }

    public static <K, V> Map<K, V> createValueSortedMap(Map<K, V> map, Comparator<V> comparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public record TrimmableData(String armorMaterial, class_1738.class_8051 type) {
    }

    public record MaterialData(String materialName, float propertyValue, class_1741 armorMaterial, String overrideName) implements Comparable<MaterialData>
    {
        public MaterialData(String materialName, float propertyValue) {
            this(materialName, propertyValue, null, null);
        }

        public String getName(class_1792 item) {
            if (item instanceof class_1738) {
                class_1738 armorItem = (class_1738)item;
                if (this.armorMaterial != null && this.overrideName != null && armorItem.method_7686() == this.armorMaterial) {
                    return this.overrideName;
                }
            }
            return this.materialName;
        }

        @Override
        public int compareTo(@NotNull MaterialData o) {
            return Float.compare(this.propertyValue(), o.propertyValue());
        }
    }
}

