/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.class_1309;

record WeightedAcoustic(Entry[] entries) implements Acoustic
{
    static final Acoustic.Serializer FACTORY = Acoustic.Serializer.ofJsObject((json, context) -> {
        ObjectArrayList entries = new ObjectArrayList();
        Iterator iter = json.getAsJsonArray(json.has("array") ? "array" : "entries").iterator();
        while (iter.hasNext()) {
            int weight = ((JsonElement)iter.next()).getAsInt();
            if (!iter.hasNext()) {
                throw new JsonParseException("Probability has odd number of children!");
            }
            entries.add(new Entry(weight, Acoustic.read(context, (JsonElement)iter.next())));
        }
        return new WeightedAcoustic((Entry[])entries.toArray(Entry[]::new));
    });

    WeightedAcoustic {
        float total = 0.0f;
        for (Entry entry : entries) {
            Preconditions.checkArgument((entry.weight >= 0 ? 1 : 0) != 0, (Object)"A probability weight can't be negative");
            total += (float)entry.weight;
        }
        if (total < 0.0f) {
            Preconditions.checkArgument((total >= 0.0f ? 1 : 0) != 0, (Object)"A probability weight can't be negative");
        }
        for (Entry entry : entries) {
            entry.threshold = (float)entry.weight / total;
        }
    }

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        float rand = player.getRNG().nextFloat();
        int marker = -1;
        while (++marker < this.entries.length) {
            if (!(this.entries[marker].threshold >= rand)) continue;
            this.entries[marker].acoustic.playSound(player, location, event, inputOptions);
            return;
        }
    }

    @Override
    public void write(AcousticsFile context, JsonObjectWriter writer) throws IOException {
        writer.object(() -> {
            writer.field("type", "probability");
            writer.array("entries", () -> {
                for (Entry entry : this.entries) {
                    writer.writer().value((long)entry.weight);
                    entry.acoustic.write(context, writer);
                }
            });
        });
    }

    private static class Entry {
        private final Acoustic acoustic;
        private final int weight;
        private float threshold;

        Entry(int weight, Acoustic acoustic) {
            this.weight = weight;
            this.acoustic = acoustic;
        }
    }
}

