/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.VolumeOption;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class JsonFile {
    private final transient Gson gson = new GsonBuilder().registerTypeAdapter(this.getClass(), t -> this).registerTypeAdapter(VolumeOption.class, (Object)new VolumeOption.Adapter(this)).setPrettyPrinting().create();
    private transient Path file;

    JsonFile() {
    }

    public JsonFile(Path file) {
        this.file = file;
    }

    public final void load() {
        if (Files.isReadable(this.file)) {
            try (BufferedReader reader = Files.newBufferedReader(this.file);){
                this.load(reader);
            }
            catch (Exception e) {
                PresenceFootsteps.logger.error("Invalid config", (Throwable)e);
            }
        }
        this.save();
    }

    public final void load(Reader reader) {
        this.gson.fromJson(reader, this.getClass());
    }

    public final void save() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
                this.gson.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

