/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.CompoundTagUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.ticks.LevelChunkTicks;

public class ChunkCompoundTagParser {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD Chunk Reader").fileLevelConfig(Config.Common.Logging.logWorldGenChunkLoadEventToFile).build();
    private static final AtomicBoolean ZERO_CHUNK_POS_ERROR_LOGGED_REF = new AtomicBoolean(false);
    private static final ConcurrentHashMap<String, Object> LOGGED_ERROR_MESSAGE_MAP = new ConcurrentHashMap();
    private static boolean lightingSectionErrorLogged = false;

    public static ChunkWrapper createFromTag(WorldGenLevel mcWorldGenLevel, IDhServerLevel dhServerLevel, ChunkPos chunkPos, CompoundTag chunkData) {
        int chunkZ;
        CompoundTag tagLevel = chunkData;
        int chunkX = CompoundTagUtil.getInt(tagLevel, "xPos");
        ChunkPos actualChunkPos = new ChunkPos(chunkX, chunkZ = CompoundTagUtil.getInt(tagLevel, "zPos"));
        if (!Objects.equals(chunkPos, actualChunkPos)) {
            if (chunkX == 0 && chunkZ == 0) {
                if (!ZERO_CHUNK_POS_ERROR_LOGGED_REF.getAndSet(true)) {
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. ", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualChunkPos.toString() + "]) ", new Object[0]);
                return null;
            }
        }
        LevelChunkTicks blockTicks = new LevelChunkTicks();
        LevelChunkTicks fluidTicks = new LevelChunkTicks();
        int sectionYCount = mcWorldGenLevel.m_151559_();
        LevelChunkSection[] chunkSections = new LevelChunkSection[sectionYCount];
        boolean hasBlocks = ChunkCompoundTagParser.readAndPopulateSections((LevelAccessor)mcWorldGenLevel, chunkPos, tagLevel, chunkSections);
        if (!hasBlocks) {
            return null;
        }
        long inhabitedTime = CompoundTagUtil.getLong(tagLevel, "InhabitedTime");
        boolean isLightOn = CompoundTagUtil.getBoolean(tagLevel, "isLightOn");
        LevelChunk chunk = new LevelChunk((Level)mcWorldGenLevel, chunkPos, UpgradeData.f_63320_, blockTicks, fluidTicks, inhabitedTime, chunkSections, null, null);
        chunk.m_8094_(isLightOn);
        boolean hasHeightmapData = ChunkCompoundTagParser.readHeightmaps(chunk, chunkData);
        ChunkWrapper chunkWrapper = new ChunkWrapper((ChunkAccess)chunk, dhServerLevel.getServerLevelWrapper());
        chunkWrapper.createDhHeightMaps();
        boolean chunkHasBlocks = false;
        int serverMinHeight = dhServerLevel.getServerLevelWrapper().getMinHeight();
        for (int x = 0; x < 16 && !chunkHasBlocks; ++x) {
            for (int z = 0; z < 16 && !chunkHasBlocks; ++z) {
                int heightMap = Math.max(chunkWrapper.getLightBlockingHeightMapValue(x, z), chunkWrapper.getSolidHeightMapValue(x, z));
                if (heightMap == serverMinHeight) continue;
                chunkHasBlocks = true;
            }
        }
        if (chunkHasBlocks) {
            return chunkWrapper;
        }
        return null;
    }

    private static boolean readAndPopulateSections(LevelAccessor level, ChunkPos chunkPos, CompoundTag chunkData, LevelChunkSection[] chunkSections) {
        int sectionYCount = level.m_151559_();
        ListTag tagSections = CompoundTagUtil.getListTag(chunkData, "Sections", 10);
        if (tagSections == null || tagSections.isEmpty()) {
            tagSections = CompoundTagUtil.getListTag(chunkData, "sections", 10);
        }
        boolean blocksFound = false;
        if (tagSections != null) {
            for (int i = 0; i < tagSections.size(); ++i) {
                PalettedContainer blockStateContainer;
                byte sectionYPos;
                int sectionId;
                CompoundTag tagSection = CompoundTagUtil.getCompoundTag(tagSections, i);
                if (tagSection == null || (sectionId = level.m_151566_((int)(sectionYPos = CompoundTagUtil.getByte(tagSection, "Y")))) < 0 || sectionId >= chunkSections.length) continue;
                boolean containsBlockStates = CompoundTagUtil.contains(tagSection, "block_states", 10);
                if (containsBlockStates) {
                    Codec<PalettedContainer<BlockState>> blockStateCodec = ChunkCompoundTagParser.getBlockStateCodec(level);
                    blockStateContainer = (PalettedContainer)blockStateCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)CompoundTagUtil.getCompoundTag(tagSection, "block_states")).promotePartial(string -> ChunkCompoundTagParser.logBlockDeserializationWarning(chunkPos, sectionYPos, string)).getOrThrow(false, message -> ChunkCompoundTagParser.logParsingWarningOnce(message));
                    blocksFound = true;
                } else {
                    blockStateContainer = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                }
                Registry<Biome> biomeRegistry = ChunkCompoundTagParser.getBiomeRegistry(level);
                Codec<PalettedContainer<Holder<Biome>>> biomeCodec = ChunkCompoundTagParser.getBiomeCodec(level, biomeRegistry);
                CompoundTag biomeTag = CompoundTagUtil.getCompoundTag(tagSection, "biomeRegistry");
                if (biomeTag == null) {
                    biomeTag = CompoundTagUtil.getCompoundTag(tagSection, "biomes");
                }
                PalettedContainer biomeContainer = biomeTag != null && !biomeTag.m_128456_() ? new PalettedContainer(biomeRegistry.m_206115_(), (Object)biomeRegistry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_) : new PalettedContainer(biomeRegistry.m_206115_(), (Object)biomeRegistry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
                chunkSections[sectionId] = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
            }
        }
        return blocksFound;
    }

    private static Codec<PalettedContainer<BlockState>> getBlockStateCodec(LevelAccessor level) {
        return PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    }

    private static Registry<Biome> getBiomeRegistry(LevelAccessor level) {
        return level.m_9598_().m_175515_(Registries.f_256952_);
    }

    private static Codec<PalettedContainer<Holder<Biome>>> getBiomeCodec(LevelAccessor level, Registry<Biome> biomeRegistry) {
        return PalettedContainer.m_238371_((IdMap)biomeRegistry.m_206115_(), (Codec)biomeRegistry.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)biomeRegistry.m_246971_(Biomes.f_48202_));
    }

    private static boolean readHeightmaps(LevelChunk chunk, CompoundTag chunkData) {
        CompoundTag tagHeightmaps = CompoundTagUtil.getCompoundTag(chunkData, "Heightmaps");
        if (tagHeightmaps == null) {
            return false;
        }
        for (Heightmap.Types type : ChunkStatus.f_62326_.m_62500_()) {
            String heightmapKey = type.m_64294_();
            if (!tagHeightmaps.m_128425_(heightmapKey, 12)) continue;
            chunk.m_6511_(type, tagHeightmaps.m_128467_(heightmapKey));
        }
        Heightmap.m_64256_((ChunkAccess)chunk, (Set)ChunkStatus.f_62326_.m_62500_());
        return true;
    }

    public static CombinedChunkLightStorage readLight(ChunkAccess chunk, CompoundTag chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getInclusiveMinBuildHeight(chunk), ChunkWrapper.getExclusiveMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        Tag chunkSectionTags = chunkData.m_128423_("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.m_7697_()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof ListTag)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + ListTag.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        ListTag chunkSectionListTag = (ListTag)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            Tag chunkSectionTag = chunkSectionListTag.get(sectionIndex);
            if (!(chunkSectionTag instanceof CompoundTag)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + CompoundTag.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            CompoundTag chunkSectionCompoundTag = (CompoundTag)chunkSectionTag;
            byte[] blockLightNibbleArray = CompoundTagUtil.getByteArray(chunkSectionCompoundTag, "BlockLight");
            byte[] skyLightNibbleArray = CompoundTagUtil.getByteArray(chunkSectionCompoundTag, "SkyLight");
            if (blockLightNibbleArray == null || skyLightNibbleArray == null) continue;
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkCompoundTagParser.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkCompoundTagParser.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getInclusiveMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logBlockDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize blocks for chunk section [" + chunkPos.f_45578_ + ", " + sectionYIndex + ", " + chunkPos.f_45579_ + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logBiomeDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize biomes for chunk section [" + chunkPos.f_45578_ + ", " + sectionYIndex + ", " + chunkPos.f_45579_ + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logParsingWarningOnce(String message) {
        ChunkCompoundTagParser.logParsingWarningOnce(message, null);
    }

    private static void logParsingWarningOnce(String message, Exception e) {
        if (message == null) {
            return;
        }
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", e);
            return newMessage;
        });
    }

    private static RuntimeException logErrorAndReturnException(String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
        return null;
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

