/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.ThreadWorldGenParams;

public final class GenerationEvent {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final AtomicInteger DEBUG_ID_REF = new AtomicInteger(0);
    public final int id = DEBUG_ID_REF.getAndIncrement();
    public final ThreadWorldGenParams threadedParam;
    public final DhChunkPos minPos;
    public final int widthInChunks;
    public final EDhApiWorldGenerationStep targetGenerationStep;
    public final EDhApiDistantGeneratorMode generatorMode;
    public final CompletableFuture<Void> future;
    public final Consumer<IChunkWrapper> resultConsumer;

    private GenerationEvent(DhChunkPos minPos, int widthInChunks, BatchGenerationEnvironment generationGroup, EDhApiDistantGeneratorMode generatorMode, EDhApiWorldGenerationStep targetGenerationStep, Consumer<IChunkWrapper> resultConsumer) {
        this.minPos = minPos;
        this.widthInChunks = widthInChunks;
        this.targetGenerationStep = targetGenerationStep;
        this.generatorMode = generatorMode;
        this.threadedParam = ThreadWorldGenParams.getOrMake(generationGroup.globalParams);
        this.future = new CompletableFuture();
        this.resultConsumer = resultConsumer;
    }

    public static GenerationEvent start(DhChunkPos minPos, int widthInChunks, BatchGenerationEnvironment genEnvironment, EDhApiDistantGeneratorMode generatorMode, EDhApiWorldGenerationStep target, Consumer<IChunkWrapper> resultConsumer, ExecutorService worldGeneratorThreadPool) {
        GenerationEvent genEvent = new GenerationEvent(minPos, widthInChunks, genEnvironment, generatorMode, target, resultConsumer);
        try {
            worldGeneratorThreadPool.execute(() -> {
                try {
                    BatchGenerationEnvironment.isDhWorldGenThreadRef.set(true);
                    if (genEvent.generatorMode == EDhApiDistantGeneratorMode.INTERNAL_SERVER) {
                        genEnvironment.internalServerGenerator.generateChunksViaInternalServer(genEvent);
                        genEvent.future.complete(null);
                        return;
                    }
                    try {
                        genEnvironment.generateEvent(genEvent);
                        genEvent.future.complete(null);
                        return;
                    }
                    catch (Throwable throwable) {
                        try {
                            GenerationEvent.handleWorldGenThrowable(genEvent, throwable);
                            return;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            genEvent.future.complete(null);
                        }
                    }
                }
                catch (Throwable initialThrowable) {
                    GenerationEvent.handleWorldGenThrowable(genEvent, initialThrowable);
                    return;
                }
                finally {
                    BatchGenerationEnvironment.isDhWorldGenThreadRef.remove();
                }
            });
        }
        catch (RejectedExecutionException e) {
            genEvent.future.completeExceptionally(e);
        }
        return genEvent;
    }

    private static void handleWorldGenThrowable(GenerationEvent generationEvent, Throwable initialThrowable) {
        Throwable throwable = initialThrowable;
        while (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        boolean isShutdownException = ExceptionUtil.isShutdownException(throwable);
        if (!isShutdownException) {
            generationEvent.future.completeExceptionally(throwable);
        }
    }

    public String toString() {
        return this.id + ":" + this.widthInChunks + "@" + String.valueOf(this.minPos) + "(" + String.valueOf((Object)this.targetGenerationStep) + ")";
    }
}

