/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui;

import com.seibel.distanthorizons.api.enums.config.DisallowSelectingViaConfigGui;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUISpacer;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.config.types.enums.EConfigCommentTextPosition;
import com.seibel.distanthorizons.core.config.types.enums.EConfigValidity;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.AnnotationUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.IConfigGui;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.TexturedButtonWidget;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.config.ConfigGuiInfo;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.updater.ChangelogScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassicConfigGUI {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static final DhLogger RATE_LIMITED_LOGGER = new DhLoggerBuilder().maxCountPerSecond(1).build();
    public static final ConfigCoreInterface CONFIG_CORE_INTERFACE = new ConfigCoreInterface();
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");

    public static Screen getScreen(Screen parent, String category) {
        return new ConfigScreen(parent, category);
    }

    private static class ConfigScreen
    extends DhScreen {
        private static final ILangWrapper LANG_WRAPPER = SingletonInjector.INSTANCE.get(ILangWrapper.class);
        private static final String TRANSLATION_PREFIX = "distanthorizons.config.";
        private final Screen parent;
        private final String category;
        private ConfigListWidget configListWidget;
        private boolean reload = false;
        private Button doneButton;

        protected ConfigScreen(Screen parent, String category) {
            super((Component)GuiHelper.Translatable((String)(LANG_WRAPPER.langExists("distanthorizons.config" + (String)(category.isEmpty() ? "." + category : "") + ".title") ? "distanthorizons.config.title" : "distanthorizons.config" + (String)(category.isEmpty() ? "" : "." + category) + ".title"), new Object[0]));
            this.parent = parent;
            this.category = category;
        }

        public void m_86600_() {
            super.m_86600_();
        }

        protected void m_7856_() {
            super.m_7856_();
            if (!this.reload) {
                ConfigHandler.INSTANCE.configFileHandler.loadFromFile();
            }
            if (Config.Client.Advanced.AutoUpdater.enableAutoUpdater.get().booleanValue() && !ModInfo.IS_DEV_BUILD) {
                this.addBtn((Button)new TexturedButtonWidget(this.f_96543_ - 28, this.f_96544_ - 28, 20, 20, 0, 0, 0, new ResourceLocation("distanthorizons", "textures/gui/changelog.png"), 20, 20, buttonWidget -> {
                    ChangelogScreen changelogScreen = new ChangelogScreen(this);
                    if (changelogScreen.usable) {
                        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)changelogScreen);
                    } else {
                        LOGGER.warn("Changelog was not able to open", new Object[0]);
                    }
                }, (Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0])));
            }
            this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.back", new Object[0]), this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20, button -> {
                ConfigHandler.INSTANCE.configFileHandler.loadFromFile();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            this.doneButton = this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.done", new Object[0]), this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20, button -> {
                ConfigHandler.INSTANCE.configFileHandler.saveToFile();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            this.configListWidget = new ConfigListWidget(this.f_96541_, this.f_96543_ * 2, this.f_96544_, 32, 32, 25);
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.configListWidget.m_93488_(false);
            }
            this.m_7787_((GuiEventListener)this.configListWidget);
            for (AbstractConfigBase<?> configEntry : ConfigHandler.INSTANCE.configBaseList) {
                try {
                    if (!configEntry.getCategory().matches(this.category) || !configEntry.getAppearance().showInGui) continue;
                    this.addMenuItem(configEntry);
                }
                catch (Exception e) {
                    String message = "ERROR: Failed to show [" + configEntry.getNameAndCategory() + "], error: [" + e.getMessage() + "]";
                    if (configEntry.get() != null) {
                        message = message + " with the value [" + String.valueOf(configEntry.get()) + "] with type [" + String.valueOf(configEntry.getType()) + "]";
                    }
                    LOGGER.error(message, e);
                }
            }
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }

        private void addMenuItem(AbstractConfigBase<?> configEntry) {
            ConfigScreen.trySetupConfigEntry(configEntry);
            if (this.tryCreateInputField(configEntry)) {
                return;
            }
            if (this.tryCreateCategoryButton(configEntry)) {
                return;
            }
            if (this.tryCreateButton(configEntry)) {
                return;
            }
            if (this.tryCreateComment(configEntry)) {
                return;
            }
            if (this.tryCreateSpacer(configEntry)) {
                return;
            }
            if (this.tryCreateLinkedEntry(configEntry)) {
                return;
            }
            LOGGER.warn("Config [" + configEntry.getNameAndCategory() + "] failed to show. Please try something like changing its type.", new Object[0]);
        }

        private static void trySetupConfigEntry(AbstractConfigBase<?> configMenuOption) {
            configMenuOption.guiValue = new ConfigGuiInfo();
            Class<?> configValueClass = configMenuOption.getType();
            if (configMenuOption instanceof ConfigEntry) {
                ConfigEntry configEntry = (ConfigEntry)configMenuOption;
                if (configValueClass == Integer.class) {
                    ConfigScreen.setupTextMenuOption(configEntry, Integer::parseInt, INTEGER_ONLY_REGEX, true);
                } else if (configValueClass == Double.class) {
                    ConfigScreen.setupTextMenuOption(configEntry, Double::parseDouble, DECIMAL_ONLY_REGEX, false);
                } else if (configValueClass == String.class || configValueClass == List.class) {
                    ConfigScreen.setupTextMenuOption(configEntry, String::length, null, true);
                } else if (configValueClass == Boolean.class) {
                    ConfigEntry booleanConfigEntry = configEntry;
                    ConfigScreen.setupBooleanMenuOption(booleanConfigEntry);
                } else if (configValueClass.isEnum()) {
                    ConfigEntry enumConfigEntry = configEntry;
                    Class<?> configEnumClass = configValueClass;
                    ConfigScreen.setupEnumMenuOption(enumConfigEntry, configEnumClass);
                }
            }
        }

        private static void setupTextMenuOption(AbstractConfigBase<?> configMenuOption, Function<String, Number> parsingFunc, @Nullable Pattern pattern, boolean cast) {
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)configMenuOption.guiValue;
            configGuiInfo.tooltipFunction = (editBox, button) -> stringValue -> {
                boolean isNumber = pattern != null;
                if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                    return false;
                }
                Number numberValue = configMenuOption.typeIsFloatingPointNumber() ? 0.0 : 0.0;
                configGuiInfo.errorMessage = null;
                if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                    ConfigEntry numberConfigEntry = (ConfigEntry)configMenuOption;
                    try {
                        numberValue = (Number)parsingFunc.apply((String)stringValue);
                    }
                    catch (Exception e) {
                        numberValue = null;
                    }
                    EConfigValidity validity = numberConfigEntry.getValidity(numberValue);
                    switch (validity) {
                        case VALID: {
                            configGuiInfo.errorMessage = null;
                            break;
                        }
                        case NUMBER_TOO_LOW: {
                            configGuiInfo.errorMessage = GuiHelper.TextOrTranslatable("\u00a7cMinimum length is " + String.valueOf(numberConfigEntry.getMin()));
                            break;
                        }
                        case NUMBER_TOO_HIGH: {
                            configGuiInfo.errorMessage = GuiHelper.TextOrTranslatable("\u00a7cMaximum length is " + String.valueOf(numberConfigEntry.getMax()));
                            break;
                        }
                        case INVALID: {
                            configGuiInfo.errorMessage = GuiHelper.TextOrTranslatable("\u00a7cValue is invalid");
                        }
                    }
                }
                editBox.m_94202_(((ConfigEntry)configMenuOption).getValidity(numberValue) == EConfigValidity.VALID ? -1 : -34953);
                if (configMenuOption.getType() == String.class || configMenuOption.getType() == List.class) {
                    ((ConfigEntry)configMenuOption).uiSetWithoutSaving(stringValue);
                } else if (((ConfigEntry)configMenuOption).getValidity(numberValue) == EConfigValidity.VALID) {
                    if (!cast) {
                        ((ConfigEntry)configMenuOption).uiSetWithoutSaving(numberValue);
                    } else {
                        ((ConfigEntry)configMenuOption).uiSetWithoutSaving(numberValue != null ? numberValue.intValue() : 0);
                    }
                }
                return true;
            };
        }

        private static void setupBooleanMenuOption(ConfigEntry<Boolean> booleanConfigEntry) {
            Function<Object, Component> func = value -> GuiHelper.Translatable("distanthorizons.general." + ((Boolean)value != false ? "true" : "false"), new Object[0]).m_130940_((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)booleanConfigEntry.guiValue;
            configGuiInfo.buttonOptionMap = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                button.f_93623_ = !booleanConfigEntry.apiIsOverriding();
                booleanConfigEntry.uiSetWithoutSaving((Boolean)booleanConfigEntry.get() == false);
                button.m_93666_((Component)func.apply(booleanConfigEntry.get()));
            }, func);
        }

        private static void setupEnumMenuOption(ConfigEntry<Enum<?>> enumConfigEntry, Class<? extends Enum<?>> enumClass) {
            List<Enum<?>> enumList = Arrays.asList(enumClass.getEnumConstants());
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)enumConfigEntry.guiValue;
            Function<Object, Component> getEnumTranslatableFunc = value -> GuiHelper.Translatable("distanthorizons.config.enum." + enumClass.getSimpleName() + "." + ((Enum)enumConfigEntry.get()).toString(), new Object[0]);
            configGuiInfo.buttonOptionMap = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                int startingIndex = enumList.indexOf(enumConfigEntry.get());
                Enum enumValue = (Enum)enumList.get(startingIndex);
                int index = startingIndex + 1;
                int n = index = index >= enumList.size() ? 0 : index;
                while (index != startingIndex && AnnotationUtil.doesEnumHaveAnnotation(enumValue = (Enum)enumList.get(index), DisallowSelectingViaConfigGui.class)) {
                    index = ++index >= enumList.size() ? 0 : index;
                }
                if (index == startingIndex) {
                    enumValue = (Enum)enumList.get(startingIndex);
                    LOGGER.warn("Enum [" + String.valueOf(enumValue.getClass()) + "] doesn't contain any values that should be selectable via the UI, sticking to the currently selected value [" + String.valueOf(enumValue) + "].", new Object[0]);
                }
                enumConfigEntry.uiSetWithoutSaving(enumValue);
                button.f_93623_ = !enumConfigEntry.apiIsOverriding();
                button.m_93666_((Component)getEnumTranslatableFunc.apply(enumConfigEntry.get()));
            }, getEnumTranslatableFunc);
        }

        private boolean tryCreateInputField(AbstractConfigBase<?> configBase) {
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)configBase.guiValue;
            if (configBase instanceof ConfigEntry) {
                ConfigEntry configEntry = (ConfigEntry)configBase;
                Button.OnPress btnAction = button -> {
                    configEntry.uiSetWithoutSaving(configEntry.getDefaultValue());
                    this.reload = true;
                    Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                };
                int resetButtonPosX = this.f_96543_ - 60 - 10;
                int resetButtonPosZ = 0;
                Button resetButton = GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.reset", new Object[0]).m_130940_(ChatFormatting.RED), resetButtonPosX, resetButtonPosZ, 60, 20, btnAction);
                if (configEntry.apiIsOverriding()) {
                    resetButton.f_93623_ = false;
                    resetButton.m_93666_((Component)GuiHelper.Translatable("distanthorizons.general.apiOverride", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
                } else {
                    resetButton.f_93623_ = true;
                }
                Component textComponent = this.GetTranslatableTextComponentForConfig(configEntry);
                int optionFieldPosX = this.f_96543_ - 10 - 60 - 5 - 150;
                int optionFieldPosZ = 0;
                if (configGuiInfo.buttonOptionMap != null) {
                    AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>> widget = configGuiInfo.buttonOptionMap;
                    if (configEntry.getType().isEnum()) {
                        widget.setValue(value -> GuiHelper.Translatable("distanthorizons.config.enum." + configEntry.getType().getSimpleName() + "." + configEntry.get().toString(), new Object[0]));
                    }
                    Button button2 = GuiHelper.MakeBtn((Component)((Function)widget.getValue()).apply(configEntry.get()), optionFieldPosX, optionFieldPosZ, 150, 20, (Button.OnPress)widget.getKey());
                    button2.f_93623_ = !configEntry.apiIsOverriding();
                    this.configListWidget.addButton(this, configEntry, (AbstractWidget)button2, (AbstractWidget)resetButton, null, textComponent);
                    return true;
                }
                EditBox widget = new EditBox(this.f_96547_, optionFieldPosX, optionFieldPosZ, 146, 20, (Component)GuiHelper.Translatable("", new Object[0]));
                widget.m_94199_(150);
                widget.m_94164_(String.valueOf(configEntry.get()));
                Predicate<String> processor = configGuiInfo.tooltipFunction.apply(widget, this.doneButton);
                widget.m_94153_(processor);
                this.configListWidget.addButton(this, configEntry, (AbstractWidget)widget, (AbstractWidget)resetButton, null, textComponent);
                return true;
            }
            return false;
        }

        private boolean tryCreateCategoryButton(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigCategory) {
                ConfigCategory configCategory = (ConfigCategory)configType;
                Component textComponent = this.GetTranslatableTextComponentForConfig(configCategory);
                int categoryPosX = this.f_96543_ - 200 - 10;
                int categoryPosZ = this.f_96544_ - 20;
                Button widget = GuiHelper.MakeBtn(textComponent, categoryPosX, categoryPosZ, 200, 20, button -> {
                    ConfigHandler.INSTANCE.configFileHandler.saveToFile();
                    Objects.requireNonNull(this.f_96541_).m_91152_(ClassicConfigGUI.getScreen(this, configCategory.getDestination()));
                });
                this.configListWidget.addButton(this, configType, (AbstractWidget)widget, null, null, null);
                return true;
            }
            return false;
        }

        private boolean tryCreateButton(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUIButton) {
                ConfigUIButton configUiButton = (ConfigUIButton)configType;
                Component textComponent = this.GetTranslatableTextComponentForConfig(configUiButton);
                int buttonPosX = this.f_96543_ - 200 - 10;
                Button widget = GuiHelper.MakeBtn(textComponent, buttonPosX, this.f_96544_ - 28, 200, 20, button -> ((ConfigUIButton)configType).runAction());
                this.configListWidget.addButton(this, configType, (AbstractWidget)widget, null, null, null);
                return true;
            }
            return false;
        }

        private boolean tryCreateComment(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUIComment) {
                ConfigUIComment configUiComment = (ConfigUIComment)configType;
                Component textComponent = this.GetTranslatableTextComponentForConfig(configUiComment);
                if (configUiComment.parentConfigPath != null) {
                    textComponent = GuiHelper.Translatable(TRANSLATION_PREFIX + configUiComment.parentConfigPath, new Object[0]);
                }
                this.configListWidget.addButton(this, configType, null, null, null, textComponent);
                return true;
            }
            return false;
        }

        private boolean tryCreateSpacer(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUISpacer) {
                Button spacerButton = GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.spacer", new Object[0]), 10, 10, 1, 1, button -> {});
                spacerButton.f_93624_ = false;
                this.configListWidget.addButton(this, configType, (AbstractWidget)spacerButton, null, null, null);
                return true;
            }
            return false;
        }

        private boolean tryCreateLinkedEntry(AbstractConfigBase<?> configType) {
            if (configType instanceof ConfigUiLinkedEntry) {
                this.addMenuItem((AbstractConfigBase)((ConfigUiLinkedEntry)configType).get());
                return true;
            }
            return false;
        }

        private Component GetTranslatableTextComponentForConfig(AbstractConfigBase<?> configType) {
            return GuiHelper.Translatable(TRANSLATION_PREFIX + configType.getNameAndCategory(), new Object[0]);
        }

        public void m_88315_(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
            this.m_280273_(matrices);
            this.configListWidget.m_88315_(matrices, mouseX, mouseY, delta);
            this.DhDrawCenteredString(matrices, this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
            this.DhDrawString(matrices, this.f_96547_, (Component)GuiHelper.TextOrLiteral("2.4.5-b"), 2, this.f_96544_ - 10, 0xAAAAAA);
            if (SelfUpdater.deleteOldJarOnJvmShutdown) {
                this.DhDrawString(matrices, this.f_96547_, (Component)GuiHelper.Translatable("distanthorizons.updater.waitingForClose", new Object[0]), 4, this.f_96544_ - 42, 0xFFFFFF);
            }
            this.renderTooltip(matrices, mouseX, mouseY, delta);
            super.m_88315_(matrices, mouseX, mouseY, delta);
        }

        private void renderTooltip(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
            AbstractWidget hoveredWidget = this.configListWidget.getHoveredButton(mouseX, mouseY);
            if (hoveredWidget == null) {
                return;
            }
            ButtonEntry button = ButtonEntry.BUTTON_BY_WIDGET.get(hoveredWidget);
            AbstractConfigBase configBase = ConfigUiLinkedEntry.class.isAssignableFrom(button.dhConfigType.getClass()) ? (AbstractConfigBase)((ConfigUiLinkedEntry)button.dhConfigType).get() : button.dhConfigType;
            boolean apiOverrideActive = false;
            if (configBase instanceof ConfigEntry) {
                apiOverrideActive = ((ConfigEntry)configBase).apiIsOverriding();
            }
            Object key = TRANSLATION_PREFIX + (String)(configBase.category.isEmpty() ? "" : configBase.category + ".") + configBase.getName() + ".@tooltip";
            if (apiOverrideActive) {
                key = "distanthorizons.general.disabledByApi.@tooltip";
            }
            ConfigGuiInfo configGuiInfo = (ConfigGuiInfo)configBase.guiValue;
            if (configGuiInfo.errorMessage != null) {
                this.DhRenderTooltip(matrices, this.f_96547_, configGuiInfo.errorMessage, mouseX, mouseY);
            } else if (LANG_WRAPPER.langExists((String)key)) {
                ArrayList<Component> list = new ArrayList<Component>();
                String lang = LANG_WRAPPER.getLang((String)key);
                for (String langLine : lang.split("\n")) {
                    list.add((Component)GuiHelper.TextOrTranslatable(langLine));
                }
                this.DhRenderComponentTooltip(matrices, this.f_96547_, list, mouseX, mouseY);
            }
        }

        public void m_7379_() {
            ConfigHandler.INSTANCE.configFileHandler.saveToFile();
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }
    }

    public static class ConfigCoreInterface
    implements IConfigGui {
        public final ArrayList<Runnable> onScreenChangeListenerList = new ArrayList();

        @Override
        public void addOnScreenChangeListener(Runnable newListener) {
            this.onScreenChangeListenerList.add(newListener);
        }

        @Override
        public void removeOnScreenChangeListener(Runnable oldListener) {
            this.onScreenChangeListenerList.remove(oldListener);
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.m_91087_().f_91062_;
        private final AbstractWidget button;
        private final ConfigScreen gui;
        private final AbstractConfigBase dhConfigType;
        private final AbstractWidget resetButton;
        private final AbstractWidget indexButton;
        private final Component text;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        @NotNull
        private final EConfigCommentTextPosition textPosition;
        public static final Map<AbstractWidget, Component> TEXT_BY_WIDGET = new HashMap<AbstractWidget, Component>();
        public static final Map<AbstractWidget, ButtonEntry> BUTTON_BY_WIDGET = new HashMap<AbstractWidget, ButtonEntry>();

        public ButtonEntry(ConfigScreen gui, AbstractConfigBase dhConfigType, AbstractWidget button, Component text, AbstractWidget resetButton, AbstractWidget indexButton) {
            TEXT_BY_WIDGET.put(button, text);
            BUTTON_BY_WIDGET.put(button, this);
            this.gui = gui;
            this.dhConfigType = dhConfigType;
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
            EConfigCommentTextPosition textPosition = null;
            if (this.dhConfigType instanceof ConfigUIComment) {
                textPosition = ((ConfigUIComment)this.dhConfigType).textPosition;
            }
            if (textPosition == null) {
                textPosition = this.button != null ? EConfigCommentTextPosition.RIGHT_JUSTIFIED : EConfigCommentTextPosition.CENTERED_OVER_BUTTONS;
            }
            this.textPosition = textPosition;
        }

        public void m_6311_(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            try {
                if (this.button != null) {
                    GuiHelper.SetY(this.button, y);
                    this.button.m_88315_(matrices, mouseX, mouseY, tickDelta);
                }
                if (this.resetButton != null) {
                    GuiHelper.SetY(this.resetButton, y);
                    this.resetButton.m_88315_(matrices, mouseX, mouseY, tickDelta);
                }
                if (this.indexButton != null) {
                    GuiHelper.SetY(this.indexButton, y);
                    this.indexButton.m_88315_(matrices, mouseX, mouseY, tickDelta);
                }
                if (this.text != null) {
                    int textXPos;
                    int translatedLength = textRenderer.m_92852_((FormattedText)this.text);
                    if (this.textPosition == EConfigCommentTextPosition.RIGHT_JUSTIFIED) {
                        textXPos = this.gui.f_96543_ - translatedLength - 8 - 10 - 150 - 5 - 60;
                    } else if (this.textPosition == EConfigCommentTextPosition.CENTERED_OVER_BUTTONS) {
                        textXPos = this.gui.f_96543_ - translatedLength / 2 - 100 - 10;
                    } else if (this.textPosition == EConfigCommentTextPosition.CENTER_OF_SCREEN) {
                        textXPos = this.gui.f_96543_ / 2 - translatedLength / 2;
                    } else {
                        throw new UnsupportedOperationException("No text position render defined for [" + String.valueOf((Object)this.textPosition) + "]");
                    }
                    matrices.m_280430_(textRenderer, this.text, textXPos, y + 5, 0xFFFFFF);
                }
            }
            catch (Exception e) {
                RATE_LIMITED_LOGGER.error("Unexpected gui rendering issue: [" + e.getMessage() + "]", e);
            }
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font textRenderer;

        public ConfigListWidget(Minecraft minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight, topMargin, canvasHeight - botMargin, itemSpacing);
            this.f_93394_ = false;
            this.textRenderer = minecraftClient.f_91062_;
        }

        public void addButton(ConfigScreen gui, AbstractConfigBase dhConfigType, AbstractWidget button, AbstractWidget resetButton, AbstractWidget indexButton, Component text) {
            this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry(gui, dhConfigType, button, text, resetButton, indexButton));
        }

        public int m_5759_() {
            return 10000;
        }

        public AbstractWidget getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.m_6702_()) {
                AbstractWidget button = buttonEntry.button;
                if (button == null || !button.f_93624_) continue;
                double minX = button.m_252754_();
                double minY = button.m_252907_();
                double maxX = minX + (double)button.m_5711_();
                double maxY = minY + (double)button.m_93694_();
                if (!(mouseX >= minX) || !(mouseX < maxX) || !(mouseY >= minY) || !(mouseY < maxY)) continue;
                return button;
            }
            return null;
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SPACE_FROM_RIGHT_SCREEN = 10;
        public static final int SPACE_BETWEEN_TEXT_AND_OPTION_FIELD = 8;
        public static final int BUTTON_WIDTH_SPACING = 5;
        public static final int RESET_BUTTON_WIDTH = 60;
        public static final int RESET_BUTTON_HEIGHT = 20;
        public static final int OPTION_FIELD_WIDTH = 150;
        public static final int OPTION_FIELD_HEIGHT = 20;
        public static final int CATEGORY_BUTTON_WIDTH = 200;
        public static final int CATEGORY_BUTTON_HEIGHT = 20;

        private ConfigScreenConfigs() {
        }
    }
}

