/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import loaderCommon.forge.com.seibel.distanthorizons.common.commands.ConfigCommand;
import loaderCommon.forge.com.seibel.distanthorizons.common.commands.CrashCommand;
import loaderCommon.forge.com.seibel.distanthorizons.common.commands.DebugCommand;
import loaderCommon.forge.com.seibel.distanthorizons.common.commands.PregenCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.jetbrains.annotations.Nullable;

public class CommandInitializer {
    private boolean serverReady = false;
    private static final int REQUIRED_PERMISSION_LEVEL = 4;
    @Nullable
    private CommandDispatcher<CommandSourceStack> commandDispatcher;

    public void onServerReady() {
        this.serverReady = true;
        if (this.commandDispatcher != null) {
            this.initCommands(this.commandDispatcher);
            this.commandDispatcher = null;
        }
    }

    public void initCommands(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        if (!this.serverReady) {
            this.commandDispatcher = commandDispatcher;
            return;
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"dh").requires(source -> source.m_6761_(4));
        builder.then(new ConfigCommand().buildCommand());
        builder.then(new DebugCommand().buildCommand());
        builder.then(new PregenCommand().buildCommand());
        if (MessageRegistry.DEBUG_CODEC_CRASH_MESSAGE) {
            builder.then(new CrashCommand().buildCommand());
        }
        commandDispatcher.register(builder);
    }
}

